#! /usr/bin/env lua

require('luaplot.dotlineplot')
require('luaplot.pnghandler')

-- Example of dot line plot.
local plot = luaplot.dotlineplot.new{
	data            = { {0, 2, 4, 3, -1}, {3, 5, 1, -4, -2} },
	top_bound       = 6,
	bottom_bound    = -6,
	h_labels        = {'2000', '2001', '2002', '2003', '2004'},
	v_labels        = luaplot.generatelabels(-6, 6, 2),
	series_colors   = { {1,0.3,0.3}, {0.3,1,0.3} },
	label_size      = 12,
	handler         = luaplot.pnghandler.new('out-dotlineplot.png'),
}

plot.bg_pattern = cairo.Pattern.create_linear(0, 0, plot.width, plot.height)
plot.bg_pattern:add_color_stop_rgb(0, 1, 1, 1)
plot.bg_pattern:add_color_stop_rgb(1, 0.9, 0.9, 0.9)

-- Render it
plot:render()
