#! /usr/bin/env lua

require('luaplot.barplot')
require('luaplot.legendplot')
require('luaplot.pnghandler')
require('luaplot.childhandler')

-- Example of bar plot.
local plot = luaplot.barplot.new{
	data            = {{50, -25, 200}, {125, -50, 100}},
	h_labels        = {'Group 1', 'Group 2'},
	v_labels        = luaplot.generatelabels(-50, 200, 25),
	series_colors   = {{1,0.3,0.3}, {0.3,1,0.3}, {0.0, 0.3, 1}},
	right_margin    = 100,
	label_scale     = true,
	label_size      = 10,
	line_scale      = true,
	handler         = luaplot.pnghandler.new('out-barplot.png'),
}

-- Create some useless legends
local legends = {}
for i = 1, 3 do
	legends[i] = luaplot.legendplot.new{
		v_labels        = {"Option 1", "Option 2", "Option 3"},
		series_colors   = plot.series_colors,
		label_color     = plot.label_color,
		width           = 100,
		height          = 100,
		handler         = luaplot.childhandler.new(plot, 300, (i - 1) * 100)
	}
end

-- Configure the legends to be plotted on the main ploting
plot.child = {legends[1], legends[2], legends[3]}

plot:render()
