#!/usr/bin/lua

require("DBus")

print("Creating first message")
msg,err = DBus.Message("net.sf.gaim.GaimService", "/net/sf/gaim/GaimObject", "net.sf.gaim.GaimInterface", "GaimAccountsFindConnected")
assert(msg, err)
print("Adding the arguments")
msg:append_args({"", "prpl-msn"})

print("Connecting to the session bus")
conn,err = DBus.Bus.get("session")
assert(conn, err)

print("Sending the message")
result,err = conn:send(msg, -1)
assert(result, err)

retargs = result:get_args()
account = retargs[1]

print("Creating second message")
msg2,err = DBus.Message("net.sf.gaim.GaimService", "/net/sf/gaim/GaimObject", "net.sf.gaim.GaimInterface", "GaimConversationNew")
assert(msg2, err)

dma = DBus.Message.Arg(1, "int32")
print(dma)
dma2 = DBus.Message.Arg(account, "int32")
print(dma2)
print("Appending arguments")
msg2:append_args({dma, dma2, "deryni9@hotmail.com"})
print_table(msg2:get_args())

print("Sending the second message")
result2,err = conn:send(msg2, -1)
assert(result2, err)

retargs2 = result2:get_args()
print_table(retargs2)
