#!/usr/bin/lua

require("DBus")

print("Creating first message")
msg,err = DBus.Message("net.sf.gaim.GaimService", "/net/sf/gaim/GaimObject", "net.sf.gaim.GaimInterface", "GaimAccountsGetAll")
assert(msg, err)
print("Adding the arguments")
msg:append_args({"string"})

print("Connecting to the session bus")
conn,err = DBus.Bus.get("session")
assert(conn, err)

print("Sending the message")
result,err = conn:send(msg, -1)
assert(result, err)

retargs = result:get_args()
print_table(retargs, true)
