#!/usr/bin/lua

require("DBus")

print("Creating first message")
msg,err = DBus.Message("net.sf.gaim.GaimService", "/net/sf/gaim/GaimObject", "net.sf.gaim.GaimInterface", "GaimAccountsFindConnected")
assert(msg, err)
print("Adding the argument")
msg:append_args({"", "prpl-msn"})

print("Connecting to the session bus")
conn,err = DBus.Bus.get("session")
assert(conn, err)

print("Sending the message")
result,err = conn:send(msg, -1)
assert(result, err)

retargs = result:get_args()
account = retargs[1]

print("Creating second message")
msg,err = DBus.Message("net.sf.gaim.GaimService", "/net/sf/gaim/GaimObject", "net.sf.gaim.GaimInterface", "GaimAccountGetUsername")
assert(msg, err)
dma = DBus.Message.Arg(account, "int32")
print(dma)
msg:append_args(dma)

result,err = conn:send(msg, -1)
assert(result, err)

retargs,err = result:get_args()
assert(retargs, err)
print_table(retargs)
