#! /usr/bin/env lua

require("lgob.utils")
local A = assert

A( basename('oi/myfile.ext') == 'oi/myfile' )
A( basename('t.lua') == 't' )
A( skipLib('GtkBin', 'Gtk') == 'Bin' )
A( skipFirst('GtkTest') == 'Test' )
A( skipFirst('gtk_test') == 'test' )
A( skipFirst('this_is_sparta') == 'is_sparta' )
A( regName('GtkCoolWidget', 'Gtk') == 'coolwidget' )
A( camelToC('GtkWidget') == 'gtk_widget' )
A( camelToC('GtkMyWidget') == 'gtk_my_widget' )
A( camelToC('GtkMyWidget64') == 'gtk_my_widget64' )
A( camelToC('GtkVBox') == 'gtk_vbox' )
A( camelToC('Gtk') == 'gtk' )
A( camelToC('a') == 'a' )
A( camelToC('G') == 'g' )
A( camelToC('Ae') == 'ae' )
A( camelToC('AeBe') == 'ae_be' )
A( skipClass('gtk_widget_show_all', 'GtkWidget', 'Gtk') == 'show_all' )
A( skipClass('gtk_vbox_my_method', 'GtkVBox', 'Gtk') == 'my_method' )
A( getPath('../kknd/file') == '../kknd/' )
A( mtName('GtkObject', 'Gtk', 'lgob') == 'lgobObjectMT' )
A( wrapName('gtk_my_function') == '_wrap_gtk_my_function' )
local v1, v2 = parseVersion('2.12')
A( v1 == 2 and v2 == 12 )
local v3, v4 = parseVersion('7.29.5')
A( v3 == 7 and v4 == 29 )
A( cmpVersion(v1, v2, v3, v4) < 0 )
A( cmpVersion(v3, v4, v1, v2) > 0 )
A( cmpVersion(v1, v2, v1, v2) == 0 )
local v5, v6 = parseVersion('2.20')
A( v5 == 2 and v6 == 20 )
A( cmpVersion(v5, v6, 2, 18) > 0 )
A( cmpVersion(2, 18, v5, v6) < 0 )
local t, n = getPropertyName('gtk_label_get_use_underline', 'GtkLabel', 'Gtk')
A( t == 'get' and n == 'use-underline' )
A( fullName('Atk.Implementor', 'Gtk') == "'AtkImplementor'" )
A( fullName('Implementor', 'Gtk') == "'GtkImplementor'" )
