--[[
	This file is part of luaplot.

	luaplot is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	luaplot is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with luaplot.  If not, see <http://www.gnu.org/licenses/>.
    
    Copyright (C) 2009-2010 Lucas Hermann Negri
--]]

luaplot = {}

---
-- Creates a table that returns the same value for every index.
function luaplot.always(value)
	local tbl = {}
	setmetatable(tbl, {__index = function() return value end})
	
	return tbl
end

function luaplot.generatelabels(lower, upper, step)
	if not step then
		step = math.ceil( (upper - lower) / 5 )
	end
	
	local tbl, ul = {}, upper + step
	
	while lower < ul do
		tbl[#tbl + 1] = lower
		lower = lower + step
	end
	
	return tbl, ul
end
