--[[
	This file is part of luaplot.

	luaplot is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	luaplot is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with luaplot.  If not, see <http://www.gnu.org/licenses/>.
    
    Copyright (C) 2009-2010 Lucas Hermann Negri
--]]

require('luaplot.basehandler')
require('lgob.gdk')

luaplot.gtkhandler = {}
setmetatable(luaplot.gtkhandler, {__index = luaplot.basehandler})

local gtkhandlermt = {__index = luaplot.gtkhandler}
local super = luaplot.basehandler

function luaplot.gtkhandler.new(widget)
	local self = {}
	setmetatable(self, gtkhandlermt)
	
	self.widget = widget
	
	return self
end

function luaplot.gtkhandler:prepare(plot)
	plot.cr = gdk.cairo_create(self.widget:get_window())
	plot.width, plot.height = self.widget:get_size()
	super.prepare(self, plot)
end

function luaplot.gtkhandler:commit(plot)
	plot.cr:destroy()
end

function luaplot.gtkhandler.expose(plot, event)
	local x, y, w, h = gdk.event_expose_get(event)
	plot:render(x, y, w, h)
	
	return true
end
