#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai

__license__   = 'GPL v3'
__copyright__ = '2010, Kovid Goyal <kovid@kovidgoyal.net>'
__docformat__ = 'restructuredtext en'

from calibre.customize import InterfaceActionBase
 
class ActionSplitPdf(InterfaceActionBase):
    name                = 'Split pdf'
    description         = 'Split two-up pdf books down the middle'
    supported_platforms = ['linux'] # Platforms this plugin will run on
    author              = 'Joshua Mendelsohn'
    version             = (1, 0, 0)

    def load_actual_plugin(self, gui):
        import subprocess
        from functools import partial
        from PyQt4.Qt import QMenu, QToolButton
        from calibre.gui2 import error_dialog
#        from calibre.utils.config import tweaks
        from calibre.gui2.actions import InterfaceAction
#        from calibre.constants import iswindows

        class OpenEpubInEditorAction(InterfaceAction):

            name = 'Split PDF down the middle'
            action_spec = (_('Split PDF down the middle'), None, None, None)
            action_type = 'current'

            def genesis(self):
                self.qaction.triggered.connect(self.split_pdf)

            def split_pdf(self, tokenised_url):
                row = self.gui.library_view.currentIndex()
                if not row.isValid():
                    return error_dialog(self.gui, _('Can not split pdf'),
                            _('No book selected'), show=True)
        
                # Confirm 'PDF' in formats
                book_id = self.gui.library_view.model().id(row)
                try:
                    path_to_pdf = self.gui.library_view.model().db.format_abspath(
                            book_id, 'PDF', index_is_id=True)
                except:
                    path_to_pdf = None
        
                if not path_to_pdf:
                    return error_dialog(self.gui, _('Cannot process pdf'),
                            _('No pdf available. First convert the book to pdf.'),
                            show=True)
               
#                if iswindows:
#                    DETACHED_PROCESS = 0x00000008
#                    subprocess.Popen([editor_path, path_to_epub], creationflags=DETACHED_PROCESS)
#                else:
                    subprocess.Popen(['unpnup', path_to_pdf, '~'])
                
        return OpenEpubInEditorAction(gui, None)