#!/bin/sh

# Adapt gconf to bind fb2 files with uds
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
/bin/cp -f /media/mmcblk0p1/Programs/_fb2plugin/files/fb2.schemas /etc/gconf/schemas/fb2.schemas
gconftool-2 --makefile-install-rule /etc/gconf/schemas/fb2.schemas

# If the schema was already installed make sure it gets the correct value
gconftool-2 --type list --list-type=string --set /apps/er/sys/ctb/filetypes/doc-fb2/extensions "[fb2]"
gconftool-2 --type string --set /apps/er/sys/ctb/filetypes/doc-fb2/icon_name "fb2"
gconftool-2 --type string --set /apps/er/sys/ctb/filetypes/doc-fb2/viewer_cmd "uds"

# and save current settings to disk
/usr/bin/erconftool -e /apps/er

# Copy the fb2-filetype icons
/bin/cp -f /media/mmcblk0p1/Programs/_fb2plugin/files/icon-fb2-medium.png      /usr/share/ctb/icon-fb2-medium.png
/bin/cp -f /media/mmcblk0p1/Programs/_fb2plugin/files/icon-fb2-mini.png        /usr/share/ctb/icon-fb2-mini.png
/bin/cp -f /media/mmcblk0p1/Programs/_fb2plugin/files/icon-fb2-small.png       /usr/share/ctb/icon-fb2-small.png

# Copy the extra libraries needed for the plugin
/bin/cp -f /media/mmcblk0p1/Programs/_fb2plugin/files/libuds-plugin-fb2.so     /usr/lib/uds/libuds-plugin-fb2.so

/sbin/reboot
sleep 31
