import os
from calibre.devices.usbms.driver import USBMS

class OYO(USBMS):

    name           = 'Medion OYO Device Interface'
    gui_name       = 'OYO'
    description    = _('Communicate with the Medion OYO')
    author         = 'Jan Beisenkamp'
    supported_platforms = ['windows', 'osx', 'linux']

    # Ordered list of supported formats
    FORMATS     = ['epub', 'html', 'pdf', 'txt']

    VENDOR_ID   = [0x0525]
    PRODUCT_ID  = [0xa4a5]
    BCD         = [0x0319]

    VENDOR_NAME = 'E-BOOK'
    WINDOWS_MAIN_MEM = WINDOWS_CARD_A_MEM = 'READER'

    EBOOK_DIR_MAIN = ''
    SUPPORTS_SUB_DIRS = True

    def upload_cover(self, path, filename, metadata, filepath):
        coverdata = getattr(metadata, 'thumbnail', None)
        if coverdata and coverdata[2]:
            if not os.path.exists(os.path.join(path,'.info')):
                os.mkdir(os.path.join(path,'.info'))
            with open('%s.jpg' % os.path.join(path,'.info', filename+'.'+filepath.rpartition('.')[2]), 'wb') as coverfile:
                coverfile.write(coverdata[2])


