#!/bin/sh
dir=`/usr/bin/dirname $0`
credential="$dir/credential"
manifest="$dir/manifest.sh"
date=`date +%FT%T`
name='Select Network Profile'

essid=`cat "$dir/nextid"`
PROFILE=/mnt/settings/registry/nwprofiles.xml
sed -e 's/<profileName>/\n/g' $PROFILE |sed -e 's/<[^>]*>/"/g'|grep WIRELESS|cut -d\" -f10,12,14 > "$credential"
essids=`cat "$credential"|cut -d\" -f1|sed -e 's/ /_/g'`

firstid=""
nextid=""
lastid=""
for fid in $essids
do
  id=`echo $fid|sed -e 's/_/ /g'`
  if [ -z "$firstid" ]
  then
    firstid=$id
  fi
  if [ "$essid" = "$lastid" ]
  then
    nextid=$id
  fi
  lastid=$id
done
if [ -z "$essid" ]
then
  essid=$lastid
fi
if [ "$essid" = "$lastid" ]
then
  nextid=$firstid
fi
#echo essid=$essid nextid=$nextid lastid=$lastid firstid=$firstid

if [ -z "$essid" ]
then
  "$manifest" "$name" "No wireless profile is found." "$date" profile.sh
else
  echo "$essid" > "$dir/../connect/essid"
  if [ "$essid" = "$nextid" ]
  then
    "$manifest" "$name" "Current is $essid." "$date" profile.sh
  else
    "$manifest" "$name" "Current is $essid. Next is $nextid." "$date" profile.sh
    echo $nextid > "$dir/nextid"
  fi
fi
