/*
 * Decompiled with CFR 0.152.
 */
package cantigui;

import cantigui.ErrorLog;
import java.awt.Component;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SystemConsole
extends JTextArea {
    private PipedInputStream pi_system_out = null;
    private PipedInputStream pi_system_err = null;
    private PipedOutputStream po_system_out = null;
    private PipedOutputStream po_system_err = null;
    private String thread_name_pi_out = "Thread_pi_system_out";
    private String thread_name_pi_err = "Thread_pi_system_err";
    private String thread_name_pi_out_monitor = "Thread_pi_system_out_monitor";
    private String thread_name_pi_err_monitor = "Thread_pi_system_err_monitor";

    public SystemConsole(JFrame frame) {
        this.setEditable(false);
        this.setRows(20);
        this.setColumns(50);
        frame.getContentPane().add((Component)new JScrollPane(this), "Center");
        this.setVisible(true);
        try {
            this.pi_system_out = new PipedInputStream();
            this.po_system_out = new PipedOutputStream(this.pi_system_out);
            System.setOut(new PrintStream(this.po_system_out, true));
            this.pi_system_err = new PipedInputStream();
            this.po_system_err = new PipedOutputStream(this.pi_system_err);
            System.setErr(new PrintStream(this.po_system_err, true));
        }
        catch (IOException e) {
            ErrorLog.append(e);
        }
        PipedInputThread rt_piOut = new PipedInputThread(this.pi_system_out, this.thread_name_pi_out);
        PipedInputThread rt_piErr = new PipedInputThread(this.pi_system_err, this.thread_name_pi_err);
        new PipedInputMonitorThread(rt_piOut, this.thread_name_pi_out_monitor).start();
        new PipedInputMonitorThread(rt_piErr, this.thread_name_pi_err_monitor).start();
    }

    class PipedInputThread
    extends Thread {
        PipedInputStream pi;

        PipedInputThread(PipedInputStream pi) {
            this.pi = pi;
        }

        PipedInputThread(PipedInputStream pi, String name) {
            this.pi = pi;
            this.setName(name);
        }

        public void run() {
            byte[] buf = new byte[1024];
            try {
                while (true) {
                    int len;
                    if ((len = this.pi.read(buf)) == -1) {
                        continue;
                    }
                    SystemConsole.this.append(new String(buf, 0, len));
                    SystemConsole.this.setCaretPosition(SystemConsole.this.getDocument().getLength());
                }
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    class PipedInputMonitorThread
    extends Thread {
        PipedInputThread rt;

        PipedInputMonitorThread(PipedInputThread rt, String name) {
            this.rt = rt;
            this.setName(name);
        }

        public void run() {
            this.rt.start();
            while (true) {
                try {
                    if (this.rt.getState() == Thread.State.TERMINATED) {
                        if (this.rt.getName().equals(SystemConsole.this.thread_name_pi_out)) {
                            SystemConsole.this.pi_system_out = new PipedInputStream();
                            SystemConsole.this.po_system_out = new PipedOutputStream(SystemConsole.this.pi_system_out);
                            System.setOut(new PrintStream(SystemConsole.this.po_system_out, true));
                            this.rt = new PipedInputThread(SystemConsole.this.pi_system_out, SystemConsole.this.thread_name_pi_out);
                            this.rt.start();
                        } else if (this.rt.getName().equals(SystemConsole.this.thread_name_pi_err)) {
                            SystemConsole.this.pi_system_err = new PipedInputStream();
                            SystemConsole.this.po_system_err = new PipedOutputStream(SystemConsole.this.pi_system_err);
                            System.setErr(new PrintStream(SystemConsole.this.po_system_err, true));
                            this.rt = new PipedInputThread(SystemConsole.this.pi_system_err, SystemConsole.this.thread_name_pi_err);
                            this.rt.start();
                        }
                    }
                }
                catch (IOException e) {
                    ErrorLog.append(e);
                }
                try {
                    PipedInputMonitorThread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    ErrorLog.append(e);
                    continue;
                }
                break;
            }
        }
    }
}

