/*
 * Decompiled with CFR 0.152.
 */
package cantigui;

import cantigui.CGJobLoader;
import java.util.ArrayList;
import java.util.Comparator;

public class CGJob {
    protected static final int NUM_FIELDS = 14;
    private String job_id = CGJob.determineAvailableJobID();
    private String parent_folder = null;
    private String title = null;
    private String output_folder = null;
    private boolean manga_prefix_enabled = false;
    private String manga_prefix = null;
    private boolean bind_prefix_enabled = false;
    private String bind_prefix = null;
    private boolean use_original_filenames_enabled = false;
    private boolean auto_bind_enabled = false;
    private String auto_bind = null;
    private boolean num_chars_keep_suffix_enabled = false;
    private String num_chars_keep_suffix = null;
    private String canti_properties_file = null;
    protected static Comparator<CGJob> comp_title_order = new Comparator<CGJob>(){

        @Override
        public int compare(CGJob cgjob1, CGJob cgjob2) {
            String cgjob1_title = cgjob1.getTitle();
            String cgjob2_title = cgjob2.getTitle();
            return cgjob1_title.compareTo(cgjob2_title);
        }
    };

    protected static String determineAvailableJobID() {
        ArrayList<CGJob> cgjob_list = CGJobLoader.getCGJobList();
        if (cgjob_list == null || cgjob_list.isEmpty()) {
            return "0";
        }
        int new_job_id_num = 0;
        boolean done = false;
        while (!done) {
            boolean job_id_already_taken = false;
            for (int i = 0; !job_id_already_taken && i < cgjob_list.size(); ++i) {
                if (!cgjob_list.get(i).getJobID().equals(String.valueOf(new_job_id_num))) continue;
                job_id_already_taken = true;
            }
            if (!job_id_already_taken) {
                done = true;
                continue;
            }
            ++new_job_id_num;
        }
        return String.valueOf(new_job_id_num);
    }

    public void setJobID(String job_id) {
        this.job_id = job_id;
    }

    public void setParentFolder(String parent_folder) {
        this.parent_folder = parent_folder;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setOutputFolder(String output_folder) {
        this.output_folder = output_folder;
    }

    public void setMangaPrefixEnabled(boolean manga_prefix_enabled) {
        this.manga_prefix_enabled = manga_prefix_enabled;
    }

    public void setMangaPrefix(String manga_prefix) {
        this.manga_prefix = manga_prefix;
    }

    public void setBindPrefixEnabled(boolean bind_prefix_enabled) {
        this.bind_prefix_enabled = bind_prefix_enabled;
    }

    public void setBindPrefix(String bind_prefix) {
        this.bind_prefix = bind_prefix;
    }

    public void setUseOriginalFilenamesEnabled(boolean use_original_filenames_enabled) {
        this.use_original_filenames_enabled = use_original_filenames_enabled;
    }

    public void setAutoBindEnabled(boolean auto_bind_enabled) {
        this.auto_bind_enabled = auto_bind_enabled;
    }

    public void setAutoBind(String auto_bind) {
        this.auto_bind = auto_bind;
    }

    public void setNumCharsKeepSuffixEnabled(boolean num_chars_keep_suffix_enabled) {
        this.num_chars_keep_suffix_enabled = num_chars_keep_suffix_enabled;
    }

    public void setNumCharsKeepSuffix(String num_chars_keep_suffix) {
        this.num_chars_keep_suffix = num_chars_keep_suffix;
    }

    public void setCantiPropertiesFile(String canti_properties_file) {
        this.canti_properties_file = canti_properties_file;
    }

    public String getJobID() {
        return this.job_id;
    }

    public String getParentFolder() {
        return this.parent_folder;
    }

    public String getTitle() {
        return this.title;
    }

    public String getOutputFolder() {
        return this.output_folder;
    }

    public boolean getMangaPrefixEnabled() {
        return this.manga_prefix_enabled;
    }

    public String getMangaPrefix() {
        return this.manga_prefix;
    }

    public boolean getBindPrefixEnabled() {
        return this.bind_prefix_enabled;
    }

    public String getBindPrefix() {
        return this.bind_prefix;
    }

    public boolean getUseOriginalFilenamesEnabled() {
        return this.use_original_filenames_enabled;
    }

    public boolean getAutoBindEnabled() {
        return this.auto_bind_enabled;
    }

    public String getAutoBind() {
        return this.auto_bind;
    }

    public boolean getNumCharsKeepSuffixEnabled() {
        return this.num_chars_keep_suffix_enabled;
    }

    public String getNumCharsKeepSuffix() {
        return this.num_chars_keep_suffix;
    }

    public String getCantiPropertiesFile() {
        return this.canti_properties_file;
    }

    public boolean isValid() {
        return this.parent_folder != null && !this.parent_folder.isEmpty() && this.title != null && !this.title.isEmpty() && this.canti_properties_file != null && !this.canti_properties_file.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.auto_bind == null ? 0 : this.auto_bind.hashCode());
        result = 31 * result + (this.auto_bind_enabled ? 1231 : 1237);
        result = 31 * result + (this.bind_prefix == null ? 0 : this.bind_prefix.hashCode());
        result = 31 * result + (this.bind_prefix_enabled ? 1231 : 1237);
        result = 31 * result + (this.canti_properties_file == null ? 0 : this.canti_properties_file.hashCode());
        result = 31 * result + (this.manga_prefix == null ? 0 : this.manga_prefix.hashCode());
        result = 31 * result + (this.manga_prefix_enabled ? 1231 : 1237);
        result = 31 * result + (this.num_chars_keep_suffix == null ? 0 : this.num_chars_keep_suffix.hashCode());
        result = 31 * result + (this.num_chars_keep_suffix_enabled ? 1231 : 1237);
        result = 31 * result + (this.output_folder == null ? 0 : this.output_folder.hashCode());
        result = 31 * result + (this.parent_folder == null ? 0 : this.parent_folder.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.use_original_filenames_enabled ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CGJob other = (CGJob)obj;
        if (this.auto_bind == null ? other.auto_bind != null : !this.auto_bind.equals(other.auto_bind)) {
            return false;
        }
        if (this.auto_bind_enabled != other.auto_bind_enabled) {
            return false;
        }
        if (this.bind_prefix == null ? other.bind_prefix != null : !this.bind_prefix.equals(other.bind_prefix)) {
            return false;
        }
        if (this.bind_prefix_enabled != other.bind_prefix_enabled) {
            return false;
        }
        if (this.canti_properties_file == null ? other.canti_properties_file != null : !this.canti_properties_file.equals(other.canti_properties_file)) {
            return false;
        }
        if (this.manga_prefix == null ? other.manga_prefix != null : !this.manga_prefix.equals(other.manga_prefix)) {
            return false;
        }
        if (this.manga_prefix_enabled != other.manga_prefix_enabled) {
            return false;
        }
        if (this.num_chars_keep_suffix == null ? other.num_chars_keep_suffix != null : !this.num_chars_keep_suffix.equals(other.num_chars_keep_suffix)) {
            return false;
        }
        if (this.num_chars_keep_suffix_enabled != other.num_chars_keep_suffix_enabled) {
            return false;
        }
        if (this.output_folder == null ? other.output_folder != null : !this.output_folder.equals(other.output_folder)) {
            return false;
        }
        if (this.parent_folder == null ? other.parent_folder != null : !this.parent_folder.equals(other.parent_folder)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        return this.use_original_filenames_enabled == other.use_original_filenames_enabled;
    }
}

