/*
 * Decompiled with CFR 0.152.
 */
package manga;

import common.utils.FileUtils;
import common.utils.JarUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class BatchCreator {
    private File parent_folder;
    private File output_folder;
    private File lowercase_title_file = new File("lowercase_title.txt");
    private ArrayList<String> lowercase_title_list;

    public BatchCreator(File parent_folder, File output_folder) {
        this.parent_folder = parent_folder;
        this.output_folder = output_folder;
        this.readLowercaseTitleFile();
    }

    private void readLowercaseTitleFile() {
        this.lowercase_title_list = new ArrayList();
        if (!this.lowercase_title_file.exists()) {
            JarUtils ju = new JarUtils();
            ju.copyJarFileToFilesystem("/manga/batch/default_lowercase_title.txt", this.lowercase_title_file);
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.lowercase_title_file));
            while ((line = br.readLine()) != null) {
                if (!line.isEmpty() && line.charAt(0) != '/' && line.charAt(0) != '#' && Character.isLowerCase(line.charAt(0))) {
                    if (line.length() == 1) {
                        line = line.toUpperCase();
                    } else {
                        char uppercase_first_char = Character.toUpperCase(line.charAt(0));
                        line = String.valueOf(uppercase_first_char) + line.substring(1);
                    }
                }
                this.lowercase_title_list.add(line);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createBatchFile() {
        if (!this.parent_folder.exists()) {
            System.out.println("ERROR: Couldn't find folder: " + this.parent_folder.getAbsolutePath());
            System.exit(1);
        }
        boolean is_linux = false;
        boolean is_windows = false;
        boolean is_mac = false;
        String os_name = System.getProperty("os.name");
        String os_name_lowercase = os_name.toLowerCase();
        if (os_name_lowercase.contains("nux") || os_name_lowercase.contains("nix")) {
            is_linux = true;
        } else if (os_name_lowercase.contains("win")) {
            is_windows = true;
        } else if (os_name_lowercase.contains("mac")) {
            is_mac = true;
        } else {
            System.out.println("Sorry, your operating system (" + os_name + ") is currently not supported for batch file creation.");
            System.exit(1);
        }
        ArrayList<File> parent_folder_subfolders = FileUtils.getFolderList(this.parent_folder);
        Collections.sort(parent_folder_subfolders);
        ArrayList<String> parent_folder_paths = new ArrayList<String>(parent_folder_subfolders.size());
        int i = 0;
        while (i < parent_folder_subfolders.size()) {
            parent_folder_paths.add(String.valueOf(parent_folder_subfolders.get(i).getAbsolutePath()) + File.separatorChar);
            ++i;
        }
        ArrayList<String> titles = new ArrayList<String>(parent_folder_subfolders.size());
        int i2 = 0;
        while (i2 < parent_folder_subfolders.size()) {
            String cur_subfolder_name = parent_folder_subfolders.get(i2).getName();
            cur_subfolder_name = cur_subfolder_name.replaceAll("_", " ");
            int j = 1;
            while (j < cur_subfolder_name.length()) {
                boolean add_space = false;
                char cur_char = cur_subfolder_name.charAt(j);
                char prev_char = cur_subfolder_name.charAt(j - 1);
                if (Character.isUpperCase(cur_char) && !Character.isUpperCase(prev_char) && prev_char != '-' && prev_char != '.' && prev_char != '+') {
                    add_space = true;
                }
                if (Character.isDigit(cur_char) && !Character.isDigit(prev_char) && prev_char != '-' && prev_char != '.' && prev_char != '+') {
                    add_space = true;
                }
                if (prev_char == ' ') {
                    add_space = false;
                }
                if (add_space) {
                    cur_subfolder_name = String.valueOf(cur_subfolder_name.substring(0, j)) + " " + cur_subfolder_name.substring(j, cur_subfolder_name.length());
                    ++j;
                }
                ++j;
            }
            titles.add(cur_subfolder_name);
            ++i2;
        }
        ArrayList<String> output_folder_paths = new ArrayList<String>(parent_folder_subfolders.size());
        int i3 = 0;
        while (i3 < titles.size()) {
            String cur_title_no_spaces = ((String)titles.get(i3)).replaceAll(" ", "_");
            output_folder_paths.add(String.valueOf(this.output_folder.getAbsolutePath()) + File.separatorChar + cur_title_no_spaces + File.separatorChar);
            ++i3;
        }
        File batch_file = null;
        if (is_linux || is_mac) {
            batch_file = new File("process_all_manga.sh");
        } else if (is_windows) {
            batch_file = new File("process_all_manga.bat");
        }
        batch_file.delete();
        try {
            batch_file.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(batch_file));
            if (is_linux || is_mac) {
                bw.write("#!/bin/sh\n");
            }
            String os_quote = null;
            if (is_linux || is_mac) {
                os_quote = "'";
            } else if (is_windows) {
                os_quote = "\"";
            }
            int i4 = 0;
            while (i4 < parent_folder_subfolders.size()) {
                String cur_parent_folder_path = (String)parent_folder_paths.get(i4);
                String cur_title = (String)titles.get(i4);
                String cur_output_folder_path = (String)output_folder_paths.get(i4);
                String manga_prefix = null;
                String bind_prefix = null;
                File bind_file = new File(String.valueOf(cur_parent_folder_path) + "bind.txt");
                if (bind_file.exists()) {
                    bind_prefix = "Vol.";
                } else {
                    manga_prefix = "Ch.";
                }
                if (is_linux || is_mac) {
                    cur_parent_folder_path = cur_parent_folder_path.replaceAll("'", "'\\\\''");
                    cur_title = cur_title.replaceAll("'", "'\\\\''");
                    cur_output_folder_path = cur_output_folder_path.replaceAll("'", "'\\\\''");
                }
                String[] cur_title_split = cur_title.split(" ");
                int j = 1;
                while (j < cur_title_split.length) {
                    String cur_split = cur_title_split[j];
                    if (this.lowercase_title_list.contains(cur_split)) {
                        cur_title_split[j] = cur_title_split[j].toLowerCase();
                    }
                    ++j;
                }
                cur_title = cur_title_split[0];
                j = 1;
                while (j < cur_title_split.length) {
                    cur_title = String.valueOf(cur_title) + " " + cur_title_split[j];
                    ++j;
                }
                String[] cur_output_folder_path_split = cur_output_folder_path.split("_");
                int j2 = 1;
                while (j2 < cur_output_folder_path_split.length) {
                    String cur_split = cur_output_folder_path_split[j2];
                    if (this.lowercase_title_list.contains(cur_split)) {
                        cur_output_folder_path_split[j2] = cur_output_folder_path_split[j2].toLowerCase();
                    }
                    ++j2;
                }
                cur_output_folder_path = cur_output_folder_path_split[0];
                j2 = 1;
                while (j2 < cur_output_folder_path_split.length) {
                    cur_output_folder_path = String.valueOf(cur_output_folder_path) + "_" + cur_output_folder_path_split[j2];
                    ++j2;
                }
                if (is_windows) {
                    cur_parent_folder_path = cur_parent_folder_path.replaceAll("\\\\", "\\\\\\\\");
                    cur_output_folder_path = cur_output_folder_path.replaceAll("\\\\", "\\\\\\\\");
                }
                String command_line = "java -jar Canti.jar -parent_folder " + os_quote + cur_parent_folder_path + os_quote + " -title " + os_quote + cur_title + os_quote + " -output_folder " + os_quote + cur_output_folder_path + os_quote;
                if (manga_prefix != null) {
                    command_line = String.valueOf(command_line) + " -manga_prefix \"" + manga_prefix + "\"";
                }
                if (bind_prefix != null) {
                    command_line = String.valueOf(command_line) + " -bind_prefix \"" + bind_prefix + "\"";
                }
                bw.write(String.valueOf(command_line) + "\n");
                ++i4;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

