/*
 * Decompiled with CFR 0.152.
 */
package cantigui;

import cantigui.Main;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class ErrorLog {
    private static String time_stamp_format = "yyyy-MM-dd_HH:mm:ss";
    private static File error_log_file = new File(Main.DATA_DIR + "err_log_" + ErrorLog.getCurrentTimeStamp() + ".txt");

    public static void append(String str) {
        try {
            if (!error_log_file.exists()) {
                error_log_file.createNewFile();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(error_log_file, true));
            bw.write(str + "\n\n");
            bw.close();
        }
        catch (IOException e) {
            ErrorLog.append(e);
        }
    }

    public static void append(Exception e) {
        try {
            if (!error_log_file.exists()) {
                error_log_file.createNewFile();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(error_log_file, true));
            StackTraceElement[] ste = e.getStackTrace();
            for (int i = 0; i < ste.length; ++i) {
                bw.write(ste[i].toString() + "\n");
            }
            bw.write("\n");
            bw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static String getCurrentTimeStamp() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(time_stamp_format);
        return sdf.format(cal.getTime());
    }
}

