/*
 * Decompiled with CFR 0.152.
 */
package cantigui;

import cantigui.CGJob;
import cantigui.CGJobLoader;
import cantigui.CGJobTableModel;
import cantigui.CGJobWriter;
import cantigui.CGPropertiesLoader;
import cantigui.CGPropertiesWriter;
import cantigui.CantiPropertiesFileFilter;
import cantigui.ConvertMangaMonitorThread;
import cantigui.ConvertMangaThread;
import cantigui.ErrorLog;
import cantigui.Main;
import cantigui.ParentFolderFileFilter;
import cantigui.SystemConsole;
import common.utils.JarUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import manga.CMPropertiesWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CantiGUIFrame
extends JFrame {
    private ConvertMangaThread cmt = null;
    private CGJobTableModel cgjtm = new CGJobTableModel();
    protected static final String PROGRAM_VERSION = "1.00a";
    protected static final String RELEASED_DATE = "November 17, 2010";
    protected static final File PROPERTIES_FILE = new File(Main.DATA_DIR.getAbsolutePath() + File.separatorChar + "CantiGUI.properties");
    protected static final File JOBS_FILE = new File(Main.DATA_DIR.getAbsolutePath() + File.separatorChar + "CantiGUI_jobs.txt");
    private JButton jButton_jobs_delete;
    private JButton jButton_jobs_load;
    private JButton jButton_output_folder;
    private JButton jButton_parent_folder;
    private JButton jButton_properties_cancel;
    private JButton jButton_properties_create;
    private JButton jButton_properties_folder;
    private JButton jButton_properties_load;
    private JButton jButton_properties_new;
    private JButton jButton_properties_refresh;
    private JButton jButton_properties_save;
    private JButton jButton_run;
    private JCheckBox jCheckBox_auto_bind;
    private JCheckBox jCheckBox_bind_prefix;
    private JCheckBox jCheckBox_manga_prefix;
    private JCheckBox jCheckBox_num_chars_keep_suffix;
    private JCheckBox jCheckBox_use_original_filenames;
    private JComboBox jComboBox_bind_prefix;
    private JComboBox jComboBox_manga_prefix;
    private JComboBox jComboBox_properties_device;
    private JDialog jDialog_about;
    private JDialog jDialog_contents;
    private JDialog jDialog_jobs;
    private JDialog jDialog_properties_new;
    private JFileChooser jFileChooser_output_folder;
    private JFileChooser jFileChooser_parent_folder;
    private JFileChooser jFileChooser_properties_load;
    private JFileChooser jFileChooser_properties_new;
    private JLabel jLabel_check_box_to_enable;
    private JLabel jLabel_properties_file;
    private JLabel jLabel_select_your_device;
    private JLabel jLabel_set_value;
    private JLabel jLabel_title;
    private JMenuBar jMenuBar_main;
    private JMenuItem jMenuItem_about;
    private JMenuItem jMenuItem_contents;
    private JMenuItem jMenuItem_exit;
    private JMenuItem jMenuItem_load_job;
    private JMenuItem jMenuItem_save_job;
    private JMenu jMenu_file;
    private JMenu jMenu_help;
    private JPanel jPanel_advanced;
    private JPanel jPanel_run;
    private JPanel jPanel_settings;
    private JScrollPane jScrollPane_console;
    private JScrollPane jScrollPane_contents;
    private JScrollPane jScrollPane_jobs;
    private JScrollPane jScrollPane_license;
    private JScrollPane jScrollPane_properties;
    private JSeparator jSeparator_contents;
    private JSeparator jSeparator_settings;
    private JSpinner jSpinner_auto_bind;
    private JSpinner jSpinner_num_chars_keep_suffix;
    private JTabbedPane jTabbedPane_main;
    private JTable jTable_jobs;
    private JTextArea jTextArea_about;
    private JTextArea jTextArea_console;
    private JTextArea jTextArea_contents;
    private JTextArea jTextArea_license;
    private JTextField jTextField1;
    private JTextField jTextField_output_folder;
    private JTextField jTextField_parent_folder;
    private JTextField jTextField_properties;
    private JTextField jTextField_properties_folder;
    private JTextField jTextField_title;
    private JTextPane jTextPane_properties;

    public CantiGUIFrame() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            ErrorLog.append(e);
        }
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.checkCantiPropertiesFile();
    }

    private void initComponents() {
        this.jFileChooser_parent_folder = new JFileChooser();
        this.jFileChooser_output_folder = new JFileChooser();
        this.jFileChooser_properties_load = new JFileChooser();
        this.jDialog_properties_new = new JDialog();
        this.jLabel_select_your_device = new JLabel();
        this.jComboBox_properties_device = new JComboBox();
        this.jButton_properties_folder = new JButton();
        this.jButton_properties_create = new JButton();
        this.jButton_properties_cancel = new JButton();
        this.jTextField_properties_folder = new JTextField();
        this.jFileChooser_properties_new = new JFileChooser();
        this.jDialog_jobs = new JDialog();
        this.jScrollPane_jobs = new JScrollPane();
        this.jTable_jobs = new JTable();
        this.jButton_jobs_load = new JButton();
        this.jButton_jobs_delete = new JButton();
        this.jDialog_about = new JDialog();
        this.jTextArea_about = new JTextArea();
        this.jTextField1 = new JTextField();
        this.jSeparator_contents = new JSeparator();
        this.jScrollPane_license = new JScrollPane();
        this.jTextArea_license = new JTextArea();
        this.jDialog_contents = new JDialog();
        this.jScrollPane_contents = new JScrollPane();
        this.jTextArea_contents = new JTextArea();
        this.jTabbedPane_main = new JTabbedPane();
        this.jPanel_run = new JPanel();
        this.jButton_parent_folder = new JButton();
        this.jLabel_title = new JLabel();
        this.jButton_run = new JButton();
        this.jScrollPane_console = new JScrollPane();
        this.jTextArea_console = new SystemConsole(this);
        this.jTextField_parent_folder = new JTextField();
        this.jTextField_title = new JTextField();
        this.jButton_output_folder = new JButton();
        this.jTextField_output_folder = new JTextField();
        this.jPanel_advanced = new JPanel();
        this.jCheckBox_manga_prefix = new JCheckBox();
        this.jCheckBox_bind_prefix = new JCheckBox();
        this.jCheckBox_use_original_filenames = new JCheckBox();
        this.jCheckBox_auto_bind = new JCheckBox();
        this.jCheckBox_num_chars_keep_suffix = new JCheckBox();
        this.jComboBox_manga_prefix = new JComboBox();
        this.jComboBox_bind_prefix = new JComboBox();
        this.jLabel_check_box_to_enable = new JLabel();
        this.jSpinner_auto_bind = new JSpinner(new SpinnerNumberModel(0, 0, 200, 1));
        this.jSpinner_num_chars_keep_suffix = new JSpinner(new SpinnerNumberModel(0, 0, 10, 1));
        this.jLabel_set_value = new JLabel();
        this.jPanel_settings = new JPanel();
        this.jLabel_properties_file = new JLabel();
        this.jTextField_properties = new JTextField();
        this.jButton_properties_load = new JButton();
        this.jButton_properties_new = new JButton();
        this.jScrollPane_properties = new JScrollPane();
        this.jTextPane_properties = new JTextPane(){

            public boolean getScrollableTracksViewportWidth() {
                return false;
            }
        };
        this.jSeparator_settings = new JSeparator();
        this.jButton_properties_save = new JButton();
        this.jButton_properties_refresh = new JButton();
        this.jMenuBar_main = new JMenuBar();
        this.jMenu_file = new JMenu();
        this.jMenuItem_load_job = new JMenuItem();
        this.jMenuItem_save_job = new JMenuItem();
        this.jMenuItem_exit = new JMenuItem();
        this.jMenu_help = new JMenu();
        this.jMenuItem_contents = new JMenuItem();
        this.jMenuItem_about = new JMenuItem();
        this.jFileChooser_parent_folder.setAcceptAllFileFilterUsed(false);
        this.jFileChooser_parent_folder.setFileFilter(new ParentFolderFileFilter());
        this.jFileChooser_parent_folder.setFileSelectionMode(2);
        this.jFileChooser_output_folder.setAcceptAllFileFilterUsed(false);
        this.jFileChooser_output_folder.setFileSelectionMode(1);
        this.jFileChooser_properties_load.setAcceptAllFileFilterUsed(false);
        this.jFileChooser_properties_load.setFileFilter(new CantiPropertiesFileFilter());
        this.jLabel_select_your_device.setText("Select your device:");
        this.jComboBox_properties_device.setModel(new DefaultComboBoxModel<String>(CMPropertiesWriter.getSupportedDevices().split(", ")));
        this.jButton_properties_folder.setText("Destination Folder");
        this.jButton_properties_folder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jButton_properties_folderActionPerformed(evt);
            }
        });
        this.jButton_properties_create.setText("Create");
        this.jButton_properties_create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jButton_properties_createActionPerformed(evt);
            }
        });
        this.jButton_properties_cancel.setText("Cancel");
        this.jButton_properties_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jButton_properties_cancelActionPerformed(evt);
            }
        });
        GroupLayout jDialog_properties_newLayout = new GroupLayout(this.jDialog_properties_new.getContentPane());
        this.jDialog_properties_new.getContentPane().setLayout(jDialog_properties_newLayout);
        jDialog_properties_newLayout.setHorizontalGroup(jDialog_properties_newLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog_properties_newLayout.createSequentialGroup().addContainerGap().addGroup(jDialog_properties_newLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog_properties_newLayout.createSequentialGroup().addComponent(this.jLabel_select_your_device).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_properties_device, -2, -1, -2)).addGroup(jDialog_properties_newLayout.createSequentialGroup().addComponent(this.jButton_properties_folder).addGap(18, 18, 18).addComponent(this.jTextField_properties_folder, -1, 223, Short.MAX_VALUE)).addGroup(jDialog_properties_newLayout.createSequentialGroup().addComponent(this.jButton_properties_create).addGap(18, 18, 18).addComponent(this.jButton_properties_cancel))).addContainerGap()));
        jDialog_properties_newLayout.setVerticalGroup(jDialog_properties_newLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog_properties_newLayout.createSequentialGroup().addContainerGap().addGroup(jDialog_properties_newLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_select_your_device).addComponent(this.jComboBox_properties_device, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jDialog_properties_newLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_properties_folder).addComponent(this.jTextField_properties_folder, -2, -1, -2)).addGap(18, 18, 18).addGroup(jDialog_properties_newLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_properties_cancel).addComponent(this.jButton_properties_create)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jDialog_properties_new.pack();
        this.jFileChooser_properties_new.setAcceptAllFileFilterUsed(false);
        this.jFileChooser_properties_new.setFileSelectionMode(1);
        this.jScrollPane_jobs.setAlignmentX(0.0f);
        this.jScrollPane_jobs.setAlignmentY(0.0f);
        this.jTable_jobs.setModel(this.cgjtm);
        this.jTable_jobs.setAutoResizeMode(0);
        this.jTable_jobs.setFillsViewportHeight(true);
        this.jTable_jobs.setMaximumSize(new Dimension(1500, 1000));
        this.jTable_jobs.setMinimumSize(new Dimension(600, 300));
        this.jTable_jobs.setSelectionMode(0);
        this.jTable_jobs.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                CantiGUIFrame.this.jTable_jobsKeyPressed(evt);
            }
        });
        this.jScrollPane_jobs.setViewportView(this.jTable_jobs);
        this.jButton_jobs_load.setText("Load");
        this.jButton_jobs_load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jButton_jobs_loadActionPerformed(evt);
            }
        });
        this.jButton_jobs_delete.setText("Delete");
        this.jButton_jobs_delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jButton_jobs_deleteActionPerformed(evt);
            }
        });
        GroupLayout jDialog_jobsLayout = new GroupLayout(this.jDialog_jobs.getContentPane());
        this.jDialog_jobs.getContentPane().setLayout(jDialog_jobsLayout);
        jDialog_jobsLayout.setHorizontalGroup(jDialog_jobsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane_jobs, -2, 452, -2).addGroup(jDialog_jobsLayout.createSequentialGroup().addContainerGap().addComponent(this.jButton_jobs_load).addGap(18, 18, 18).addComponent(this.jButton_jobs_delete).addGap(65, 65, 65)));
        jDialog_jobsLayout.setVerticalGroup(jDialog_jobsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog_jobsLayout.createSequentialGroup().addComponent(this.jScrollPane_jobs, -2, 190, -2).addGap(18, 18, 18).addGroup(jDialog_jobsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_jobs_load).addComponent(this.jButton_jobs_delete)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTextArea_about.setColumns(20);
        this.jTextArea_about.setEditable(false);
        this.jTextArea_about.setRows(5);
        this.jTextArea_about.setText("CantiGUI v1.00a\nPurpose: Provide a graphical user interface for Canti.\nAuthor: Andrew Mantel\nSoftware Development Group: (coming soon)\nReleased: November 17, 2010");
        this.jTextField1.setText("[logo]");
        this.jTextArea_license.setColumns(20);
        this.jTextArea_license.setEditable(false);
        this.jTextArea_license.setRows(5);
        this.jTextArea_license.setText("License:\nCanti and CantiGUI are Copyright 2010 Andrew Mantel.\n\nCanti and CantiGUI are freeware and can be distributed freely as long as it is not modified.\n\nWhen you use this software you do so at your own risk.\nThe author is not responsible for any loss or damage resulting from the use or misuse of this software.");
        this.jScrollPane_license.setViewportView(this.jTextArea_license);
        GroupLayout jDialog_aboutLayout = new GroupLayout(this.jDialog_about.getContentPane());
        this.jDialog_about.getContentPane().setLayout(jDialog_aboutLayout);
        jDialog_aboutLayout.setHorizontalGroup(jDialog_aboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog_aboutLayout.createSequentialGroup().addGroup(jDialog_aboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog_aboutLayout.createSequentialGroup().addComponent(this.jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextArea_about, -1, 261, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jDialog_aboutLayout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator_contents, -1, 308, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jDialog_aboutLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane_license, -1, 308, Short.MAX_VALUE))).addContainerGap()));
        jDialog_aboutLayout.setVerticalGroup(jDialog_aboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog_aboutLayout.createSequentialGroup().addGroup(jDialog_aboutLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog_aboutLayout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.jTextField1, -2, -1, -2)).addComponent(this.jTextArea_about, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator_contents, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane_license, -2, 141, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jDialog_about.pack();
        this.jTextArea_contents.setColumns(20);
        this.jTextArea_contents.setEditable(false);
        this.jTextArea_contents.setRows(5);
        this.jScrollPane_contents.setViewportView(this.jTextArea_contents);
        GroupLayout jDialog_contentsLayout = new GroupLayout(this.jDialog_contents.getContentPane());
        this.jDialog_contents.getContentPane().setLayout(jDialog_contentsLayout);
        jDialog_contentsLayout.setHorizontalGroup(jDialog_contentsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog_contentsLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane_contents, -1, 376, Short.MAX_VALUE).addContainerGap()));
        jDialog_contentsLayout.setVerticalGroup(jDialog_contentsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialog_contentsLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane_contents, -1, 276, Short.MAX_VALUE).addContainerGap()));
        this.setDefaultCloseOperation(3);
        this.setTitle("Canti");
        this.jPanel_run.setName("run");
        this.jButton_parent_folder.setText("parent_folder");
        this.jButton_parent_folder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jButton_parent_folderActionPerformed(evt);
            }
        });
        this.jLabel_title.setText("Title");
        this.jButton_run.setText("Run");
        this.jButton_run.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jButton_runActionPerformed(evt);
            }
        });
        this.jTextArea_console.setColumns(20);
        this.jTextArea_console.setEditable(false);
        this.jTextArea_console.setRows(5);
        this.jScrollPane_console.setViewportView(this.jTextArea_console);
        this.jButton_output_folder.setText("output_folder");
        this.jButton_output_folder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jButton_output_folderActionPerformed(evt);
            }
        });
        GroupLayout jPanel_runLayout = new GroupLayout(this.jPanel_run);
        this.jPanel_run.setLayout(jPanel_runLayout);
        jPanel_runLayout.setHorizontalGroup(jPanel_runLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_runLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_runLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel_runLayout.createSequentialGroup().addGroup(jPanel_runLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton_parent_folder).addComponent(this.jLabel_title)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_runLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextField_parent_folder, -1, 342, Short.MAX_VALUE).addComponent(this.jTextField_title, -1, 342, Short.MAX_VALUE))).addGroup(jPanel_runLayout.createSequentialGroup().addComponent(this.jButton_run).addGap(18, 18, 18).addComponent(this.jScrollPane_console, -1, 391, Short.MAX_VALUE)).addGroup(jPanel_runLayout.createSequentialGroup().addComponent(this.jButton_output_folder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_output_folder, -1, 342, Short.MAX_VALUE))).addContainerGap()));
        jPanel_runLayout.setVerticalGroup(jPanel_runLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_runLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_runLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_parent_folder).addComponent(this.jTextField_parent_folder, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_runLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_title).addComponent(this.jTextField_title, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_runLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_output_folder).addComponent(this.jTextField_output_folder, -2, -1, -2)).addGap(29, 29, 29).addGroup(jPanel_runLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton_run, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane_console, -1, 126, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane_main.addTab("Run", this.jPanel_run);
        this.jPanel_advanced.setName("advanced");
        this.jCheckBox_manga_prefix.setText("manga_prefix");
        this.jCheckBox_bind_prefix.setText("bind_prefix");
        this.jCheckBox_use_original_filenames.setText("use_original_filenames");
        this.jCheckBox_auto_bind.setText("auto_bind");
        this.jCheckBox_num_chars_keep_suffix.setText("num_chars_keep_suffix");
        this.jComboBox_manga_prefix.setModel(new DefaultComboBoxModel<String>(new String[]{"Ch.", "Vol.", "Chapter_", "Volume_", "c", "v"}));
        this.jComboBox_bind_prefix.setModel(new DefaultComboBoxModel<String>(new String[]{"Vol.", "Bind.", "Volume_", "Bind_"}));
        this.jLabel_check_box_to_enable.setText("Check Box to Enable");
        this.jLabel_set_value.setText("Set Value (if applicable)");
        GroupLayout jPanel_advancedLayout = new GroupLayout(this.jPanel_advanced);
        this.jPanel_advanced.setLayout(jPanel_advancedLayout);
        jPanel_advancedLayout.setHorizontalGroup(jPanel_advancedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_advancedLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel_advancedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_advancedLayout.createSequentialGroup().addComponent(this.jLabel_check_box_to_enable).addGap(89, 89, 89).addComponent(this.jLabel_set_value)).addGroup(jPanel_advancedLayout.createSequentialGroup().addComponent(this.jCheckBox_manga_prefix).addGap(109, 109, 109).addComponent(this.jComboBox_manga_prefix, -2, -1, -2)).addGroup(jPanel_advancedLayout.createSequentialGroup().addComponent(this.jCheckBox_bind_prefix).addGap(127, 127, 127).addComponent(this.jComboBox_bind_prefix, -2, -1, -2)).addComponent(this.jCheckBox_use_original_filenames).addGroup(jPanel_advancedLayout.createSequentialGroup().addComponent(this.jCheckBox_auto_bind).addGap(133, 133, 133).addComponent(this.jSpinner_auto_bind, -2, -1, -2)).addGroup(jPanel_advancedLayout.createSequentialGroup().addComponent(this.jCheckBox_num_chars_keep_suffix).addGap(47, 47, 47).addComponent(this.jSpinner_num_chars_keep_suffix, -2, -1, -2)))));
        jPanel_advancedLayout.setVerticalGroup(jPanel_advancedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_advancedLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel_advancedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_check_box_to_enable).addComponent(this.jLabel_set_value)).addGap(3, 3, 3).addGroup(jPanel_advancedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_manga_prefix).addComponent(this.jComboBox_manga_prefix, -2, -1, -2)).addGap(3, 3, 3).addGroup(jPanel_advancedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_bind_prefix).addComponent(this.jComboBox_bind_prefix, -2, -1, -2)).addGap(3, 3, 3).addComponent(this.jCheckBox_use_original_filenames).addGap(8, 8, 8).addGroup(jPanel_advancedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_auto_bind).addComponent(this.jSpinner_auto_bind, -2, -1, -2)).addGap(2, 2, 2).addGroup(jPanel_advancedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_num_chars_keep_suffix).addComponent(this.jSpinner_num_chars_keep_suffix, -2, -1, -2))));
        this.jTabbedPane_main.addTab("Advanced", this.jPanel_advanced);
        this.jPanel_settings.setName("settings");
        this.jLabel_properties_file.setText(".properties file");
        this.jTextField_properties.setEditable(false);
        this.jButton_properties_load.setText("Load");
        this.jButton_properties_load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jButton_properties_loadActionPerformed(evt);
            }
        });
        this.jButton_properties_new.setText("New");
        this.jButton_properties_new.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jButton_properties_newActionPerformed(evt);
            }
        });
        this.jTextPane_properties.setBackground(new Color(255, 255, 255));
        this.jTextPane_properties.setAlignmentX(0.0f);
        this.jTextPane_properties.setAlignmentY(0.0f);
        this.jTextPane_properties.setVisible(false);
        this.jScrollPane_properties.setViewportView(this.jTextPane_properties);
        this.jButton_properties_save.setText("Save");
        this.jButton_properties_save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jButton_properties_saveActionPerformed(evt);
            }
        });
        this.jButton_properties_refresh.setText("Refr");
        this.jButton_properties_refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jButton_properties_refreshActionPerformed(evt);
            }
        });
        GroupLayout jPanel_settingsLayout = new GroupLayout(this.jPanel_settings);
        this.jPanel_settings.setLayout(jPanel_settingsLayout);
        jPanel_settingsLayout.setHorizontalGroup(jPanel_settingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_settingsLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_settingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_settingsLayout.createSequentialGroup().addComponent(this.jLabel_properties_file).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_properties, -1, 342, Short.MAX_VALUE)).addGroup(jPanel_settingsLayout.createSequentialGroup().addComponent(this.jButton_properties_load).addGap(18, 18, 18).addComponent(this.jButton_properties_new))).addContainerGap()).addComponent(this.jSeparator_settings, -1, 469, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel_settingsLayout.createSequentialGroup().addComponent(this.jScrollPane_properties, -1, 407, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_settingsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton_properties_refresh, 0, 0, Short.MAX_VALUE).addComponent(this.jButton_properties_save, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel_settingsLayout.setVerticalGroup(jPanel_settingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_settingsLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_settingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_properties_file).addComponent(this.jTextField_properties, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_settingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_properties_load).addComponent(this.jButton_properties_new)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator_settings, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_settingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_settingsLayout.createSequentialGroup().addComponent(this.jButton_properties_save).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_properties_refresh)).addComponent(this.jScrollPane_properties, -1, 180, Short.MAX_VALUE))));
        if (PROPERTIES_FILE.exists()) {
            CGPropertiesLoader pl = new CGPropertiesLoader(PROPERTIES_FILE);
            String canti_properties_path = pl.getCantiPropertiesFile();
            this.jTextField_properties.setText(canti_properties_path);
            this.jButton_properties_refreshActionPerformed(null);
        }
        this.jTabbedPane_main.addTab("Settings", this.jPanel_settings);
        this.jMenu_file.setText("File");
        this.jMenuItem_load_job.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.jMenuItem_load_job.setText("Load Job");
        this.jMenuItem_load_job.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jMenuItem_load_jobActionPerformed(evt);
            }
        });
        this.jMenu_file.add(this.jMenuItem_load_job);
        this.jMenuItem_save_job.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem_save_job.setText("Save Job");
        this.jMenuItem_save_job.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jMenuItem_save_jobActionPerformed(evt);
            }
        });
        this.jMenu_file.add(this.jMenuItem_save_job);
        this.jMenuItem_exit.setText("Exit");
        this.jMenuItem_exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jMenuItem_exitActionPerformed(evt);
            }
        });
        this.jMenu_file.add(this.jMenuItem_exit);
        this.jMenuBar_main.add(this.jMenu_file);
        this.jMenu_help.setText("Help");
        this.jMenuItem_contents.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.jMenuItem_contents.setText("Contents");
        this.jMenuItem_contents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jMenuItem_contentsActionPerformed(evt);
            }
        });
        this.jMenu_help.add(this.jMenuItem_contents);
        this.jMenuItem_about.setText("About");
        this.jMenuItem_about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CantiGUIFrame.this.jMenuItem_aboutActionPerformed(evt);
            }
        });
        this.jMenu_help.add(this.jMenuItem_about);
        this.jMenuBar_main.add(this.jMenu_help);
        this.setJMenuBar(this.jMenuBar_main);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane_main, -1, 481, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane_main, -1, 319, Short.MAX_VALUE));
        this.pack();
    }

    private void jMenuItem_exitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jButton_parent_folderActionPerformed(ActionEvent evt) {
        this.jFileChooser_parent_folder.setSelectedFile(new File(""));
        int returnVal = this.jFileChooser_parent_folder.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.jFileChooser_parent_folder.getSelectedFile();
            if (!file.exists()) {
                file = new File(file.getParent());
            }
            this.jTextField_parent_folder.setText(file.getAbsolutePath());
        }
    }

    private void jButton_runActionPerformed(ActionEvent evt) {
        CGJob cgjob = this.getCurrentStateAsJob();
        ArrayList<String> args_list = new ArrayList<String>();
        boolean ready = true;
        if (cgjob.getParentFolder() == null || cgjob.getParentFolder().isEmpty() || !new File(cgjob.getParentFolder()).exists()) {
            ready = false;
        } else {
            args_list.add("-parent_folder");
            args_list.add(cgjob.getParentFolder());
        }
        if (cgjob.getTitle() == null || cgjob.getTitle().isEmpty()) {
            ready = false;
        } else {
            args_list.add("-title");
            args_list.add(cgjob.getTitle());
        }
        if (cgjob.getOutputFolder() != null && !cgjob.getOutputFolder().isEmpty()) {
            args_list.add("-output_folder");
            args_list.add(cgjob.getOutputFolder());
        }
        if (cgjob.getCantiPropertiesFile() == null || cgjob.getCantiPropertiesFile().isEmpty() || !new File(cgjob.getCantiPropertiesFile()).exists()) {
            ready = false;
        } else {
            args_list.add("-properties");
            args_list.add(cgjob.getCantiPropertiesFile());
        }
        if (cgjob.getMangaPrefixEnabled()) {
            args_list.add("-manga_prefix");
            args_list.add(cgjob.getMangaPrefix());
        }
        if (cgjob.getBindPrefixEnabled()) {
            args_list.add("-bind_prefix");
            args_list.add(cgjob.getBindPrefix());
        }
        if (cgjob.getUseOriginalFilenamesEnabled()) {
            args_list.add("-use_original_filenames");
            args_list.add("true");
        }
        if (cgjob.getAutoBindEnabled()) {
            args_list.add("-auto_bind");
            args_list.add(cgjob.getAutoBind());
        }
        if (cgjob.getNumCharsKeepSuffixEnabled()) {
            args_list.add("-num_chars_keep_suffix");
            args_list.add(cgjob.getNumCharsKeepSuffix());
        }
        String[] args = new String[args_list.size()];
        for (int i = 0; i < args_list.size(); ++i) {
            args[i] = (String)args_list.get(i);
        }
        if (ready) {
            if (this.cmt == null || this.cmt.getState() != Thread.State.RUNNABLE) {
                this.jTextArea_console.setText("");
                this.cmt = new ConvertMangaThread(args, "Thread_cmt");
                new ConvertMangaMonitorThread(this.cmt, this.jButton_run, "Thread_cmt_monitor").start();
            } else {
                JOptionPane.showMessageDialog(this, "Canti is already running.\nPlease wait for it to finish before running again.", "Already Running", 1);
            }
        } else {
            ArrayList<String> missing_requirements = this.getMissingCantiRequirements(cgjob);
            String missing_requirements_string = "";
            for (int i = 0; i < missing_requirements.size(); ++i) {
                missing_requirements_string = missing_requirements_string + "\n" + missing_requirements.get(i);
            }
            JOptionPane.showMessageDialog(this, "Cannot run Canti because some requirements are missing.\nPlease check the following:" + missing_requirements_string, "Missing Requirements", 2);
            this.jTextArea_console.setCaretPosition(0);
        }
    }

    private void jButton_output_folderActionPerformed(ActionEvent evt) {
        this.jFileChooser_output_folder.setSelectedFile(new File(""));
        int returnVal = this.jFileChooser_output_folder.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.jFileChooser_output_folder.getSelectedFile();
            if (!file.exists()) {
                file = new File(file.getParent());
            }
            this.jTextField_output_folder.setText(file.getAbsolutePath());
        }
    }

    private void jButton_properties_loadActionPerformed(ActionEvent evt) {
        this.jFileChooser_properties_load.setSelectedFile(new File(""));
        int returnVal = this.jFileChooser_properties_load.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.jFileChooser_properties_load.getSelectedFile();
            this.jTextField_properties.setText(file.getAbsolutePath());
            CGPropertiesWriter.writePropertiesFile(file.getAbsolutePath());
            this.jButton_properties_refreshActionPerformed(evt);
        }
    }

    private void jButton_properties_refreshActionPerformed(ActionEvent evt) {
        String properties_path = this.jTextField_properties.getText();
        File properties_file = new File(properties_path);
        if (properties_path == null || properties_path.isEmpty()) {
            String error = "Please load or create a .properties file.";
            this.jTextPane_properties.setText(error);
            this.jTextPane_properties.setCaretPosition(0);
            this.jTextPane_properties.setVisible(true);
            this.jButton_properties_save.setEnabled(false);
        } else if (properties_file.exists()) {
            this.jTextPane_properties.setText("");
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(properties_file));
                while ((line = br.readLine()) != null) {
                    StyledDocument doc = (StyledDocument)this.jTextPane_properties.getDocument();
                    try {
                        Style style = doc.addStyle("StyleName", null);
                        if (line != null && !line.isEmpty()) {
                            int equal_index = line.indexOf(61);
                            if (line.charAt(0) == '#') {
                                StyleConstants.setForeground(style, Color.gray);
                                doc.insertString(doc.getLength(), line + "\n", style);
                                continue;
                            }
                            if (equal_index == -1) continue;
                            StyleConstants.setForeground(style, Color.black);
                            String line_key_equal = line.substring(0, equal_index + 1);
                            String line_value = line.substring(equal_index + 1);
                            doc.insertString(doc.getLength(), line_key_equal, style);
                            StyleConstants.setForeground(style, Color.blue);
                            doc.insertString(doc.getLength(), line_value + "\n", style);
                            continue;
                        }
                        doc.insertString(doc.getLength(), line + "\n", style);
                    }
                    catch (BadLocationException e) {
                        ErrorLog.append(e);
                    }
                }
                br.close();
            }
            catch (FileNotFoundException e) {
                ErrorLog.append(e);
            }
            catch (IOException e) {
                ErrorLog.append(e);
            }
            this.jTextPane_properties.setCaretPosition(0);
            this.jTextPane_properties.setVisible(true);
            this.jButton_properties_save.setEnabled(true);
        } else {
            String error = "Could not load " + properties_path + "\n";
            error = error + "Please check that this file exists, or load/create a different .properties file.";
            this.jTextPane_properties.setText(error);
            this.jTextPane_properties.setCaretPosition(0);
            this.jTextPane_properties.setVisible(true);
            this.jButton_properties_save.setEnabled(false);
        }
    }

    private void jButton_properties_saveActionPerformed(ActionEvent evt) {
        String content = this.jTextPane_properties.getText();
        String properties_path = this.jTextField_properties.getText();
        File properties_file = new File(properties_path);
        if (content != null && !content.isEmpty()) {
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(properties_file, false));
                bw.write(content);
                bw.close();
            }
            catch (IOException e) {
                ErrorLog.append(e);
            }
            CGPropertiesWriter.writePropertiesFile(properties_file.getAbsolutePath());
        }
    }

    private void jButton_properties_newActionPerformed(ActionEvent evt) {
        this.jDialog_properties_new.setLocationRelativeTo(this);
        this.jDialog_properties_new.setVisible(true);
    }

    private void jButton_properties_cancelActionPerformed(ActionEvent evt) {
        this.jDialog_properties_new.setVisible(false);
    }

    private void jButton_properties_createActionPerformed(ActionEvent evt) {
        int n;
        File output_file;
        String device = (String)this.jComboBox_properties_device.getSelectedItem();
        String properties_file_folder_path = this.jTextField_properties_folder.getText();
        if (properties_file_folder_path == null || properties_file_folder_path.isEmpty()) {
            output_file = new File("Canti.properties");
        } else {
            if (properties_file_folder_path.charAt(properties_file_folder_path.length() - 1) != File.separatorChar) {
                properties_file_folder_path = properties_file_folder_path + File.separatorChar;
            }
            output_file = new File(properties_file_folder_path + "Canti.properties");
        }
        if (output_file.exists() && (n = JOptionPane.showConfirmDialog(this, ".properties file " + output_file.getAbsolutePath() + " already exists.\n" + "Would you like to overwrite it?", "Overwrite .properties file?", 0)) != 0) {
            return;
        }
        CMPropertiesWriter.writePropertiesFile(output_file, device);
        this.jDialog_properties_new.setVisible(false);
        this.jTextField_properties.setText(output_file.getAbsolutePath());
        CGPropertiesWriter.writePropertiesFile(output_file.getAbsolutePath());
        this.jButton_properties_refreshActionPerformed(evt);
        if (this.cmt == null || this.cmt.getState() != Thread.State.RUNNABLE) {
            this.jTextArea_console.setText("");
        }
    }

    private void jButton_properties_folderActionPerformed(ActionEvent evt) {
        this.jFileChooser_properties_new.setSelectedFile(new File(""));
        int returnVal = this.jFileChooser_properties_new.showOpenDialog(this);
        if (returnVal == 0) {
            File folder = this.jFileChooser_properties_new.getSelectedFile();
            if (!folder.exists()) {
                folder = new File(folder.getParent());
            }
            this.jTextField_properties_folder.setText(folder.getAbsolutePath());
        }
    }

    private void jMenuItem_save_jobActionPerformed(ActionEvent evt) {
        CGJob cgjob = this.getCurrentStateAsJob();
        ArrayList<CGJob> cgjob_list = CGJobLoader.getCGJobList();
        if (cgjob_list != null && !cgjob_list.isEmpty() && cgjob_list.contains(cgjob)) {
            JOptionPane.showMessageDialog(this, "Cannot save job because duplicate job already exists.", "Duplicate Job Warning", 2);
        } else if (cgjob.isValid()) {
            CGJobWriter.addJob(cgjob);
            CGJobLoader.addCGJobToList(cgjob);
            JOptionPane.showMessageDialog(this, "Job saved (job_id: " + cgjob.getJobID() + ").", "Job Saved", 1);
        } else {
            ArrayList<String> missing_requirements = this.getMissingCantiRequirements(cgjob);
            String missing_requirements_string = "";
            for (int i = 0; i < missing_requirements.size(); ++i) {
                missing_requirements_string = missing_requirements_string + "\n" + missing_requirements.get(i);
            }
            JOptionPane.showMessageDialog(this, "Job is invalid, so cannot save.\nPlease check the following:" + missing_requirements_string, "Invalid Job", 0);
        }
    }

    private void jMenuItem_load_jobActionPerformed(ActionEvent evt) {
        this.cgjtm.generateData();
        this.cgjtm.formatColumns(this.jTable_jobs, 1, 2);
        this.jDialog_jobs.pack();
        this.jDialog_jobs.setLocationRelativeTo(this);
        this.jDialog_jobs.setVisible(true);
    }

    private void jButton_jobs_loadActionPerformed(ActionEvent evt) {
        int selected_row = this.jTable_jobs.getSelectedRow();
        ArrayList<CGJob> cgjob_list = CGJobLoader.getCGJobList();
        if (selected_row >= 0 && selected_row < cgjob_list.size()) {
            CGJob selected_cgjob = cgjob_list.get(selected_row);
            this.populateStateWithJob(selected_cgjob);
            this.jDialog_jobs.setVisible(false);
        }
    }

    private void jButton_jobs_deleteActionPerformed(ActionEvent evt) {
        int selected_row = this.jTable_jobs.getSelectedRow();
        ArrayList<CGJob> cgjob_list = CGJobLoader.getCGJobList();
        if (selected_row >= 0 && selected_row < cgjob_list.size()) {
            CGJob selected_cgjob = cgjob_list.get(selected_row);
            CGJobLoader.removeCGJobFromList(selected_cgjob);
            CGJobWriter.addJobs(cgjob_list);
            this.cgjtm.generateData();
        }
    }

    private void jMenuItem_aboutActionPerformed(ActionEvent evt) {
        this.jDialog_about.setLocationRelativeTo(this);
        this.jDialog_about.setVisible(true);
    }

    private void jMenuItem_contentsActionPerformed(ActionEvent evt) {
        String cur_contents = this.jTextArea_contents.getText();
        try {
            if (cur_contents == null || cur_contents.isEmpty()) {
                InputStream contents_is = CGPropertiesWriter.class.getResourceAsStream("/cantigui/docs/contents.txt");
                ArrayList<String> lines = JarUtils.readTextFromJarFile(contents_is);
                for (int i = 0; i < lines.size(); ++i) {
                    this.jTextArea_contents.append(lines.get(i) + "\n");
                }
                contents_is.close();
            }
        }
        catch (IOException e) {
            ErrorLog.append(e);
            this.jTextArea_contents.setText("Failed to read contents.");
        }
        this.jDialog_contents.pack();
        this.jTextArea_contents.setCaretPosition(0);
        this.jDialog_contents.setLocationRelativeTo(this);
        this.jDialog_contents.setVisible(true);
    }

    private void jTable_jobsKeyPressed(KeyEvent evt) {
        int key_code = evt.getKeyCode();
        if (key_code == 127) {
            this.jButton_jobs_deleteActionPerformed(null);
        } else if (key_code == 10) {
            this.jButton_jobs_loadActionPerformed(null);
        }
    }

    private CGJob getCurrentStateAsJob() {
        String parent_folder = this.jTextField_parent_folder.getText();
        String title = this.jTextField_title.getText();
        String output_folder = this.jTextField_output_folder.getText();
        boolean manga_prefix_enabled = this.jCheckBox_manga_prefix.isSelected();
        String manga_prefix = (String)this.jComboBox_manga_prefix.getSelectedItem();
        boolean bind_prefix_enabled = this.jCheckBox_bind_prefix.isSelected();
        String bind_prefix = (String)this.jComboBox_bind_prefix.getSelectedItem();
        boolean use_original_filenames_enabled = this.jCheckBox_use_original_filenames.isSelected();
        boolean auto_bind_enabled = this.jCheckBox_auto_bind.isSelected();
        String auto_bind = String.valueOf(this.jSpinner_auto_bind.getValue());
        boolean num_chars_keep_suffix_enabled = this.jCheckBox_num_chars_keep_suffix.isSelected();
        String num_chars_keep_suffix = String.valueOf(this.jSpinner_num_chars_keep_suffix.getValue());
        String canti_properties_file = this.jTextField_properties.getText();
        CGJob cgjob = new CGJob();
        cgjob.setParentFolder(parent_folder);
        cgjob.setTitle(title);
        cgjob.setOutputFolder(output_folder);
        cgjob.setMangaPrefixEnabled(manga_prefix_enabled);
        cgjob.setMangaPrefix(manga_prefix);
        cgjob.setBindPrefixEnabled(bind_prefix_enabled);
        cgjob.setBindPrefix(bind_prefix);
        cgjob.setUseOriginalFilenamesEnabled(use_original_filenames_enabled);
        cgjob.setAutoBindEnabled(auto_bind_enabled);
        cgjob.setAutoBind(auto_bind);
        cgjob.setNumCharsKeepSuffixEnabled(num_chars_keep_suffix_enabled);
        cgjob.setNumCharsKeepSuffix(num_chars_keep_suffix);
        cgjob.setCantiPropertiesFile(canti_properties_file);
        return cgjob;
    }

    private void populateStateWithJob(CGJob cgjob) {
        this.jTextField_parent_folder.setText(cgjob.getParentFolder());
        this.jTextField_title.setText(cgjob.getTitle());
        this.jTextField_output_folder.setText(cgjob.getOutputFolder());
        this.jCheckBox_manga_prefix.setSelected(cgjob.getMangaPrefixEnabled());
        this.jComboBox_manga_prefix.setSelectedItem(cgjob.getMangaPrefix());
        this.jCheckBox_bind_prefix.setSelected(cgjob.getBindPrefixEnabled());
        this.jComboBox_bind_prefix.setSelectedItem(cgjob.getBindPrefix());
        this.jCheckBox_use_original_filenames.setSelected(cgjob.getUseOriginalFilenamesEnabled());
        this.jCheckBox_auto_bind.setSelected(cgjob.getAutoBindEnabled());
        this.jSpinner_auto_bind.setValue(Integer.valueOf(cgjob.getAutoBind()));
        this.jCheckBox_num_chars_keep_suffix.setSelected(cgjob.getNumCharsKeepSuffixEnabled());
        this.jSpinner_num_chars_keep_suffix.setValue(Integer.valueOf(cgjob.getNumCharsKeepSuffix()));
        this.jTextField_properties.setText(cgjob.getCantiPropertiesFile());
        this.jButton_properties_refreshActionPerformed(null);
    }

    private ArrayList<String> getMissingCantiRequirements(CGJob cgjob) {
        ArrayList<String> missing_requirements = new ArrayList<String>();
        if (cgjob.getParentFolder() == null || cgjob.getParentFolder().isEmpty()) {
            missing_requirements.add("-Need to specify parent_folder in \"Run\" tab.");
        } else if (!new File(cgjob.getParentFolder()).exists()) {
            missing_requirements.add("-parent_folder " + cgjob.getParentFolder() + " doesn't exist.");
        }
        if (cgjob.getTitle() == null || cgjob.getTitle().isEmpty()) {
            missing_requirements.add("-Need to specify title in \"Run\" tab.");
        }
        if (cgjob.getCantiPropertiesFile() == null || cgjob.getCantiPropertiesFile().isEmpty()) {
            missing_requirements.add("-Need to specify .properties file in \"Settings\" tab.");
        } else if (!new File(cgjob.getCantiPropertiesFile()).exists()) {
            missing_requirements.add("-.properties file " + cgjob.getCantiPropertiesFile() + " doesn't exist.");
        }
        return missing_requirements;
    }

    private void checkCantiPropertiesFile() {
        CGPropertiesLoader pl;
        String canti_properties_file_path;
        if (!PROPERTIES_FILE.exists()) {
            CGPropertiesWriter.writePropertiesFile("");
        }
        if ((canti_properties_file_path = (pl = new CGPropertiesLoader(PROPERTIES_FILE)).getCantiPropertiesFile()) == null || canti_properties_file_path.isEmpty()) {
            this.promptCantiPropertiesFileCreation();
        } else {
            File canti_properties_file = new File(canti_properties_file_path);
            if (!canti_properties_file.exists()) {
                this.promptCantiPropertiesFileCreation();
            }
        }
    }

    private void promptCantiPropertiesFileCreation() {
        int tab_count = this.jTabbedPane_main.getTabCount();
        boolean done = false;
        for (int i = 0; !done && i < tab_count; ++i) {
            Component comp = this.jTabbedPane_main.getComponentAt(i);
            String comp_name = comp.getName();
            if (!comp_name.equals("settings")) continue;
            this.jTabbedPane_main.setSelectedIndex(i);
            done = true;
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new CantiGUIFrame().setVisible(true);
            }
        });
    }
}

