/*
 * Decompiled with CFR 0.152.
 */
package cantigui;

import cantigui.CantiGUIFrame;
import cantigui.ErrorLog;
import common.utils.JarUtils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class CGPropertiesWriter {
    private static String default_loc = "/cantigui/props/";
    private static String key_descriptors_header_filename = "key_descriptors_header.txt";

    public static void writePropertiesFile(String canti_properties_filepath) {
        String os_name = System.getProperty("os.name");
        String os_name_lowercase = os_name.toLowerCase();
        if (os_name_lowercase.contains("win")) {
            for (int j = 0; j < canti_properties_filepath.length(); ++j) {
                char cur_char = canti_properties_filepath.charAt(j);
                if (cur_char != '\\') continue;
                canti_properties_filepath = canti_properties_filepath.substring(0, j) + "\\\\" + canti_properties_filepath.substring(j + 1);
                ++j;
            }
        }
        try {
            ArrayList<String> lines = null;
            if (CantiGUIFrame.PROPERTIES_FILE.exists()) {
                CantiGUIFrame.PROPERTIES_FILE.delete();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(CantiGUIFrame.PROPERTIES_FILE));
            bw.write("# @author Andrew Mantel\n");
            bw.write("# @version 1.00a\n");
            bw.write("\n");
            InputStream key_descriptors_header_is = CGPropertiesWriter.class.getResourceAsStream(default_loc + key_descriptors_header_filename);
            lines = JarUtils.readTextFromJarFile(key_descriptors_header_is);
            for (int i = 0; i < lines.size(); ++i) {
                bw.write(lines.get(i) + "\n");
            }
            key_descriptors_header_is.close();
            bw.write("canti_properties_file = " + canti_properties_filepath + "\n");
            bw.write("\n\n");
            bw.close();
        }
        catch (IOException e) {
            ErrorLog.append(e);
        }
    }
}

