/*
 * Decompiled with CFR 0.152.
 */
package cantigui;

import cantigui.CGJob;
import cantigui.CantiGUIFrame;
import cantigui.ErrorLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CGJobLoader {
    protected static final String key_job_id = "job_id";
    protected static final String key_parent_folder = "parent_folder";
    protected static final String key_title = "title";
    protected static final String key_output_folder = "output_folder";
    protected static final String key_manga_prefix_enabled = "manga_prefix_enabled";
    protected static final String key_manga_prefix = "manga_prefix";
    protected static final String key_bind_prefix_enabled = "bind_prefix_enabled";
    protected static final String key_bind_prefix = "bind_prefix";
    protected static final String key_use_original_filenames_enabled = "use_original_filenames_enabled";
    protected static final String key_auto_bind_enabled = "auto_bind_enabled";
    protected static final String key_auto_bind = "auto_bind";
    protected static final String key_num_chars_keep_suffix_enabled = "num_chars_keep_suffix_enabled";
    protected static final String key_num_chars_keep_suffix = "num_chars_keep_suffix";
    protected static final String key_canti_properties_file = "canti_properties_file";
    protected static final String JOBS_FILE_BEGIN_DELIMITER = "# BEGIN JOB #";
    protected static final String JOBS_FILE_END_DELIMITER = "# END JOB #";
    private static ArrayList<CGJob> cgjob_list = null;
    private static File jobs_file = CantiGUIFrame.JOBS_FILE;

    private static void loadJobs() {
        if (!jobs_file.exists()) {
            cgjob_list = null;
            return;
        }
        cgjob_list = new ArrayList();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(jobs_file));
            CGJob cgjob = null;
            while ((line = br.readLine()) != null) {
                if (line == null || line.isEmpty()) continue;
                if ((line = line.trim()).equals(JOBS_FILE_BEGIN_DELIMITER)) {
                    cgjob = new CGJob();
                    continue;
                }
                if (line.equals(JOBS_FILE_END_DELIMITER)) {
                    cgjob_list.add(cgjob);
                    continue;
                }
                if (cgjob == null) {
                    cgjob = new CGJob();
                }
                if (CGJobLoader.isKeyMatch(line, key_job_id)) {
                    cgjob.setJobID(CGJobLoader.getStringValue(line));
                    continue;
                }
                if (CGJobLoader.isKeyMatch(line, key_parent_folder)) {
                    cgjob.setParentFolder(CGJobLoader.getStringValue(line));
                    continue;
                }
                if (CGJobLoader.isKeyMatch(line, key_title)) {
                    cgjob.setTitle(CGJobLoader.getStringValue(line));
                    continue;
                }
                if (CGJobLoader.isKeyMatch(line, key_output_folder)) {
                    cgjob.setOutputFolder(CGJobLoader.getStringValue(line));
                    continue;
                }
                if (CGJobLoader.isKeyMatch(line, key_manga_prefix_enabled)) {
                    cgjob.setMangaPrefixEnabled(CGJobLoader.getBooleanValue(line));
                    continue;
                }
                if (CGJobLoader.isKeyMatch(line, key_manga_prefix)) {
                    cgjob.setMangaPrefix(CGJobLoader.getStringValue(line));
                    continue;
                }
                if (CGJobLoader.isKeyMatch(line, key_bind_prefix_enabled)) {
                    cgjob.setBindPrefixEnabled(CGJobLoader.getBooleanValue(line));
                    continue;
                }
                if (CGJobLoader.isKeyMatch(line, key_bind_prefix)) {
                    cgjob.setBindPrefix(CGJobLoader.getStringValue(line));
                    continue;
                }
                if (CGJobLoader.isKeyMatch(line, key_use_original_filenames_enabled)) {
                    cgjob.setUseOriginalFilenamesEnabled(CGJobLoader.getBooleanValue(line));
                    continue;
                }
                if (CGJobLoader.isKeyMatch(line, key_auto_bind_enabled)) {
                    cgjob.setAutoBindEnabled(CGJobLoader.getBooleanValue(line));
                    continue;
                }
                if (CGJobLoader.isKeyMatch(line, key_auto_bind)) {
                    cgjob.setAutoBind(CGJobLoader.getStringValue(line));
                    continue;
                }
                if (CGJobLoader.isKeyMatch(line, key_num_chars_keep_suffix_enabled)) {
                    cgjob.setNumCharsKeepSuffixEnabled(CGJobLoader.getBooleanValue(line));
                    continue;
                }
                if (CGJobLoader.isKeyMatch(line, key_num_chars_keep_suffix)) {
                    cgjob.setNumCharsKeepSuffix(CGJobLoader.getStringValue(line));
                    continue;
                }
                if (!CGJobLoader.isKeyMatch(line, key_canti_properties_file)) continue;
                cgjob.setCantiPropertiesFile(CGJobLoader.getStringValue(line));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            ErrorLog.append(e);
        }
        catch (IOException e) {
            ErrorLog.append(e);
        }
        CGJobLoader.sortCGJobListByTitle();
    }

    private static void sortCGJobListByTitle() {
        if (cgjob_list != null && cgjob_list.size() > 1) {
            Collections.sort(cgjob_list, CGJob.comp_title_order);
        }
    }

    protected static ArrayList<CGJob> getCGJobList() {
        if (cgjob_list == null) {
            CGJobLoader.loadJobs();
        }
        return cgjob_list;
    }

    protected static void addCGJobToList(CGJob cgjob) {
        if (cgjob_list == null) {
            cgjob_list = new ArrayList();
        }
        cgjob_list.add(cgjob);
        CGJobLoader.sortCGJobListByTitle();
    }

    protected static void removeCGJobFromList(CGJob cgjob) {
        if (cgjob_list == null) {
            return;
        }
        boolean done = false;
        for (int i = 0; !done && i < cgjob_list.size(); ++i) {
            CGJob cgjob_comp = cgjob_list.get(i);
            if (!cgjob_comp.equals(cgjob) || !cgjob_comp.getJobID().equals(cgjob.getJobID())) continue;
            cgjob_list.remove(i);
            done = true;
        }
    }

    private static boolean isKeyMatch(String line, String key) {
        if (line == null || key == null || line.isEmpty() || key.isEmpty()) {
            return false;
        }
        return key.length() <= line.length() && line.substring(0, key.length()).equals(key);
    }

    private static String getStringValue(String line) {
        int equal_index = line.indexOf(61);
        if (equal_index < 0) {
            return null;
        }
        return line.substring(equal_index + 1).trim();
    }

    private static boolean getBooleanValue(String line) {
        int equal_index = line.indexOf(61);
        if (equal_index < 0) {
            return false;
        }
        return Boolean.valueOf(line.substring(equal_index + 1).trim());
    }
}

