/*
 * Decompiled with CFR 0.152.
 */
package manga;

import common.image.ImageData;
import common.image.ImageMagick;
import common.utils.ExtFilter;
import common.utils.FileUtils;
import common.utils.SystemRar;
import common.utils.Table;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import manga.PropertiesLoader;

public class MangaFolder {
    private static ExtFilter zip_ext_filter = new ExtFilter("zip");
    private static ExtFilter rar_ext_filter = new ExtFilter("rar");
    private static ExtFilter pdf_ext_filter = new ExtFilter("pdf");
    private static ExtFilter img_ext_filter = new ExtFilter("image");
    private static ImageMagick im;
    private static SystemRar sysrar;
    private File file_handle;
    private File folder_handle;
    private ArrayList<ArrayList<String>> analysis = null;

    public MangaFolder(File file_handle, File properties_file) {
        this.file_handle = file_handle;
        im = new ImageMagick(properties_file);
        PropertiesLoader pl = new PropertiesLoader(properties_file);
        sysrar = new SystemRar(pl.getUnrarHandler(), pl.getRarHandler());
        this.analysis = new ArrayList();
    }

    public void collectData() {
        this.startup();
        if (!this.folder_handle.exists()) {
            System.out.println("ERROR: folder_handle " + this.folder_handle.getAbsolutePath() + " does not exist, so cannot analyze.");
            System.exit(1);
        }
        ArrayList<File> file_list = FileUtils.getFileListRecursive(this.folder_handle);
        ArrayList<File> image_file_list = img_ext_filter.getFilesOfTypeFromList(file_list);
        Collections.sort(image_file_list);
        int i = 0;
        while (i < image_file_list.size()) {
            File cur_image_file = image_file_list.get(i);
            ImageData cur_image_file_id = im.getImageData(cur_image_file);
            ArrayList<String> cur_analysis = new ArrayList<String>();
            String cur_image_file_path = cur_image_file.getAbsolutePath();
            cur_analysis.add(cur_image_file_path.substring(this.folder_handle.getAbsolutePath().length()));
            cur_analysis.add(Double.toString(cur_image_file_id.width));
            cur_analysis.add(Double.toString(cur_image_file_id.height));
            cur_analysis.add(Double.toString(cur_image_file_id.dpi));
            this.analysis.add(cur_analysis);
            ++i;
        }
        this.cleanup();
    }

    private void startup() {
        if (this.file_handle.isDirectory()) {
            this.folder_handle = this.file_handle;
        } else {
            this.folder_handle = new File(String.valueOf(this.file_handle.getParent()) + File.separatorChar + ExtFilter.getNameWithoutExtension(this.file_handle));
            if (!this.folder_handle.exists()) {
                if (zip_ext_filter.isValid(this.file_handle)) {
                    FileUtils.unzipFile(this.file_handle, this.folder_handle);
                } else if (rar_ext_filter.isValid(this.file_handle)) {
                    if (!sysrar.canUnrar()) {
                        System.out.println("ERROR: file_handle " + this.file_handle.getAbsolutePath() + " is a rar, yet the program could not find a compatible unrar handler. Please see readme.txt for details.");
                        System.exit(1);
                    } else {
                        sysrar.unrarFile(this.file_handle, this.folder_handle);
                    }
                } else if (pdf_ext_filter.isValid(this.file_handle)) {
                    im.convertPdfToImageFolder(this.file_handle, this.folder_handle);
                }
            }
        }
    }

    private void cleanup() {
        if (this.folder_handle != this.file_handle && this.file_handle.exists()) {
            FileUtils.deleteDirectory(this.folder_handle);
        }
    }

    public String toString() {
        String to_string = "";
        to_string = String.valueOf(to_string) + "file_handle: " + this.file_handle.getAbsolutePath() + "\n";
        to_string = String.valueOf(to_string) + "folder_handle: " + this.folder_handle.getAbsolutePath() + "\n";
        Table t = new Table(this.analysis, new String[]{"Filename", "Width", "Height", "DPI"}, 1, 0);
        to_string = String.valueOf(to_string) + t;
        return to_string;
    }
}

