/*
 * Decompiled with CFR 0.152.
 */
package cantigui;

import cantigui.ErrorLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class CGPropertiesLoader {
    private Properties props = new Properties();
    private File properties_file = null;
    protected final String key_canti_properties_file = "canti_properties_file";

    public CGPropertiesLoader(File properties_file) {
        this.properties_file = properties_file;
        if (!this.properties_file.exists()) {
            System.out.println("ERROR: Couldn't load .properties file. Please make sure that " + properties_file.getAbsolutePath() + " exists.");
            System.out.println("You can run Canti without any options (java -jar Canti.jar) for instructions on creating a .properties file.");
            System.exit(1);
        }
        try {
            FileInputStream fis = new FileInputStream(this.properties_file);
            this.props.load(fis);
            fis.close();
        }
        catch (IOException e) {
            ErrorLog.append(e);
        }
    }

    public String getCantiPropertiesFile() {
        return this.props.getProperty("canti_properties_file");
    }

    public int intKeyValue(String value) {
        value = value.trim();
        return Integer.parseInt(value);
    }

    public double doubleKeyValue(String value) {
        value = value.trim();
        return Double.parseDouble(value);
    }

    public boolean booleanKeyValue(String value) {
        if ((value = value.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return false;
    }
}

