/*
 * Decompiled with CFR 0.152.
 */
package manga;

import common.image.ImageData;
import common.image.ImageMagick;
import common.image.ImageUtils;
import common.utils.ExtFilter;
import common.utils.FileUtils;
import common.utils.JarUtils;
import common.utils.StopWatch;
import common.utils.SystemRar;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.zip.ZipOutputStream;
import manga.BatchCreator;
import manga.CMFileObject;
import manga.CMPropertiesWriter;
import manga.EpubMaker;
import manga.MangaCollection;
import manga.MangaFolder;
import manga.PropertiesLoader;

public class ConvertManga {
    protected static final String PROGRAM_VERSION = "1.94";
    protected static final String RELEASED_DATE = "November 14, 2010";
    protected static String title = null;
    protected static String manga_prefix = "";
    protected static String bind_prefix = "Vol.";
    protected static String prefix = null;
    protected static File progress_file = null;
    protected static File bind_file = null;
    protected static File parent_folder_file = null;
    protected static File output_folder_file = null;
    protected static File output_folder_parent_temp_handle;
    protected static File properties_file;
    protected static boolean use_bind;
    protected static boolean single_folder_mode;
    protected static boolean auto_sense_suffix;
    protected static boolean use_original_filenames;
    protected static int num_chars_keep_suffix;
    protected static int auto_bind_size;
    protected static boolean disable_binding;
    protected static boolean use_archive;
    protected static String archive_extension;
    protected static boolean use_pdf;
    protected static boolean use_epub;
    protected static boolean use_comic_zeal_naming;
    protected static int auto_sense_suffix_length;
    protected static ExtFilter zip_ext_filter;
    protected static ExtFilter rar_ext_filter;
    protected static ExtFilter archive_ext_filter;
    protected static ExtFilter pdf_ext_filter;
    protected static SystemRar sysrar;
    private static String default_kindle_bookmark;
    private static Comparator<File> comp_file_number_suffix_order;

    static {
        properties_file = new File("Canti.properties");
        use_bind = false;
        single_folder_mode = false;
        auto_sense_suffix = false;
        use_original_filenames = false;
        num_chars_keep_suffix = -1;
        auto_bind_size = 1;
        disable_binding = false;
        use_archive = false;
        archive_extension = null;
        use_pdf = false;
        use_epub = false;
        use_comic_zeal_naming = false;
        auto_sense_suffix_length = -1;
        zip_ext_filter = new ExtFilter("zip");
        rar_ext_filter = new ExtFilter("rar");
        archive_ext_filter = new ExtFilter("archive");
        pdf_ext_filter = new ExtFilter("pdf");
        default_kindle_bookmark = "/manga/kindle/default.manga";
        comp_file_number_suffix_order = new Comparator<File>(){

            @Override
            public int compare(File fh1, File fh2) {
                String fh1_suffix = ConvertManga.getFileNumberSuffix(fh1, true);
                String fh2_suffix = ConvertManga.getFileNumberSuffix(fh2, true);
                if (fh1_suffix.contains("-")) {
                    fh1_suffix = fh1_suffix.substring(0, fh1_suffix.indexOf(45));
                }
                if (fh2_suffix.contains("-")) {
                    fh2_suffix = fh2_suffix.substring(0, fh2_suffix.indexOf(45));
                }
                if (fh1_suffix.isEmpty() || fh2_suffix.isEmpty()) {
                    return fh1.getName().compareTo(fh2.getName());
                }
                try {
                    return Double.valueOf(fh1_suffix).compareTo(Double.valueOf(fh2_suffix));
                }
                catch (Exception e) {
                    return fh1.getName().compareTo(fh2.getName());
                }
            }
        };
    }

    private static void renamePages(File folder, int page_filename_length) {
        File cur_image;
        ArrayList<File> image_files = FileUtils.getImageFileList(folder);
        Collections.sort(image_files);
        ArrayList<File> cover_image_files = new ArrayList<File>();
        ArrayList<File> backcover_image_files = new ArrayList<File>();
        ArrayList<File> insert_image_files = new ArrayList<File>();
        ArrayList<File> credit_image_files = new ArrayList<File>();
        int i = 0;
        while (i < image_files.size()) {
            cur_image = image_files.get(i);
            char first_char = cur_image.getName().charAt(0);
            if (!Character.isDigit(first_char)) {
                if (cur_image.getName().toLowerCase().contains("cover")) {
                    image_files.remove(i);
                    if (cur_image.getName().toLowerCase().contains("back")) {
                        backcover_image_files.add(cur_image);
                    } else {
                        cover_image_files.add(cur_image);
                    }
                    --i;
                } else if (cur_image.getName().toLowerCase().contains("insert")) {
                    image_files.remove(i);
                    insert_image_files.add(cur_image);
                    --i;
                } else if (cur_image.getName().toLowerCase().contains("credit")) {
                    image_files.remove(i);
                    credit_image_files.add(cur_image);
                    --i;
                }
            }
            ++i;
        }
        i = 0;
        while (i < cover_image_files.size()) {
            image_files.add(0, (File)cover_image_files.get(cover_image_files.size() - i - 1));
            ++i;
        }
        i = 0;
        while (i < insert_image_files.size()) {
            image_files.add(cover_image_files.size(), (File)insert_image_files.get(insert_image_files.size() - i - 1));
            ++i;
        }
        i = 0;
        while (i < backcover_image_files.size()) {
            image_files.add((File)backcover_image_files.get(i));
            ++i;
        }
        i = 0;
        while (i < credit_image_files.size()) {
            image_files.add((File)credit_image_files.get(i));
            ++i;
        }
        i = 0;
        while (i < image_files.size()) {
            cur_image = image_files.get(i);
            String extension = ExtFilter.getExtension(cur_image);
            String new_name = Integer.toString(i);
            while (new_name.length() < page_filename_length) {
                new_name = "0" + new_name;
            }
            File new_image = new File(String.valueOf(cur_image.getParent()) + File.separatorChar + new_name + extension);
            cur_image.renameTo(new_image);
            ++i;
        }
    }

    private static void renameSplitPages(File folder, int page_filename_length) {
        ArrayList<File> image_files = FileUtils.getImageFileList(folder);
        Collections.sort(image_files);
        int i = image_files.size() - 1;
        while (i >= 0) {
            File cur_image = image_files.get(i);
            String extension = ExtFilter.getExtension(cur_image);
            String new_name = Integer.toString(i);
            while (new_name.length() < page_filename_length) {
                new_name = "0" + new_name;
            }
            File new_image = new File(String.valueOf(cur_image.getParent()) + File.separatorChar + new_name + extension);
            cur_image.renameTo(new_image);
            --i;
        }
    }

    private static ArrayList<Integer> processBindFile(File bind_file) {
        ArrayList<Integer> binds = new ArrayList<Integer>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(bind_file));
            boolean done = false;
            while (!done) {
                String line = br.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                line = line.replaceAll(" ", "");
                if ((line = line.replaceAll("\t", "")).equals("") || line.charAt(0) == '#' || line.charAt(0) == '/') continue;
                binds.add(Integer.parseInt(line));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return binds;
    }

    private static void bindFolders(ArrayList<File> folders, File bind_folder, String output_folder_filename, ImageMagick im, String title, boolean use_zip, String zip_extension, boolean use_rar, String rar_extension, SystemRar sysrar, boolean use_pdf, boolean pdf_r_to_l, boolean use_kindle_bookmark, boolean use_comic_zeal_naming, boolean use_epub, boolean epub_r_to_l, int page_filename_length) {
        if (folders.isEmpty() || folders.size() == 0) {
            return;
        }
        int next_starting_number = 0;
        int i = 0;
        while (i < folders.size()) {
            File cur_folder = folders.get(i);
            ArrayList<File> cur_folder_image_list = FileUtils.getImageFileList(cur_folder);
            Collections.sort(cur_folder_image_list);
            int j = 0;
            while (j < cur_folder_image_list.size()) {
                File cur_image = cur_folder_image_list.get(j);
                String extension = ExtFilter.getExtension(cur_image);
                String new_name = Integer.toString(next_starting_number + j);
                while (new_name.length() < page_filename_length) {
                    new_name = "0" + new_name;
                }
                try {
                    FileUtils.copyFile(cur_image, new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + new_name + extension));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            next_starting_number += cur_folder_image_list.size();
            ++i;
        }
        if (use_kindle_bookmark) {
            ArrayList<File> bind_folder_image_list = FileUtils.getImageFileList(bind_folder);
            Collections.sort(bind_folder_image_list);
            File bookmark_file = new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + bind_folder.getName() + ".manga");
            File bookmark_save_file = new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + bind_folder.getName() + ".manga_save");
            ConvertManga.writeKindleBookmark(bind_folder, bookmark_file, bookmark_save_file, bind_folder_image_list.get(0));
        }
        String zip_file_filename = null;
        String rar_file_filename = null;
        if (use_comic_zeal_naming) {
            zip_file_filename = String.valueOf(output_folder_filename) + title + "~" + bind_folder.getName() + zip_extension;
            rar_file_filename = String.valueOf(output_folder_filename) + title + "~" + bind_folder.getName() + rar_extension;
        } else {
            zip_file_filename = String.valueOf(output_folder_filename) + bind_folder.getName() + zip_extension;
            rar_file_filename = String.valueOf(output_folder_filename) + bind_folder.getName() + rar_extension;
        }
        File zip_file = new File(zip_file_filename);
        File rar_file = new File(rar_file_filename);
        File pdf_file = new File(String.valueOf(output_folder_filename) + bind_folder.getName() + ".pdf");
        File epub_file = new File(String.valueOf(output_folder_filename) + bind_folder.getName() + ".epub");
        if (use_zip) {
            FileUtils.zipFolder(bind_folder, zip_file);
        }
        if (use_rar) {
            sysrar.rarFolder(bind_folder, rar_file);
        }
        if (use_pdf) {
            if (pdf_r_to_l) {
                File tmp_r_to_l_folder = new File(String.valueOf(bind_folder.getParent()) + File.separatorChar + bind_folder.getName() + "_TMP_R_TO_L");
                ConvertManga.createFolderOfRToLPages(bind_folder, tmp_r_to_l_folder, page_filename_length);
                im.pdfImageFolder(tmp_r_to_l_folder, pdf_file);
                FileUtils.deleteDirectory(tmp_r_to_l_folder);
            } else {
                im.pdfImageFolder(bind_folder, pdf_file);
            }
        }
        if (use_epub) {
            EpubMaker em = new EpubMaker(bind_folder.getName(), epub_file, folders, page_filename_length, epub_r_to_l);
            em.makeEpub();
        }
    }

    private static void writeKindleBookmark(File cur_dir, File bookmark_file, File bookmark_save_file, File first_file) {
        try {
            JarUtils ju = new JarUtils();
            ju.copyJarFileToFilesystem(default_kindle_bookmark, bookmark_file);
            BufferedWriter bw = new BufferedWriter(new FileWriter(bookmark_save_file));
            bw.write("LAST=/mnt/us/pictures/" + cur_dir.getName() + "/" + first_file.getName());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void outputUsage() {
        System.out.println("\nCanti v1.94");
        System.out.println("Released: November 14, 2010");
        System.out.println("Author: Andrew Mantel");
        System.out.println("Purpose: Process a collection of manga scans for ereader devices.");
        System.out.println("Usage: java -jar Canti.jar [mandatory_arguments] [other_options] [other_operation]");
        System.out.println("Example: java -jar Canti.jar -parent_folder \"C:\\\\Manga\\\\School Rumble\\\\\" -title \"School Rumble\"");
        System.out.println("\nMandatory Arguments: (these arguments MUST be specified)");
        System.out.println("-parent_folder [path to parent_folder]");
        System.out.println("  The parent folder containing subfolders representing chapters.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path; for example, \"C:\\\\manga parent folder\\\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("-title \"Manga Title\"");
        System.out.println("  Title of the manga, such as \"School Rumble\"");
        System.out.println("\nOther Options: (these are all optional)");
        System.out.println("-manga_prefix \"[manga_prefix]\"");
        System.out.println("  This is placed after the manga title but before the subfolder suffix.");
        System.out.println("  Recommended value is something like \"Ch.\" or \"Vol.\" so that the output will look like \"School_Rumble_-_Ch.1\"");
        System.out.println("-bind_prefix \"[bind_prefix]\"");
        System.out.println("  This is placed after the manga title but before the binding number of bound manga.");
        System.out.println("  Recommend value is something like \"Vol.\" or \"Bind.\" so that the output will look like \"School_Rumble_-_Vol.1\"");
        System.out.println("  If not specified, the default value is \"Vol.\"");
        System.out.println("-output_folder [path to output_folder]");
        System.out.println("  The output parent folder. If not specified, default is an \"OUT\" folder created one directory above -parent_folder.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path; for example, \"C:\\\\manga output folder\\\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("-properties [path to .properties file]");
        System.out.println("  Location of the .properties file. By default, Canti assumes that the .properties file is in the same directory as the .jar.");
        System.out.println("  This option is only needed if you want to use a .properties file not located in the default location.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path; for example, \"C:\\\\a folder\\\\Canti.properties\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("-auto_bind [integer]");
        System.out.println("  Enables auto binding of the specified size.");
        System.out.println("  For example: -auto_bind 5 will cause every sequential five image folders to be bound together.");
        System.out.println("  This value supersedes the one in the .properties file.");
        System.out.println("-use_original_filenames [true or false]");
        System.out.println("  If set to true, then the output files will have the same filename as the source files (instead of using -title and suffix to form the output filename).");
        System.out.println("  This value supersedes the one in the .properties file.");
        System.out.println("-num_chars_keep_suffix [integer]");
        System.out.println("  Number of characters to keep from original subfolder suffix.");
        System.out.println("  If you do not set this, or set this to -1, then the program will attempt to auto sense the suffix.");
        System.out.println("  Note that if using auto suffix sensing then each manga folder must end with a number such as 1, 001, 1.11, 001.11, or 01-10 for this to work properly.");
        System.out.println("\nCreating a default .properties file:");
        System.out.println("Usage: java -jar Canti.jar -create_properties [device_name]");
        System.out.println("  The program will create a default .properties file for your particular ereader device.");
        System.out.println("  No manga will be processed when you use this option. This will create the default .properties file and then exit.");
        System.out.println("  Acceptable [device_name] values: " + CMPropertiesWriter.getSupportedDevices());
        System.out.println("  If you don't see your device listed under Acceptable values, enter \"default\" for [device_name] and edit the generated .properties file with the proper settings for your device.");
        System.out.println("\nSee Canti.properties for conversion settings.");
        System.out.println("\nSee readme.txt for manga organization requirements and other tips.");
        System.out.println("\nOther Operations: (these are optional and can only be run one at a time)");
        System.out.println("-analyze_collection [path to root of manga collection]");
        System.out.println("  This will analyze all the files in your manga collection and give you statistics such as number of scans, amount of file space used, etc.");
        System.out.println("  Note that this can take a while to run depending on how large your manga collection is. The program will search and analyze all subdirectories within the specified root folder.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path; for example, \"C:\\\\manga collection\\\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("  See readme.txt for more information on analyzing your manga collection.");
        System.out.println("-analyze_folder [path to manga folder]");
        System.out.println("  This will analyze all the image files in the given manga folder and give you image statistics such as width, height, and dpi.");
        System.out.println("  [path to manga folder] can be an image folder, zip, rar, or pdf. If it is a zip, rar, or pdf, then the images within the file will be extracted to a temporary folder before being analyzed.");
        System.out.println("  The program will search recursively for all images under the path.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path; for example, \"C:\\\\manga parent folder\\\\\" \"C:\\\\manga output folder\\\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("  See readme.txt for more information on analyzing a manga folder.");
        System.out.println("-create_batch [path to root input] [path to root output]");
        System.out.println("  Creates a batch script so that you can process all of the manga series in [path to root input] and output the processed manga to [path to root output].");
        System.out.println("  Note that this operation is not perfect, and you will have to read through the created batch script to make sure it determined all the values correctly.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path; for example, \"C:\\\\manga parent folder\\\\\" \"C:\\\\manga output folder\\\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("  See readme.txt for more information on Canti batch files.");
        System.out.println("");
        System.exit(0);
    }

    protected static boolean isFolderProcessed(File progress_file, File folder) {
        boolean found = false;
        String folder_name = folder.getName();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(progress_file));
            while (!found && (line = br.readLine()) != null) {
                File line_file = new File(line);
                if (!line_file.getName().equals(folder_name)) continue;
                found = true;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return found;
    }

    private static void verifyProgressFile(File progress_file, File output_folder_file) {
        ArrayList<File> processed_folders = new ArrayList<File>();
        ArrayList<String> progress_file_lines = FileUtils.readTextFile(progress_file);
        int i = 0;
        while (i < progress_file_lines.size()) {
            String line = progress_file_lines.get(i);
            if (!line.isEmpty()) {
                File line_file = new File(line);
                processed_folders.add(new File(String.valueOf(output_folder_file.getAbsolutePath()) + File.separatorChar + line_file.getName()));
            }
            ++i;
        }
        ArrayList<File> output_archive_handle_list = new ArrayList<File>();
        ArrayList<File> output_zipList = FileUtils.getZipFileList(output_folder_file);
        ArrayList<File> output_rarList = FileUtils.getRarFileList(output_folder_file);
        int i2 = 0;
        while (i2 < output_zipList.size()) {
            output_archive_handle_list.add(ConvertManga.getOutputFolderHandleFromOutputFile(output_zipList.get(i2)));
            ++i2;
        }
        if (sysrar.canUnrar()) {
            i2 = 0;
            while (i2 < output_rarList.size()) {
                output_archive_handle_list.add(ConvertManga.getOutputFolderHandleFromOutputFile(output_rarList.get(i2)));
                ++i2;
            }
        }
        ArrayList<File> processed_folders_exists = new ArrayList<File>();
        int i3 = 0;
        while (i3 < processed_folders.size()) {
            File cur_processed_folder = (File)processed_folders.get(i3);
            if (cur_processed_folder.exists() || output_archive_handle_list.contains(cur_processed_folder)) {
                processed_folders_exists.add(cur_processed_folder);
            }
            ++i3;
        }
        ArrayList<String> processed_folders_exists_lines = new ArrayList<String>();
        int i4 = 0;
        while (i4 < processed_folders_exists.size()) {
            processed_folders_exists_lines.add(((File)processed_folders_exists.get(i4)).getName());
            ++i4;
        }
        progress_file.delete();
        FileUtils.writeTextFile(progress_file, processed_folders_exists_lines, false);
    }

    private static void addProcessedFolder(File progress_file, File folder) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(progress_file, true));
            bw.write(String.valueOf(folder.getName()) + "\n");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String removeLeadingZeros(String str) {
        String mod_str = str;
        boolean done_leading_zeros = false;
        while (!done_leading_zeros && mod_str.length() >= 2) {
            char cur_char = mod_str.charAt(0);
            char next_char = mod_str.charAt(1);
            if (cur_char == '0') {
                if (Character.isDigit(next_char)) {
                    mod_str = mod_str.substring(1);
                    continue;
                }
                done_leading_zeros = true;
                continue;
            }
            done_leading_zeros = true;
        }
        return mod_str;
    }

    protected static String getFileNumberSuffix(File fh, boolean is_directory) {
        char cur_char;
        boolean done = false;
        boolean found_decimal = false;
        boolean found_hyphen = false;
        String filename = null;
        String suffix = "";
        filename = is_directory ? fh.getName() : ExtFilter.getNameWithoutExtension(fh);
        int j = 0;
        while (!done && j < filename.length()) {
            cur_char = filename.charAt(filename.length() - 1 - j);
            if (cur_char == '.') {
                if (!found_decimal) {
                    int next_char_index = filename.length() - 2 - j;
                    if (next_char_index >= 0) {
                        char next_char = filename.charAt(next_char_index);
                        if (Character.isDigit(next_char) || next_char == '_' || next_char == ' ' || next_char == '-' && !found_hyphen) {
                            suffix = String.valueOf(cur_char) + suffix;
                            found_decimal = true;
                        } else {
                            done = true;
                        }
                    } else {
                        suffix = String.valueOf(cur_char) + suffix;
                        found_decimal = true;
                    }
                } else {
                    done = true;
                }
            } else if (cur_char == '-') {
                if (!found_hyphen) {
                    suffix = String.valueOf(cur_char) + suffix;
                    found_decimal = false;
                    found_hyphen = true;
                } else {
                    done = true;
                }
            } else if (Character.isDigit(cur_char) || cur_char == ' ' || cur_char == '_') {
                suffix = String.valueOf(cur_char) + suffix;
            } else {
                done = true;
            }
            ++j;
        }
        suffix = suffix.replaceAll(" ", "");
        suffix = suffix.replaceAll("_", "");
        boolean done_leading = false;
        while (!done_leading && !suffix.isEmpty()) {
            cur_char = suffix.charAt(0);
            if (Character.isDigit(cur_char)) {
                done_leading = true;
                continue;
            }
            if (cur_char == '.') {
                int hyphen_index = suffix.indexOf(45);
                int decimal_range_index = hyphen_index < 0 ? suffix.length() : hyphen_index;
                boolean found_another_decimal = false;
                int i = 1;
                while (!found_another_decimal && i < decimal_range_index) {
                    if (suffix.charAt(i) == '.') {
                        suffix = suffix.substring(1);
                        found_another_decimal = true;
                    }
                    ++i;
                }
                if (found_another_decimal) continue;
                done_leading = true;
                continue;
            }
            suffix = suffix.length() == 1 ? "" : suffix.substring(1);
        }
        int hyphen_index = suffix.indexOf(45);
        if (hyphen_index == -1) {
            suffix = ConvertManga.removeLeadingZeros(suffix);
        } else {
            String suffix_before_hyphen = suffix.substring(0, hyphen_index);
            String suffix_after_hyphen = suffix.substring(hyphen_index + 1);
            suffix_before_hyphen = ConvertManga.removeLeadingZeros(suffix_before_hyphen);
            suffix_after_hyphen = ConvertManga.removeLeadingZeros(suffix_after_hyphen);
            suffix = String.valueOf(suffix_before_hyphen) + "-" + suffix_after_hyphen;
        }
        if (suffix.length() >= 1 && suffix.charAt(0) == '.') {
            suffix = String.valueOf('0') + suffix;
        }
        return suffix;
    }

    protected static String getFileNumberSuffixPadded(File fh, boolean is_directory, char pad_char, int padded_length) {
        ArrayList<String> suffixes_to_pad = new ArrayList<String>();
        ArrayList<String> suffixes_padded = new ArrayList<String>();
        String suffix = ConvertManga.getFileNumberSuffix(fh, is_directory);
        if (suffix.contains("-")) {
            int hyphen_index = suffix.indexOf(45);
            suffixes_to_pad.add(suffix.substring(0, hyphen_index));
            suffixes_to_pad.add(suffix.substring(hyphen_index + 1));
        } else {
            suffixes_to_pad.add(suffix);
        }
        int i = 0;
        while (i < suffixes_to_pad.size()) {
            String cur_suffix = (String)suffixes_to_pad.get(i);
            int cur_length = 0;
            boolean done = false;
            int j = 0;
            while (!done && j < cur_suffix.length()) {
                char cur_char = cur_suffix.charAt(j);
                if (cur_char == '.') {
                    done = true;
                } else {
                    ++cur_length;
                }
                ++j;
            }
            j = cur_length;
            while (j < padded_length) {
                cur_suffix = "0" + cur_suffix;
                ++j;
            }
            suffixes_padded.add(cur_suffix);
            ++i;
        }
        if (suffixes_padded.size() == 1) {
            return (String)suffixes_padded.get(0);
        }
        return String.valueOf((String)suffixes_padded.get(0)) + "-" + (String)suffixes_padded.get(1);
    }

    private static void createFolderOfRToLPages(File in_folder, File out_folder, int page_filename_length) {
        if (!out_folder.exists()) {
            out_folder.mkdir();
        }
        ArrayList<File> in_folder_images = FileUtils.getImageFileList(in_folder);
        Collections.sort(in_folder_images);
        int i = 0;
        while (i < in_folder_images.size()) {
            File cur_image = in_folder_images.get(i);
            String cur_image_ext = ExtFilter.getExtension(cur_image);
            String new_filename_noext = Integer.toString(in_folder_images.size() - 1 - i);
            while (new_filename_noext.length() < page_filename_length) {
                new_filename_noext = "0" + new_filename_noext;
            }
            File new_image = new File(String.valueOf(out_folder.getAbsolutePath()) + File.separatorChar + new_filename_noext + cur_image_ext);
            try {
                FileUtils.copyFile(cur_image, new_image);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected static void createFolderOfRToLPages(ArrayList<File> in_folders, File out_folder, int page_filename_length) {
        if (!out_folder.exists()) {
            out_folder.mkdir();
        }
        Collections.sort(in_folders);
        int next_starting_number = 0;
        int i = 0;
        while (i < in_folders.size()) {
            File cur_in_folder = in_folders.get(in_folders.size() - 1 - i);
            ArrayList<File> cur_in_folder_images = FileUtils.getImageFileList(cur_in_folder);
            Collections.sort(cur_in_folder_images);
            int j = 0;
            while (j < cur_in_folder_images.size()) {
                File cur_image = cur_in_folder_images.get(j);
                String cur_image_ext = ExtFilter.getExtension(cur_image);
                String new_filename_noext = Integer.toString(cur_in_folder_images.size() - 1 - j + next_starting_number);
                while (new_filename_noext.length() < page_filename_length) {
                    new_filename_noext = "0" + new_filename_noext;
                }
                File new_image = new File(String.valueOf(out_folder.getAbsolutePath()) + File.separatorChar + new_filename_noext + cur_image_ext);
                try {
                    FileUtils.copyFile(cur_image, new_image);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            next_starting_number += cur_in_folder_images.size();
            ++i;
        }
    }

    protected static File getParentFolderHandleFromParentFile(File parent_file_handle, boolean is_directory) {
        File parent_folder_handle = null;
        if (is_directory) {
            parent_folder_handle = parent_file_handle;
        } else {
            String parent_file_filename_noext = ExtFilter.getNameWithoutExtension(parent_file_handle);
            File parent_file_parent_handle = new File(parent_file_handle.getParent());
            parent_folder_handle = parent_file_parent_handle.canWrite() ? new File(String.valueOf(parent_file_handle.getParent()) + File.separatorChar + parent_file_filename_noext) : new File(String.valueOf(output_folder_parent_temp_handle.getAbsolutePath()) + File.separatorChar + parent_file_filename_noext);
        }
        return parent_folder_handle;
    }

    protected static File getOutputFolderHandleFromParentFile(File parent_file_handle, boolean is_directory) {
        File parent_folder_handle = ConvertManga.getParentFolderHandleFromParentFile(parent_file_handle, is_directory);
        String suffix = auto_sense_suffix ? (auto_sense_suffix_length > 0 ? ConvertManga.getFileNumberSuffixPadded(parent_folder_handle, true, '0', auto_sense_suffix_length) : ConvertManga.getFileNumberSuffix(parent_folder_handle, true)) : parent_folder_handle.getName().substring(parent_folder_handle.getName().length() - num_chars_keep_suffix);
        String dest_filename = null;
        File output_folder_handle = null;
        dest_filename = use_original_filenames ? String.valueOf(output_folder_file.getAbsolutePath()) + File.separatorChar + parent_folder_handle.getName() : (!(suffix != null && !suffix.equals("") || manga_prefix != null && !manga_prefix.equals("")) ? String.valueOf(output_folder_file.getAbsolutePath()) + File.separatorChar + title : String.valueOf(output_folder_file.getAbsolutePath()) + File.separatorChar + prefix + suffix);
        output_folder_handle = new File(dest_filename);
        return output_folder_handle;
    }

    protected static File getOutputFolderHandleFromOutputFile(File file_handle) {
        String potential_title_after_tilde;
        String potential_title_before_tilde;
        String filename_noext = file_handle.isDirectory() ? file_handle.getName() : ExtFilter.getNameWithoutExtension(file_handle);
        int tilde_index = filename_noext.indexOf("~", 0);
        if (tilde_index > 0 && (potential_title_before_tilde = filename_noext.substring(0, tilde_index)).length() * 2 + 1 <= filename_noext.length() && potential_title_before_tilde.equals(potential_title_after_tilde = filename_noext.substring(tilde_index + 1, tilde_index + 1 + potential_title_before_tilde.length()))) {
            filename_noext = filename_noext.substring(tilde_index + 1);
        }
        File output_folder_handle = new File(String.valueOf(output_folder_file.getAbsolutePath()) + File.separatorChar + filename_noext);
        return output_folder_handle;
    }

    public static void main(String[] args) throws IOException {
        CMFileObject cur_cmfo;
        CMFileObject cur_cmfo2;
        CMFileObject cur_cmfo3;
        String parent_folder_filename = null;
        String output_folder_filename = null;
        boolean user_set_manga_prefix = false;
        boolean user_set_auto_bind = false;
        boolean user_set_use_original_filenames = false;
        boolean user_set_num_chars_keep_suffix = false;
        boolean use_auto_bind = false;
        boolean did_work = false;
        PropertiesLoader pl = null;
        ArrayList<Object> binds = new ArrayList();
        StopWatch sw = new StopWatch();
        sw.start();
        if (args.length == 0) {
            ConvertManga.outputUsage();
        } else {
            boolean parsed_parent_folder = false;
            boolean parsed_title = false;
            try {
                int i = 0;
                while (i < args.length) {
                    String option = args[i];
                    if (option.equalsIgnoreCase("-parent_folder")) {
                        if ((parent_folder_filename = args[++i]).charAt(parent_folder_filename.length() - 1) != File.separatorChar) {
                            parent_folder_filename = String.valueOf(parent_folder_filename) + File.separatorChar;
                        }
                        parsed_parent_folder = true;
                    } else if (option.equalsIgnoreCase("-title")) {
                        title = args[++i];
                        title = title.replaceAll(" ", "_");
                        parsed_title = true;
                    } else if (option.equalsIgnoreCase("-manga_prefix")) {
                        manga_prefix = args[++i];
                        manga_prefix = manga_prefix.replaceAll(" ", "_");
                        user_set_manga_prefix = true;
                    } else if (option.equalsIgnoreCase("-bind_prefix")) {
                        bind_prefix = args[++i];
                        bind_prefix = bind_prefix.replaceAll(" ", "_");
                    } else if (option.equalsIgnoreCase("-auto_bind")) {
                        auto_bind_size = Integer.parseInt(args[++i]);
                        user_set_auto_bind = true;
                    } else if (option.equalsIgnoreCase("-use_original_filenames")) {
                        use_original_filenames = Boolean.valueOf(args[++i]);
                        user_set_use_original_filenames = true;
                    } else if (option.equalsIgnoreCase("-num_chars_keep_suffix")) {
                        num_chars_keep_suffix = Integer.parseInt(args[++i]);
                        user_set_num_chars_keep_suffix = true;
                    } else if (option.equalsIgnoreCase("-output_folder")) {
                        if ((output_folder_filename = args[++i]).charAt(output_folder_filename.length() - 1) != File.separatorChar) {
                            output_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar;
                        }
                    } else if (option.equalsIgnoreCase("-properties")) {
                        properties_file = new File(args[++i]);
                    } else if (option.equalsIgnoreCase("-disable_binding")) {
                        disable_binding = true;
                    } else if (option.equalsIgnoreCase("-create_properties")) {
                        String device = args[++i].trim().toLowerCase();
                        System.out.println("\nWriting .properties file for " + device + " device, then exiting...");
                        CMPropertiesWriter.writePropertiesFile(null, device);
                        if (properties_file.exists()) {
                            System.out.println("Finished writing default .properties file.");
                            System.out.println("Please read through " + properties_file.getAbsolutePath() + " to see if there are any default settings you would like changed.");
                        } else {
                            System.out.println("ERROR: Cannot find created .properties file. There must have been a problem during file creation.");
                        }
                        System.exit(0);
                    } else if (option.equalsIgnoreCase("-analyze_collection")) {
                        MangaCollection mc = new MangaCollection(new File(args[++i]), properties_file);
                        System.out.println("Analyzing collection... (this can take a while)");
                        mc.collectData();
                        System.out.println("Finished analyzing collection, here are the results:\n" + mc);
                        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
                        File collection_analysis_file = new File("collection_analysis_" + dfm.format(new Date()) + ".txt");
                        String mc_string = mc.toString();
                        String[] mc_string_array = mc_string.split("\\n");
                        ArrayList<String> mc_string_list = new ArrayList<String>();
                        int j = 0;
                        while (j < mc_string_array.length) {
                            mc_string_list.add(mc_string_array[j]);
                            ++j;
                        }
                        FileUtils.writeTextFile(collection_analysis_file, mc_string_list, false);
                        System.out.println("Analysis saved to file: " + collection_analysis_file.getAbsolutePath());
                        System.exit(0);
                    } else if (option.equalsIgnoreCase("-analyze_folder")) {
                        MangaFolder mf = new MangaFolder(new File(args[++i]), properties_file);
                        System.out.println("Analyzing folder...");
                        mf.collectData();
                        System.out.println("Finished analyzing folder, here are the results:\n" + mf);
                        System.exit(0);
                    } else if (option.equalsIgnoreCase("-create_batch")) {
                        BatchCreator cbc = new BatchCreator(new File(args[++i]), new File(args[++i]));
                        System.out.println("Creating batch file...");
                        cbc.createBatchFile();
                        System.out.println("Finished creating batch file.");
                        System.exit(0);
                    } else if (option.equalsIgnoreCase("-create_properties")) {
                        System.out.println("ERROR: When using -create_properties you cannot set any other options.");
                        System.exit(1);
                    } else {
                        System.out.println("ERROR: Invalid option \"" + option + "\"");
                        ConvertManga.outputUsage();
                    }
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("ERROR: Missing arguments. Please check your command line and try again.");
                System.exit(1);
            }
            catch (Exception e) {
                System.out.println("ERROR: There was a problem while interpreting the arguments. Pleace check your command line and try again.");
                System.exit(1);
            }
            if (!parsed_parent_folder || !parsed_title) {
                System.out.println("ERROR: Not all mandatory arguments were specified.");
                ConvertManga.outputUsage();
            }
            if (properties_file.exists()) {
                pl = new PropertiesLoader(properties_file);
            }
            if (!(parent_folder_file = new File(parent_folder_filename)).exists()) {
                System.out.println("ERROR: Cannot find parent folder: " + parent_folder_file.getAbsolutePath());
                System.exit(1);
            }
            if (output_folder_filename == null) {
                String output_base_folder = pl.getOutputBaseFolder();
                if (output_base_folder.equalsIgnoreCase("default")) {
                    output_folder_filename = String.valueOf(parent_folder_file.getParent()) + File.separatorChar + "OUT" + File.separatorChar;
                } else {
                    output_folder_filename = output_base_folder = output_base_folder.replaceAll(" ", "_");
                    if (output_folder_filename.charAt(output_folder_filename.length() - 1) != File.separatorChar) {
                        output_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar;
                    }
                    output_folder_filename = String.valueOf(output_folder_filename) + title + File.separatorChar;
                }
            }
            if (output_folder_filename.equals(parent_folder_filename)) {
                output_folder_filename = String.valueOf(parent_folder_file.getParent()) + File.separatorChar + "OUT" + File.separatorChar;
            }
            if (!(output_folder_file = new File(output_folder_filename)).exists()) {
                FileUtils.recursiveMakeDirectory(output_folder_file);
            }
            if (!(progress_file = new File(String.valueOf(output_folder_filename) + "progress.txt")).exists()) {
                progress_file.createNewFile();
            }
            if ((bind_file = new File(String.valueOf(parent_folder_filename) + "bind.txt")).exists() && !disable_binding) {
                use_bind = true;
                binds = ConvertManga.processBindFile(bind_file);
            }
            if (num_chars_keep_suffix < 0) {
                auto_sense_suffix = true;
            }
        }
        prefix = String.valueOf(title) + " - " + manga_prefix;
        prefix = prefix.replaceAll(" ", "_");
        output_folder_parent_temp_handle = new File(String.valueOf(output_folder_file.getAbsolutePath()) + File.separatorChar + "PARENT_FOLDER_TEMP_-_" + title);
        if (pl == null) {
            pl = new PropertiesLoader(properties_file);
        }
        use_archive = pl.getArchive();
        archive_extension = pl.getArchiveFormat();
        if (!archive_ext_filter.isValid(archive_extension)) {
            System.out.println("ERROR: " + archive_extension + " is not a valid archive extension. Defaulting to .zip");
            archive_extension = ".zip";
        }
        boolean use_zip = false;
        String zip_extension = ".zip";
        if (zip_ext_filter.isValid(archive_extension)) {
            if (use_archive) {
                use_zip = true;
            }
            zip_extension = archive_extension;
        }
        boolean use_rar = false;
        String rar_extension = ".rar";
        if (rar_ext_filter.isValid(archive_extension)) {
            if (use_archive) {
                use_rar = true;
            }
            rar_extension = archive_extension;
        }
        use_pdf = pl.getPdf();
        boolean pdf_r_to_l = pl.getPdfRToL();
        use_epub = pl.getEpub();
        boolean epub_r_to_l = pl.getEpubRToL();
        boolean use_kindle_bookmark = pl.getKindleBookmark();
        use_comic_zeal_naming = pl.getComicZealNaming();
        boolean use_auto_split_landscape_scans = pl.getAutoSplitLandscapeScans();
        boolean auto_split_r_first = pl.getAutoSplitRFirst();
        boolean auto_split_keep_unsplit_scans = pl.getAutoSplitKeepUnsplitScans();
        boolean allow_auto_split_color_scans = pl.getAllowAutoSplitColorScans();
        double auto_split_gray_strictness = pl.getAutoSplitGrayStrictness();
        double auto_split_color_strictness = pl.getAutoSplitColorStrictness();
        double auto_split_buffer = pl.getAutoSplitBuffer();
        boolean auto_sense_landscape_folders = pl.getAutoSenseLandscapeFolders();
        String prop_manga_prefix = pl.getMangaPrefix();
        int page_filename_length = pl.getPageFilenameLength();
        boolean archive_input_image_folders = pl.getArchiveInputImageFolders();
        boolean unarchive_input_image_archives = pl.getUnarchiveInputImageArchives();
        auto_sense_suffix_length = pl.getAutoSenseSuffixLength();
        if (!user_set_use_original_filenames) {
            use_original_filenames = pl.getUseOriginalFilenames();
        }
        if (use_auto_split_landscape_scans) {
            if (auto_split_gray_strictness < 0.0 || auto_split_gray_strictness > 1.0) {
                System.out.println("WARNING: @auto_split_gray_strictness must be a value between 0 and 1.0 inclusive. Defaulting to 0.8");
                auto_split_gray_strictness = 0.8;
            }
            if (auto_split_gray_strictness < 0.0 || auto_split_gray_strictness > 1.0) {
                System.out.println("WARNING: @auto_split_color_strictness must be a value between 0 and 1.0 inclusive. Defaulting to 0.9");
                auto_split_color_strictness = 0.9;
            }
            if (auto_split_buffer < 0.0 || auto_split_buffer > 1.0) {
                System.out.println("WARNING: @auto_split_buffer must be a value between 0 and 1.0 inclusive. Defaulting to 0.");
                auto_split_color_strictness = 0.0;
            }
        }
        if (user_set_num_chars_keep_suffix) {
            use_original_filenames = false;
        }
        if (!user_set_manga_prefix) {
            if (prop_manga_prefix.equalsIgnoreCase("auto")) {
                if (progress_file.exists()) {
                    boolean found = false;
                    File found_file = null;
                    ArrayList<File> output_folder_folderList = FileUtils.getFolderList(output_folder_file);
                    ArrayList<File> output_folder_fileList = FileUtils.getFileList(output_folder_file);
                    int i = 0;
                    while (!found && i < output_folder_folderList.size()) {
                        File cur_folder = output_folder_folderList.get(i);
                        String cur_folder_filename = cur_folder.getName();
                        if (cur_folder_filename.contains(title)) {
                            found_file = cur_folder;
                            found = true;
                        }
                        ++i;
                    }
                    i = 0;
                    while (!found && i < output_folder_fileList.size()) {
                        File cur_file = output_folder_fileList.get(i);
                        String cur_file_filename = cur_file.getName();
                        if (cur_file_filename.contains(title)) {
                            found_file = cur_file;
                            found = true;
                        }
                        ++i;
                    }
                    if (found) {
                        boolean auto_sense_manga_prefix_failed = false;
                        String found_file_filename = null;
                        String found_file_suffix = null;
                        if (found_file.isDirectory()) {
                            found_file_filename = found_file.getName();
                            found_file_suffix = ConvertManga.getFileNumberSuffix(found_file, true);
                        } else {
                            found_file_filename = ExtFilter.getNameWithoutExtension(found_file);
                            found_file_suffix = ConvertManga.getFileNumberSuffix(found_file, false);
                        }
                        String cz_naming_prefix = String.valueOf(title) + "~" + title + "_-_";
                        String default_naming_prefix = String.valueOf(title) + "_-_";
                        if (found_file_filename.indexOf(cz_naming_prefix) == 0) {
                            found_file_filename = found_file_filename.substring(cz_naming_prefix.length());
                        } else if (found_file_filename.indexOf(default_naming_prefix) == 0) {
                            found_file_filename = found_file_filename.substring(default_naming_prefix.length());
                        } else {
                            auto_sense_manga_prefix_failed = true;
                        }
                        found_file_filename = found_file_filename.substring(0, found_file_filename.length() - found_file_suffix.length());
                        manga_prefix = auto_sense_manga_prefix_failed ? "" : found_file_filename;
                    } else {
                        manga_prefix = "";
                    }
                } else {
                    manga_prefix = "";
                }
            } else if (!prop_manga_prefix.equalsIgnoreCase("default")) {
                manga_prefix = prop_manga_prefix;
                manga_prefix = manga_prefix.replaceAll(" ", "_");
                prefix = String.valueOf(title) + " - " + manga_prefix;
                prefix = prefix.replaceAll(" ", "_");
            }
        }
        pl.printProperties();
        if (use_bind && !disable_binding) {
            System.out.println("Found bind.txt file, will perform binding after processing manga.");
        }
        ImageMagick im = new ImageMagick(properties_file);
        String unrar_handler = pl.getUnrarHandler();
        String rar_handler = pl.getRarHandler();
        sysrar = new SystemRar(unrar_handler, rar_handler);
        System.out.println("Testing rar handler...");
        System.out.println("  Can unrar: " + sysrar.canUnrar());
        System.out.println("  Can rar: " + sysrar.canRar());
        if (!sysrar.canUnrar()) {
            System.out.println("  WARNING: Canti was unable to find a compatible program for extracting rar archives; therefore, rar archives cannot be used as input files. Please see readme.txt for instructions on setting up a compatible unrar handler.");
        }
        if (use_rar && !sysrar.canRar()) {
            System.out.println("  ERROR: You have enabled rar archives but Canti cannot find a compatible program for creating rar archives; therefore, rar archive creation would fail. Please see readme.txt for instructions on setting up a compatible rar handler, then try running Canti again.");
            System.exit(1);
        }
        System.out.println("");
        ConvertManga.verifyProgressFile(progress_file, output_folder_file);
        ArrayList<File> zipList = FileUtils.getZipFileList(parent_folder_file);
        ArrayList<File> zipExtractedFolderList = new ArrayList<File>();
        Collections.sort(zipList);
        ArrayList<File> rarList = FileUtils.getRarFileList(parent_folder_file);
        ArrayList<File> rarExtractedFolderList = new ArrayList<File>();
        Collections.sort(rarList);
        ArrayList<File> pdfList = FileUtils.getPdfFileList(parent_folder_file);
        ArrayList<File> pdfExtractedFolderList = new ArrayList<File>();
        Collections.sort(pdfList);
        boolean printed_single_folder_message = false;
        boolean parent_folder_is_zip = zip_ext_filter.isValid(parent_folder_file);
        boolean parent_folder_is_rar = rar_ext_filter.isValid(parent_folder_file);
        boolean parent_folder_is_pdf = pdf_ext_filter.isValid(parent_folder_file);
        if (parent_folder_is_zip) {
            System.out.println("parent_folder " + parent_folder_file.getAbsolutePath() + " is a zip/cbz, so running in single folder mode.\n");
            zipList.add(parent_folder_file);
            single_folder_mode = true;
            printed_single_folder_message = true;
        } else if (parent_folder_is_rar) {
            System.out.println("parent_folder " + parent_folder_file.getAbsolutePath() + " is a rar/cbr, so running in single folder mode.\n");
            rarList.add(parent_folder_file);
            single_folder_mode = true;
            printed_single_folder_message = true;
        } else if (parent_folder_is_pdf) {
            System.out.println("parent_folder " + parent_folder_file.getAbsolutePath() + " is a pdf, so running in single folder mode.\n");
            pdfList.add(parent_folder_file);
            single_folder_mode = true;
            printed_single_folder_message = true;
        }
        ArrayList<CMFileObject> parent_cmfo_archive_pdf_list = new ArrayList<CMFileObject>();
        int i = 0;
        while (i < zipList.size()) {
            parent_cmfo_archive_pdf_list.add(new CMFileObject(zipList.get(i)));
            ++i;
        }
        if (sysrar.canUnrar()) {
            i = 0;
            while (i < rarList.size()) {
                parent_cmfo_archive_pdf_list.add(new CMFileObject(rarList.get(i)));
                ++i;
            }
        }
        i = 0;
        while (i < pdfList.size()) {
            parent_cmfo_archive_pdf_list.add(new CMFileObject(pdfList.get(i)));
            ++i;
        }
        ArrayList<CMFileObject> parent_cmfo_restore_list = new ArrayList<CMFileObject>();
        int i2 = 0;
        while (i2 < parent_cmfo_archive_pdf_list.size()) {
            cur_cmfo3 = (CMFileObject)parent_cmfo_archive_pdf_list.get(i2);
            if (cur_cmfo3.getMustRestoreParent()) {
                parent_cmfo_restore_list.add(cur_cmfo3);
            }
            ++i2;
        }
        if (parent_cmfo_restore_list.size() > 0) {
            System.out.println("Restoring " + parent_cmfo_restore_list.size() + " image folders in parent_folder...");
        }
        i2 = 0;
        while (i2 < parent_cmfo_restore_list.size()) {
            cur_cmfo3 = (CMFileObject)parent_cmfo_restore_list.get(i2);
            File cur_parent_file = cur_cmfo3.getParentFileHandle();
            File cur_tmp_folder = cur_cmfo3.getParentFolderHandle();
            if (zip_ext_filter.isValid(cur_parent_file)) {
                FileUtils.unzipFile(cur_parent_file, cur_tmp_folder);
                zipExtractedFolderList.add(cur_tmp_folder);
                did_work = true;
            } else if (rar_ext_filter.isValid(cur_parent_file) && sysrar.canUnrar()) {
                sysrar.unrarFile(cur_parent_file, cur_tmp_folder);
                rarExtractedFolderList.add(cur_tmp_folder);
                did_work = true;
            } else if (pdf_ext_filter.isValid(cur_parent_file)) {
                im.convertPdfToImageFolder(cur_tmp_folder, cur_tmp_folder);
                pdfExtractedFolderList.add(cur_tmp_folder);
                did_work = true;
            }
            if (single_folder_mode) {
                parent_folder_file = cur_tmp_folder;
            }
            ++i2;
        }
        ArrayList<File> folderList = FileUtils.getFolderList(parent_folder_file);
        if (use_original_filenames) {
            Collections.sort(folderList);
        } else {
            Collections.sort(folderList, comp_file_number_suffix_order);
        }
        if (folderList.isEmpty() && parent_folder_file.isDirectory() && zipList.isEmpty() && rarList.isEmpty() && pdfList.isEmpty()) {
            if (!printed_single_folder_message) {
                System.out.println("parent_folder " + parent_folder_file.getAbsolutePath() + " is a directory that did not contain any subfolders, so running in single folder mode.\n");
            }
            single_folder_mode = true;
            folderList.add(parent_folder_file);
        }
        if (!use_bind && !disable_binding && (pl.getAutoBind() || user_set_auto_bind)) {
            use_auto_bind = true;
            use_bind = true;
        }
        if (single_folder_mode || disable_binding) {
            use_bind = false;
        }
        boolean found_empty_folder = false;
        boolean found_subfolder = false;
        int i3 = 0;
        while (!folderList.isEmpty() && i3 < folderList.size()) {
            File cur_folder = folderList.get(i3);
            ArrayList<File> image_files = FileUtils.getImageFileList(cur_folder);
            if (image_files.isEmpty()) {
                ArrayList<File> cur_folder_folderList = FileUtils.getFolderList(cur_folder);
                if (cur_folder_folderList.size() == 1) {
                    File cur_folder_subfolder = cur_folder_folderList.get(0);
                    image_files = FileUtils.getImageFileList(cur_folder_subfolder);
                    if (!image_files.isEmpty()) {
                        found_subfolder = true;
                        System.out.println("Found images one folder deep in " + cur_folder.getAbsolutePath() + ", moving the images up one directory and deleting subfolder.");
                        FileUtils.copyDirectory(cur_folder_subfolder, cur_folder);
                        FileUtils.deleteDirectory(cur_folder_subfolder);
                    } else {
                        found_empty_folder = true;
                        System.out.println("Ignoring folder " + cur_folder.getAbsolutePath() + " because it has no image files.");
                        folderList.remove(i3);
                        --i3;
                    }
                } else {
                    found_empty_folder = true;
                    System.out.println("Ignoring folder " + cur_folder.getAbsolutePath() + " because it has no image files.");
                    folderList.remove(i3);
                    --i3;
                }
            }
            ++i3;
        }
        if (found_empty_folder || found_subfolder) {
            System.out.println("");
        }
        ArrayList<CMFileObject> cmfo_list = new ArrayList<CMFileObject>();
        int i4 = 0;
        while (i4 < folderList.size()) {
            cmfo_list.add(new CMFileObject(folderList.get(i4)));
            ++i4;
        }
        i4 = 0;
        while (i4 < zipList.size()) {
            cur_cmfo2 = new CMFileObject(zipList.get(i4));
            if (!cur_cmfo2.isInArrayListByOFHMatch(cmfo_list)) {
                cmfo_list.add(cur_cmfo2);
            }
            ++i4;
        }
        if (sysrar.canUnrar()) {
            i4 = 0;
            while (i4 < rarList.size()) {
                cur_cmfo2 = new CMFileObject(rarList.get(i4));
                if (!cur_cmfo2.isInArrayListByOFHMatch(cmfo_list)) {
                    cmfo_list.add(cur_cmfo2);
                }
                ++i4;
            }
        }
        i4 = 0;
        while (i4 < pdfList.size()) {
            cur_cmfo2 = new CMFileObject(pdfList.get(i4));
            if (!cur_cmfo2.isInArrayListByOFHMatch(cmfo_list)) {
                cmfo_list.add(cur_cmfo2);
            }
            ++i4;
        }
        if (!disable_binding && (use_bind || !use_bind && !single_folder_mode && (pl.getAutoBind() || user_set_auto_bind))) {
            manga_prefix = "";
        }
        if (use_bind && !disable_binding && !manga_prefix.isEmpty() && manga_prefix.equals(bind_prefix)) {
            bind_prefix = !manga_prefix.equals("Bind.") ? "Bind." : "Vol.";
            System.out.println("WARNING: manga_prefix is the same as bind_prefix. Changing bind_prefix to \"" + bind_prefix + "\".");
        }
        ArrayList<CMFileObject> output_cmfo_restore_list = new ArrayList<CMFileObject>();
        int i5 = 0;
        while (i5 < cmfo_list.size()) {
            CMFileObject cur_cmfo4 = cmfo_list.get(i5);
            if (cur_cmfo4.getMustRestoreOutput()) {
                output_cmfo_restore_list.add(cur_cmfo4);
            }
            ++i5;
        }
        if (output_cmfo_restore_list.size() > 0) {
            System.out.println("Restoring " + output_cmfo_restore_list.size() + " image folders in output_folder...");
        }
        ArrayList<File> restoredFromZipFolderList = new ArrayList<File>();
        ArrayList<File> restoredFromRarFolderList = new ArrayList<File>();
        int i6 = 0;
        while (i6 < output_cmfo_restore_list.size()) {
            CMFileObject cur_cmfo5 = (CMFileObject)output_cmfo_restore_list.get(i6);
            File cur_output_archive_file = cur_cmfo5.getOutputArchiveHandle();
            File cur_output_folder_handle = cur_cmfo5.getOutputFolderHandle();
            if (zip_ext_filter.isValid(cur_output_archive_file)) {
                FileUtils.unzipFile(cur_output_archive_file, cur_output_folder_handle);
                restoredFromZipFolderList.add(cur_output_folder_handle);
                did_work = true;
            } else if (rar_ext_filter.isValid(cur_output_archive_file) && sysrar.canUnrar()) {
                sysrar.unrarFile(cur_output_archive_file, cur_output_folder_handle);
                restoredFromRarFolderList.add(cur_output_folder_handle);
                did_work = true;
            }
            ++i6;
        }
        ArrayList<CMFileObject> parent_cmfo_copy_list = new ArrayList<CMFileObject>();
        int i7 = 0;
        while (i7 < cmfo_list.size()) {
            cur_cmfo = cmfo_list.get(i7);
            if (cur_cmfo.getMustCopyParent()) {
                parent_cmfo_copy_list.add(cur_cmfo);
            }
            ++i7;
        }
        if (parent_cmfo_copy_list.size() > 0) {
            System.out.println("Copying files to new folders...");
        }
        i7 = 0;
        while (i7 < parent_cmfo_copy_list.size()) {
            File destination;
            cur_cmfo = (CMFileObject)parent_cmfo_copy_list.get(i7);
            File source = cur_cmfo.getParentFolderHandle();
            if (source.exists() && !(destination = cur_cmfo.getOutputFolderHandle()).exists()) {
                destination.mkdir();
                ArrayList<File> source_image_list = FileUtils.getImageFileList(source);
                int j = 0;
                while (j < source_image_list.size()) {
                    File cur_image = source_image_list.get(j);
                    FileUtils.copyFile(cur_image, new File(String.valueOf(destination.getAbsolutePath()) + File.separatorChar + cur_image.getName()));
                    did_work = true;
                    ++j;
                }
            }
            ++i7;
        }
        if (!pl.getUnarchiveInputImageArchives()) {
            i7 = 0;
            while (i7 < zipExtractedFolderList.size()) {
                FileUtils.deleteDirectory((File)zipExtractedFolderList.get(i7));
                ++i7;
            }
            i7 = 0;
            while (i7 < rarExtractedFolderList.size()) {
                FileUtils.deleteDirectory((File)rarExtractedFolderList.get(i7));
                ++i7;
            }
            i7 = 0;
            while (i7 < pdfExtractedFolderList.size()) {
                FileUtils.deleteDirectory((File)pdfExtractedFolderList.get(i7));
                ++i7;
            }
        }
        ArrayList<CMFileObject> output_cmfo_process_list = new ArrayList<CMFileObject>();
        int i8 = 0;
        while (i8 < cmfo_list.size()) {
            CMFileObject cur_cmfo6 = cmfo_list.get(i8);
            if (cur_cmfo6.getMustProcess()) {
                output_cmfo_process_list.add(cur_cmfo6);
            }
            ++i8;
        }
        long time_before_processing = sw.getElapsedTimeSecs();
        if (output_cmfo_process_list.size() > 0) {
            System.out.println("Processing manga scans using ImageMagick...");
        }
        int num_folders_processed = 0;
        if (use_original_filenames) {
            Collections.sort(output_cmfo_process_list, CMFileObject.comp_filename_order);
        } else {
            Collections.sort(output_cmfo_process_list, CMFileObject.comp_suffix_order);
        }
        int i9 = 0;
        while (i9 < output_cmfo_process_list.size()) {
            CMFileObject cur_cmfo7 = (CMFileObject)output_cmfo_process_list.get(i9);
            File cur_folder = cur_cmfo7.getOutputFolderHandle();
            if (cur_folder.exists()) {
                File epub_file;
                File pdf_file;
                File archive_file;
                if (num_folders_processed != 0) {
                    String approx_time_remaining = StopWatch.formatTime((long)(output_cmfo_process_list.size() - i9) * (sw.getElapsedTimeSecs() - time_before_processing) / (long)num_folders_processed);
                    System.out.println("  Processing folder: " + cur_folder.getName() + "... (approx " + approx_time_remaining + " remaining)");
                } else {
                    System.out.println("  Processing folder: " + cur_folder.getName() + "...");
                }
                File bookmark_file = new File(String.valueOf(cur_folder.getAbsolutePath()) + File.separatorChar + cur_folder.getName() + ".manga");
                File bookmark_save_file = new File(String.valueOf(cur_folder.getAbsolutePath()) + File.separatorChar + cur_folder.getName() + ".manga_save");
                boolean processed = ConvertManga.isFolderProcessed(progress_file, cur_folder);
                if (!processed) {
                    ConvertManga.renamePages(cur_folder, page_filename_length);
                    ArrayList<File> image_files = FileUtils.getImageFileList(cur_folder);
                    Collections.sort(image_files);
                    im.preprocessImages(image_files);
                    boolean performed_split = false;
                    if (use_auto_split_landscape_scans) {
                        boolean perform_splits_on_folder = true;
                        ArrayList<ImageData> ids = ImageUtils.getImageDataOfImageFiles(image_files);
                        if (auto_sense_landscape_folders) {
                            int num_landscape_scans = 0;
                            int num_invalid_ids = 0;
                            int j = 0;
                            while (j < ids.size()) {
                                ImageData cur_id = ids.get(j);
                                if (cur_id == null) {
                                    ++num_invalid_ids;
                                } else if (cur_id.width > cur_id.height) {
                                    ++num_landscape_scans;
                                }
                                ++j;
                            }
                            double num_analyzed_ids = (double)ids.size() - (double)num_invalid_ids;
                            if (num_analyzed_ids > 0.0 && (double)num_landscape_scans / num_analyzed_ids < 0.5) {
                                perform_splits_on_folder = false;
                            }
                        }
                        if (perform_splits_on_folder) {
                            int j = 0;
                            while (j < image_files.size()) {
                                int x_split_pos;
                                File cur_image = image_files.get(j);
                                ImageData cur_image_id = ids.get(j);
                                if (cur_image_id != null && (x_split_pos = ImageUtils.isTwoPages(cur_image, -1, true, allow_auto_split_color_scans, auto_split_gray_strictness, auto_split_color_strictness)) > 0) {
                                    im.splitImage(cur_image, (int)cur_image_id.width, (int)cur_image_id.height, x_split_pos, auto_split_r_first, auto_split_buffer);
                                    performed_split = true;
                                    if (!auto_split_keep_unsplit_scans) {
                                        cur_image.delete();
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                    if (performed_split) {
                        image_files = FileUtils.getImageFileList(cur_folder);
                        Collections.sort(image_files);
                    }
                    int j = 0;
                    while (j < image_files.size()) {
                        File cur_image = image_files.get(j);
                        im.processImage(cur_image);
                        ++j;
                    }
                    if (performed_split) {
                        ConvertManga.renameSplitPages(cur_folder, page_filename_length);
                    }
                    if (use_kindle_bookmark) {
                        image_files = FileUtils.getImageFileList(cur_folder);
                        Collections.sort(image_files);
                        if (image_files.size() > 0) {
                            ConvertManga.writeKindleBookmark(cur_folder, bookmark_file, bookmark_save_file, image_files.get(0));
                        }
                    }
                    ConvertManga.addProcessedFolder(progress_file, cur_folder);
                    ++num_folders_processed;
                    did_work = true;
                }
                if ((archive_file = cur_cmfo7.getOutputArchiveHandle()) != null && !use_bind && !archive_file.exists()) {
                    if (zip_ext_filter.isValid(archive_file)) {
                        FileUtils.zipFolder(cur_folder, archive_file);
                        did_work = true;
                    } else if (rar_ext_filter.isValid(archive_file)) {
                        sysrar.rarFolder(cur_folder, archive_file);
                        did_work = true;
                    }
                }
                if ((pdf_file = cur_cmfo7.getOutputPdfHandle()) != null && !use_bind && !pdf_file.exists()) {
                    if (pdf_r_to_l) {
                        File tmp_r_to_l_folder = new File(String.valueOf(output_folder_file.getAbsolutePath()) + File.separatorChar + cur_folder.getName() + "_TMP_R_TO_L");
                        ConvertManga.createFolderOfRToLPages(cur_folder, tmp_r_to_l_folder, page_filename_length);
                        im.pdfImageFolder(tmp_r_to_l_folder, pdf_file);
                        FileUtils.deleteDirectory(tmp_r_to_l_folder);
                        did_work = true;
                    } else {
                        im.pdfImageFolder(cur_folder, pdf_file);
                        did_work = true;
                    }
                }
                if ((epub_file = cur_cmfo7.getOutputEpubHandle()) != null && !use_bind && !epub_file.exists()) {
                    EpubMaker em = new EpubMaker(cur_folder.getName(), epub_file, cur_folder, page_filename_length, epub_r_to_l);
                    em.makeEpub();
                    did_work = true;
                }
            }
            ++i9;
        }
        ArrayList<File> folders_for_binding_list = new ArrayList<File>();
        int i10 = 0;
        while (i10 < cmfo_list.size()) {
            CMFileObject cur_cmfo8 = cmfo_list.get(i10);
            File cur_cmfo_ofh = cur_cmfo8.getOutputFolderHandle();
            if (cur_cmfo_ofh.exists()) {
                folders_for_binding_list.add(cur_cmfo_ofh);
            }
            ++i10;
        }
        if (use_bind && !disable_binding && !use_auto_bind) {
            int total_num_binds = 0;
            int i11 = 0;
            while (i11 < binds.size()) {
                total_num_binds += ((Integer)binds.get(i11)).intValue();
                ++i11;
            }
            if (total_num_binds > folders_for_binding_list.size()) {
                System.out.println("ERROR: Total number of binds (" + total_num_binds + ") is greater than the number of manga folders (" + cmfo_list.size() + ") in " + parent_folder_filename + ". The number of binds must be equal to or less than the number of manga folders. Please correct the bind.txt file before running again.");
                use_bind = false;
            }
        }
        if (use_auto_bind && !disable_binding) {
            if (!user_set_auto_bind) {
                auto_bind_size = pl.getAutoBindSize();
            }
            int num_full = folders_for_binding_list.size() / auto_bind_size;
            int num_left_over = folders_for_binding_list.size() % auto_bind_size;
            int i12 = 0;
            while (i12 < num_full) {
                binds.add(auto_bind_size);
                ++i12;
            }
            if (num_left_over != 0) {
                binds.add(num_left_over);
            }
        }
        ArrayList<File> bind_folders = new ArrayList<File>();
        if (use_bind && !disable_binding) {
            System.out.println("\nBeginning binding...");
            ArrayList<File> unbound_folders = new ArrayList<File>();
            int i13 = 0;
            while (i13 < folders_for_binding_list.size()) {
                unbound_folders.add((File)folders_for_binding_list.get(i13));
                ++i13;
            }
            if (use_original_filenames) {
                Collections.sort(unbound_folders);
            } else {
                Collections.sort(unbound_folders, comp_file_number_suffix_order);
            }
            i13 = 0;
            while (i13 < binds.size()) {
                int cur_bind = (Integer)binds.get(i13);
                String bind_title = String.valueOf(title) + "_-_" + bind_prefix + Integer.toString(i13 + 1);
                bind_title = bind_title.replaceAll(" ", "_");
                String bind_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar + bind_title;
                File bind_folder = new File(bind_folder_filename);
                if (bind_folder.exists()) {
                    FileUtils.deleteDirectory(bind_folder);
                }
                bind_folder.mkdir();
                ArrayList<File> folders_to_bind = new ArrayList<File>();
                int j = 0;
                while (j < cur_bind) {
                    folders_to_bind.add((File)unbound_folders.remove(0));
                    ++j;
                }
                System.out.println("  Binding folders:");
                j = 0;
                while (j < folders_to_bind.size()) {
                    System.out.println("    " + ((File)folders_to_bind.get(j)).getName());
                    ++j;
                }
                System.out.println("  to form " + bind_title + "...");
                ConvertManga.bindFolders(folders_to_bind, bind_folder, output_folder_filename, im, title, use_zip, zip_extension, use_rar, rar_extension, sysrar, use_pdf, pdf_r_to_l, use_kindle_bookmark, use_comic_zeal_naming, use_epub, epub_r_to_l, page_filename_length);
                bind_folders.add(bind_folder);
                did_work = true;
                ++i13;
            }
        }
        if (output_folder_parent_temp_handle.exists()) {
            if (unarchive_input_image_archives || archive_input_image_folders) {
                System.out.println("\nAlthough you requested to unarchive input image archives and/or archive input image folders, this cannot be performed since you do not have write permission to parent_folder.");
            }
            unarchive_input_image_archives = false;
            archive_input_image_folders = false;
            System.out.println("\nDeleting parent_folder temp directory in output_folder...");
            FileUtils.deleteDirectory(output_folder_parent_temp_handle);
        }
        if (unarchive_input_image_archives) {
            if (single_folder_mode) {
                folderList.clear();
                folderList.add(parent_folder_file);
            } else {
                folderList = FileUtils.getFolderList(parent_folder_file);
            }
            Collections.sort(folderList);
            ArrayList<String> folderList_filenames = new ArrayList<String>();
            int i14 = 0;
            while (!folderList.isEmpty() && i14 < folderList.size()) {
                File cur_folder = folderList.get(i14);
                ArrayList<File> image_files = FileUtils.getImageFileList(cur_folder);
                if (image_files.isEmpty()) {
                    folderList.remove(i14);
                    --i14;
                } else {
                    folderList_filenames.add(cur_folder.getName());
                }
                ++i14;
            }
            ArrayList<File> archiveList = null;
            archiveList = single_folder_mode ? FileUtils.getArchiveFileList(new File(parent_folder_file.getParent())) : FileUtils.getArchiveFileList(parent_folder_file);
            if (!archiveList.isEmpty() && !folderList.isEmpty()) {
                System.out.println("\nDeleting input image archives...");
            }
            int i15 = 0;
            while (i15 < archiveList.size()) {
                File cur_archive = archiveList.get(i15);
                String cur_archive_filename_noext = ExtFilter.getNameWithoutExtension(cur_archive);
                if (folderList_filenames.contains(cur_archive_filename_noext)) {
                    cur_archive.delete();
                }
                ++i15;
            }
        } else if (archive_input_image_folders) {
            if (single_folder_mode) {
                folderList.clear();
                folderList.add(parent_folder_file);
            } else {
                folderList = FileUtils.getFolderList(parent_folder_file);
            }
            Collections.sort(folderList);
            int i16 = 0;
            while (!folderList.isEmpty() && i16 < folderList.size()) {
                File cur_folder = folderList.get(i16);
                ArrayList<File> image_files = FileUtils.getImageFileList(cur_folder);
                if (image_files.isEmpty()) {
                    folderList.remove(i16);
                    --i16;
                }
                ++i16;
            }
            if (!folderList.isEmpty()) {
                System.out.println("\nArchiving input image folders, then deleting the folders...");
            }
            i16 = 0;
            while (i16 < folderList.size()) {
                File cur_folder = folderList.get(i16);
                File new_zip_file = new File(String.valueOf(cur_folder.getParent()) + File.separatorChar + cur_folder.getName() + ".zip");
                File new_cbz_file = new File(String.valueOf(cur_folder.getParent()) + File.separatorChar + cur_folder.getName() + ".cbz");
                File new_rar_file = new File(String.valueOf(cur_folder.getParent()) + File.separatorChar + cur_folder.getName() + ".rar");
                File new_cbr_file = new File(String.valueOf(cur_folder.getParent()) + File.separatorChar + cur_folder.getName() + ".cbr");
                File new_archive_file = new File(String.valueOf(cur_folder.getParent()) + File.separatorChar + cur_folder.getName() + archive_extension);
                if (new_zip_file.exists() || new_cbz_file.exists() || new_rar_file.exists() || new_cbr_file.exists()) {
                    FileUtils.deleteDirectory(cur_folder);
                } else if (use_zip) {
                    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(new_archive_file));
                    FileUtils.zipFolderRecursive(cur_folder.getAbsolutePath(), cur_folder.getAbsolutePath(), zos);
                    zos.close();
                    FileUtils.deleteDirectory(cur_folder);
                    did_work = true;
                } else if (use_rar && sysrar.rarFolder(cur_folder, new_archive_file)) {
                    FileUtils.deleteDirectory(cur_folder);
                    did_work = true;
                }
                ++i16;
            }
        }
        if (pl.getDelOutputImageFolders()) {
            folderList = FileUtils.getFolderList(output_folder_file);
            Collections.sort(folderList);
            boolean printed_deleting_output_folders_message = false;
            boolean no_output_archive = false;
            StopWatch sw_del = new StopWatch();
            int i17 = 0;
            while (i17 < folderList.size()) {
                File cur_folder = folderList.get(i17);
                ArrayList<File> potential_archives = new ArrayList<File>();
                potential_archives.add(new File(String.valueOf(output_folder_filename) + title + "~" + cur_folder.getName() + ".zip"));
                potential_archives.add(new File(String.valueOf(output_folder_filename) + title + "~" + cur_folder.getName() + ".cbz"));
                potential_archives.add(new File(String.valueOf(output_folder_filename) + title + "~" + cur_folder.getName() + ".rar"));
                potential_archives.add(new File(String.valueOf(output_folder_filename) + title + "~" + cur_folder.getName() + ".cbr"));
                potential_archives.add(new File(String.valueOf(output_folder_filename) + cur_folder.getName() + ".zip"));
                potential_archives.add(new File(String.valueOf(output_folder_filename) + cur_folder.getName() + ".cbz"));
                potential_archives.add(new File(String.valueOf(output_folder_filename) + cur_folder.getName() + ".rar"));
                potential_archives.add(new File(String.valueOf(output_folder_filename) + cur_folder.getName() + ".cbr"));
                boolean found_archive = false;
                int j = 0;
                while (!found_archive && j < potential_archives.size()) {
                    if (((File)potential_archives.get(j)).exists()) {
                        found_archive = true;
                    }
                    ++j;
                }
                if (!found_archive) {
                    if (restoredFromZipFolderList.contains(cur_folder)) {
                        found_archive = true;
                    } else if (restoredFromRarFolderList.contains(cur_folder)) {
                        found_archive = true;
                    }
                }
                if (found_archive) {
                    boolean deleted;
                    if (!printed_deleting_output_folders_message) {
                        System.out.println("\nDeleting output image folders...");
                        printed_deleting_output_folders_message = true;
                    }
                    if (!(deleted = FileUtils.deleteDirectory(cur_folder))) {
                        sw_del.reset();
                        sw_del.start();
                        while (!deleted && sw_del.getElapsedTimeSecs() < 10L) {
                            deleted = FileUtils.deleteDirectory(cur_folder);
                        }
                        sw_del.stop();
                        if (!deleted) {
                            try {
                                Thread.sleep(5000L);
                                int attempt = 0;
                                while (!deleted && attempt < 5) {
                                    deleted = FileUtils.deleteDirectory(cur_folder);
                                    Thread.sleep(1000L);
                                    ++attempt;
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (cur_folder.exists()) {
                        System.out.println("  ERROR: Failed to delete output image folder: " + cur_folder.getAbsolutePath() + "  You will have to delete this folder manually.");
                    }
                } else {
                    no_output_archive = true;
                }
                ++i17;
            }
            if (use_bind && !disable_binding) {
                if (bind_folders.size() > 0) {
                    System.out.println("\nDeleting output bind image folders...");
                }
                sw_del = new StopWatch();
                i17 = 0;
                while (i17 < bind_folders.size()) {
                    File cur_bind_folder = (File)bind_folders.get(i17);
                    boolean deleted = FileUtils.deleteDirectory(cur_bind_folder);
                    did_work = true;
                    if (!deleted) {
                        sw_del.reset();
                        sw_del.start();
                        while (!deleted && sw_del.getElapsedTimeSecs() < 10L) {
                            deleted = FileUtils.deleteDirectory(cur_bind_folder);
                        }
                        sw_del.stop();
                        if (!deleted) {
                            try {
                                Thread.sleep(5000L);
                                int attempt = 0;
                                while (!deleted && attempt < 5) {
                                    deleted = FileUtils.deleteDirectory(cur_bind_folder);
                                    Thread.sleep(1000L);
                                    ++attempt;
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (cur_bind_folder.exists()) {
                        System.out.println("  ERROR: Failed to delete output bind image folder: " + cur_bind_folder.getAbsolutePath() + "  You will have to delete this folder manually.");
                    }
                    ++i17;
                }
                if (no_output_archive) {
                    System.out.println("\nAlthough you requested to delete output image folders, this cannot be allowed with your current settings. Check to make sure that @archive is enabled and binding (either through bind file or auto-binding) is disabled.");
                }
            }
        }
        sw.stop();
        System.out.print("\nFinished");
        if (!did_work) {
            System.out.println(" (there was nothing to do).");
        } else {
            System.out.println(".");
        }
        System.out.println("Total time: " + StopWatch.formatTime(sw.getElapsedTimeSecs()));
        System.out.println("Check folder " + output_folder_filename + " for output.");
    }
}

