/*
 * Decompiled with CFR 0.152.
 */
package common.utils;

import common.utils.ExtFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    public static ArrayList<File> getFolderList(File folder) {
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> listOfFolders = new ArrayList<File>();
        if (listOfFiles != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isDirectory()) {
                    listOfFolders.add(listOfFiles[i]);
                }
                ++i;
            }
        }
        return listOfFolders;
    }

    public static ArrayList<File> getFileList(File folder) {
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> listOfFiles_strict = new ArrayList<File>();
        if (listOfFiles != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isFile()) {
                    listOfFiles_strict.add(listOfFiles[i]);
                }
                ++i;
            }
        }
        return listOfFiles_strict;
    }

    public static ArrayList<File> getFileListRecursive(File folder) {
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> listOfFiles_strict = new ArrayList<File>();
        if (listOfFiles != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isFile()) {
                    listOfFiles_strict.add(listOfFiles[i]);
                } else {
                    ArrayList<File> sub_files = FileUtils.getFileListRecursive(listOfFiles[i]);
                    int j = 0;
                    while (j < sub_files.size()) {
                        listOfFiles_strict.add(sub_files.get(j));
                        ++j;
                    }
                }
                ++i;
            }
        }
        return listOfFiles_strict;
    }

    public static ArrayList<File> getFilenameInstancesRecursive(File folder, String filename) {
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> filename_instances = new ArrayList<File>();
        if (listOfFiles != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isFile()) {
                    if (listOfFiles[i].getName().equals(filename)) {
                        filename_instances.add(listOfFiles[i]);
                    }
                } else {
                    ArrayList<File> sub_filename_instances = FileUtils.getFilenameInstancesRecursive(listOfFiles[i], filename);
                    int j = 0;
                    while (j < sub_filename_instances.size()) {
                        filename_instances.add(sub_filename_instances.get(j));
                        ++j;
                    }
                }
                ++i;
            }
        }
        return filename_instances;
    }

    public static ArrayList<File> getImageFileList(File folder) {
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> listOfImageFiles_strict = new ArrayList<File>();
        ExtFilter image_filter = new ExtFilter("image");
        if (listOfFiles != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isFile() && image_filter.isValid(listOfFiles[i])) {
                    listOfImageFiles_strict.add(listOfFiles[i]);
                }
                ++i;
            }
        }
        return listOfImageFiles_strict;
    }

    public static ArrayList<File> getZipFileList(File folder) {
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> listOfZipFiles_strict = new ArrayList<File>();
        ExtFilter zip_filter = new ExtFilter("zip");
        if (listOfFiles != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isFile() && zip_filter.isValid(listOfFiles[i])) {
                    listOfZipFiles_strict.add(listOfFiles[i]);
                }
                ++i;
            }
        }
        return listOfZipFiles_strict;
    }

    public static ArrayList<File> getRarFileList(File folder) {
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> listOfRarFiles_strict = new ArrayList<File>();
        ExtFilter rar_filter = new ExtFilter("rar");
        if (listOfFiles != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isFile() && rar_filter.isValid(listOfFiles[i])) {
                    listOfRarFiles_strict.add(listOfFiles[i]);
                }
                ++i;
            }
        }
        return listOfRarFiles_strict;
    }

    public static ArrayList<File> getArchiveFileList(File folder) {
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> listOfArchiveFiles_strict = new ArrayList<File>();
        ExtFilter archive_filter = new ExtFilter("archive");
        if (listOfFiles != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isFile() && archive_filter.isValid(listOfFiles[i])) {
                    listOfArchiveFiles_strict.add(listOfFiles[i]);
                }
                ++i;
            }
        }
        return listOfArchiveFiles_strict;
    }

    public static ArrayList<File> getPdfFileList(File folder) {
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> listOfPdfFiles_strict = new ArrayList<File>();
        ExtFilter pdf_filter = new ExtFilter("pdf");
        if (listOfFiles != null) {
            int i = 0;
            while (i < listOfFiles.length) {
                if (listOfFiles[i].isFile() && pdf_filter.isValid(listOfFiles[i])) {
                    listOfPdfFiles_strict.add(listOfFiles[i]);
                }
                ++i;
            }
        }
        return listOfPdfFiles_strict;
    }

    public static void recursiveMakeDirectory(File path) {
        if (!path.exists()) {
            File parent_path = path.getParentFile();
            if (parent_path != null && !parent_path.exists()) {
                FileUtils.recursiveMakeDirectory(parent_path);
            }
            path.mkdir();
        }
    }

    public static boolean deleteDirectory(File path) {
        if (!path.exists()) {
            return true;
        }
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    FileUtils.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }

    public static void copyDirectory(File sourceDir, File destDir) throws IOException {
        File[] children = sourceDir.listFiles();
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File sourceChild = fileArray[n2];
            String name = sourceChild.getName();
            File destChild = new File(destDir, name);
            if (sourceChild.isDirectory()) {
                FileUtils.copyDirectory(sourceChild, destChild);
            } else {
                FileUtils.copyFile(sourceChild, destChild);
            }
            ++n2;
        }
    }

    public static void copyFile(File source, File dest) throws IOException {
        if (!dest.exists()) {
            dest.createNewFile();
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    public static ArrayList<String> readTextFile(File text_file) {
        ArrayList<String> lines = new ArrayList<String>();
        if (!text_file.exists()) {
            return null;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(text_file));
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines;
    }

    public static void writeTextFile(File text_file, ArrayList<String> lines, boolean append) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(text_file, append));
            int i = 0;
            while (i < lines.size()) {
                bw.write(String.valueOf(lines.get(i)) + "\n");
                ++i;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void zipFolder(File inFolder, File zipFile) {
        try {
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            BufferedInputStream in = null;
            byte[] data = new byte[1024];
            String[] files = inFolder.list();
            int i = 0;
            while (i < files.length) {
                int count;
                in = new BufferedInputStream(new FileInputStream(String.valueOf(inFolder.getPath()) + File.separatorChar + files[i]), 1024);
                out.putNextEntry(new ZipEntry(files[i]));
                while ((count = in.read(data, 0, 1024)) != -1) {
                    out.write(data, 0, count);
                }
                in.close();
                out.closeEntry();
                ++i;
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zipFolderRecursive(String parent_folder_path, String source_folder_path, ZipOutputStream zos) {
        try {
            if (parent_folder_path.charAt(parent_folder_path.length() - 1) != File.separatorChar) {
                parent_folder_path = String.valueOf(parent_folder_path) + File.separatorChar;
            }
            File zip_folder = new File(source_folder_path);
            String[] dir_list = zip_folder.list();
            byte[] readBuffer = new byte[1024];
            int bytesIn = 0;
            int i = 0;
            while (i < dir_list.length) {
                File f = new File(zip_folder, dir_list[i]);
                if (f.isDirectory()) {
                    String filePath = f.getPath();
                    FileUtils.zipFolderRecursive(parent_folder_path, filePath, zos);
                } else {
                    FileInputStream fis = new FileInputStream(f);
                    ZipEntry n_entry = new ZipEntry(f.getPath().substring(parent_folder_path.length()));
                    zos.putNextEntry(n_entry);
                    while ((bytesIn = fis.read(readBuffer)) != -1) {
                        zos.write(readBuffer, 0, bytesIn);
                    }
                    fis.close();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unzipFile(File zipFile, File outFolder) {
        try {
            byte[] buf = new byte[1024];
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            if (!outFolder.exists()) {
                FileUtils.recursiveMakeDirectory(outFolder);
            }
            ZipEntry zip_entry = zis.getNextEntry();
            while (zip_entry != null) {
                String zip_entry_name = zip_entry.getName();
                File new_file = new File(zip_entry_name);
                if (zip_entry.isDirectory()) {
                    File new_dir = new File(String.valueOf(outFolder.getAbsolutePath()) + File.separatorChar + zip_entry_name);
                    if (!new_dir.exists()) {
                        FileUtils.recursiveMakeDirectory(new_dir);
                    }
                } else {
                    int n;
                    File zip_entry_parent;
                    String zip_entry_parent_filename = new_file.getParent();
                    if (zip_entry_parent_filename != null && !(zip_entry_parent = new File(String.valueOf(outFolder.getAbsolutePath()) + File.separatorChar + zip_entry_parent_filename)).exists()) {
                        FileUtils.recursiveMakeDirectory(zip_entry_parent);
                    }
                    FileOutputStream fos = new FileOutputStream(String.valueOf(outFolder.getAbsolutePath()) + File.separatorChar + zip_entry_name);
                    while ((n = zis.read(buf, 0, 1024)) > -1) {
                        fos.write(buf, 0, n);
                    }
                    fos.close();
                }
                zis.closeEntry();
                zip_entry = zis.getNextEntry();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<String> getZipEntryNames(File zipFile) {
        ArrayList<String> zip_entry_names = new ArrayList<String>();
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry zip_entry = zis.getNextEntry();
            while (zip_entry != null) {
                zip_entry_names.add(zip_entry.getName());
                zis.closeEntry();
                zip_entry = zis.getNextEntry();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return zip_entry_names;
    }
}

