/*
 * Decompiled with CFR 0.152.
 */
package common.utils;

import common.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;

public class Table {
    private int num_cols = 0;
    private int cell_padding_horiz = 1;
    private int cell_padding_vert = 0;
    private int[] col_base_widths;
    private ArrayList<ArrayList<String>> rows = null;
    private String table = null;

    public Table(ArrayList<ArrayList<String>> rows, int cell_padding_horiz, int cell_padding_vert) {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        this.cell_padding_horiz = cell_padding_horiz;
        this.cell_padding_vert = cell_padding_vert;
        this.num_cols = 0;
        int i = 0;
        while (i < rows.size()) {
            int cur_num_cols = rows.get(i).size();
            if (cur_num_cols > this.num_cols) {
                this.num_cols = cur_num_cols;
            }
            ++i;
        }
        this.rows = new ArrayList();
        i = 0;
        while (i < rows.size()) {
            ArrayList<String> cur_row = rows.get(i);
            ArrayList<String> new_row = new ArrayList<String>();
            int j = 0;
            while (j < cur_row.size()) {
                new_row.add(cur_row.get(j));
                ++j;
            }
            this.rows.add(new_row);
            ++i;
        }
        this.col_base_widths = new int[this.num_cols];
        i = 0;
        while (i < this.col_base_widths.length) {
            this.col_base_widths[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.rows.size()) {
            ArrayList<String> cur_row = this.rows.get(i);
            int j = 0;
            while (j < cur_row.size()) {
                String cur_cell = cur_row.get(j);
                if (cur_cell.length() > this.col_base_widths[j]) {
                    this.col_base_widths[j] = cur_cell.length();
                }
                ++j;
            }
            ++i;
        }
        this.formTable();
    }

    public Table(ArrayList<ArrayList<String>> rows, String[] title_row, int cell_padding_horiz, int cell_padding_vert) {
        ArrayList<String> cur_row;
        if (rows == null || rows.isEmpty()) {
            return;
        }
        this.cell_padding_horiz = cell_padding_horiz;
        this.cell_padding_vert = cell_padding_vert;
        this.num_cols = 0;
        int i = 0;
        while (i < rows.size()) {
            int cur_num_cols = rows.get(i).size();
            if (cur_num_cols > this.num_cols) {
                this.num_cols = cur_num_cols;
            }
            ++i;
        }
        this.rows = new ArrayList();
        ArrayList<String> new_title_row = new ArrayList<String>();
        int i2 = 0;
        while (i2 < title_row.length) {
            new_title_row.add(title_row[i2]);
            ++i2;
        }
        this.rows.add(new_title_row);
        i2 = 0;
        while (i2 < rows.size()) {
            cur_row = rows.get(i2);
            ArrayList<String> new_row = new ArrayList<String>();
            int j = 0;
            while (j < cur_row.size()) {
                new_row.add(cur_row.get(j));
                ++j;
            }
            this.rows.add(new_row);
            ++i2;
        }
        this.col_base_widths = new int[this.num_cols];
        i2 = 0;
        while (i2 < this.col_base_widths.length) {
            this.col_base_widths[i2] = 0;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.rows.size()) {
            cur_row = this.rows.get(i2);
            int j = 0;
            while (j < cur_row.size()) {
                String cur_cell = cur_row.get(j);
                if (cur_cell.length() > this.col_base_widths[j]) {
                    this.col_base_widths[j] = cur_cell.length();
                }
                ++j;
            }
            ++i2;
        }
        this.formTable();
    }

    private void formTable() {
        this.table = "";
        int i = 0;
        while (i < this.rows.size()) {
            int full_row_width = 0;
            int j = 0;
            while (j < this.num_cols) {
                int cur_col_base_width = this.col_base_widths[j];
                int cur_col_full_width = cur_col_base_width + this.cell_padding_horiz * 2 + 2;
                if (j != 0) {
                    --cur_col_full_width;
                }
                full_row_width += cur_col_full_width;
                ++j;
            }
            String border_row = "";
            int j2 = 0;
            while (j2 < full_row_width) {
                border_row = String.valueOf(border_row) + "-";
                ++j2;
            }
            border_row = String.valueOf(border_row) + "\n";
            if (i == 0) {
                this.table = String.valueOf(this.table) + border_row;
            }
            String pad_row = "";
            pad_row = String.valueOf(pad_row) + "|";
            int j3 = 0;
            while (j3 < full_row_width - 2) {
                pad_row = String.valueOf(pad_row) + " ";
                ++j3;
            }
            pad_row = String.valueOf(pad_row) + "|\n";
            j3 = 0;
            while (j3 < this.cell_padding_vert) {
                this.table = String.valueOf(this.table) + pad_row;
                ++j3;
            }
            ArrayList<String> cur_row = this.rows.get(i);
            int j4 = 0;
            while (j4 < cur_row.size()) {
                String cur_element = cur_row.get(j4);
                int col_base_width = this.col_base_widths[j4];
                String cur_cell = "";
                if (j4 == 0) {
                    cur_cell = String.valueOf(cur_cell) + "|";
                }
                int k = 0;
                while (k < this.cell_padding_horiz) {
                    cur_cell = String.valueOf(cur_cell) + " ";
                    ++k;
                }
                k = 0;
                while (k < col_base_width - cur_element.length()) {
                    cur_cell = String.valueOf(cur_cell) + " ";
                    ++k;
                }
                cur_cell = String.valueOf(cur_cell) + cur_element;
                k = 0;
                while (k < this.cell_padding_horiz) {
                    cur_cell = String.valueOf(cur_cell) + " ";
                    ++k;
                }
                cur_cell = String.valueOf(cur_cell) + "|";
                this.table = String.valueOf(this.table) + cur_cell;
                ++j4;
            }
            this.table = String.valueOf(this.table) + "\n";
            j4 = 0;
            while (j4 < this.cell_padding_vert) {
                this.table = String.valueOf(this.table) + pad_row;
                ++j4;
            }
            this.table = String.valueOf(this.table) + border_row;
            ++i;
        }
    }

    public void printTableToFile(File fh) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] table_split = this.table.split("\n");
        int i = 0;
        while (i < table_split.length) {
            lines.add(table_split[i]);
            ++i;
        }
        FileUtils.writeTextFile(fh, lines, false);
    }

    public String toString() {
        return this.table;
    }
}

