/*
 * Decompiled with CFR 0.152.
 */
package common.utils;

import java.io.File;
import java.util.ArrayList;

public class ExtFilter {
    public static final String TYPE_VIDEO = "video";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_ZIP = "zip";
    public static final String TYPE_RAR = "rar";
    public static final String TYPE_ARCHIVE = "archive";
    public static final String TYPE_PDF = "pdf";
    public static final String TYPE_EBOOK = "ebook";
    public static final String TYPE_EXE = "exe";
    private static String[] video_filter_ext = new String[]{".3g2", ".3gp", ".3gp2", ".3gpp", ".3mm", ".amv", ".as", ".asx", ".avb", ".avi", ".avs", ".bin", ".bsf", ".dat", ".divx", ".dv", ".dvx", ".flv", ".hkm", ".m1pg", ".m1v", ".m21 ", ".m21", ".m2", ".m2t ", ".m2ts", ".m2v", ".m4e", ".m4u", ".m4v ", ".mgv ", ".mj2", ".mjp", ".mjpg", ".mkv", ".mov", ".movie", ".mp21", ".mp21", ".mp2v", ".mp4 ", ".mp4v", ".mpe", ".mpeg", ".mp", ".mpg2", ".mpv2", ".mqv", ".mts", ".ogm", ".ogv", ".pmf", ".qt", ".rec", ".rm", ".rmvb", ".rts", ".rv", ".swf", ".tivo", ".vc1", ".vid", ".wmv", ".xvid"};
    private static String[] image_filter_ext = new String[]{".ai", ".bmp", ".dxf", ".emf", ".emz", ".eps", ".exif", ".fig", ".fxg", ".gif", ".icon", ".j", ".j2c", ".j2k", ".jng ", ".jp2", ".jpc", ".jpe", ".jpeg", ".jpf", ".jpg", ".jpw", ".jpx", ".jtf", ".pbm", ".pct", ".pcx", ".pgm", ".pic", ".png", ".pnt", ".ppm", ".ps", ".psb", ".psd", ".qif", ".qti", ".qtif", ".raw", ".rgb", ".rif", ".thm", ".thumb", ".tif", ".tiff"};
    private static String[] zip_filter_ext = new String[]{".zip", ".cbz"};
    private static String[] rar_filter_ext = new String[]{".rar", ".cbr"};
    private static String[] pdf_filter_ext = new String[]{".pdf"};
    private static String[] ebook_filter_ext = new String[]{".epub"};
    private static String[] exe_filter_ext = new String[]{".exe"};
    private ArrayList<String> filter = new ArrayList();

    public ExtFilter(String type) {
        if (type.equals(TYPE_VIDEO)) {
            int i = 0;
            while (i < video_filter_ext.length) {
                this.filter.add(video_filter_ext[i]);
                ++i;
            }
        } else if (type.equals(TYPE_IMAGE)) {
            int i = 0;
            while (i < image_filter_ext.length) {
                this.filter.add(image_filter_ext[i]);
                ++i;
            }
        } else if (type.equals(TYPE_ZIP)) {
            int i = 0;
            while (i < zip_filter_ext.length) {
                this.filter.add(zip_filter_ext[i]);
                ++i;
            }
        } else if (type.equals(TYPE_RAR)) {
            int i = 0;
            while (i < rar_filter_ext.length) {
                this.filter.add(rar_filter_ext[i]);
                ++i;
            }
        } else if (type.equals(TYPE_ARCHIVE)) {
            int i = 0;
            while (i < zip_filter_ext.length) {
                this.filter.add(zip_filter_ext[i]);
                ++i;
            }
            i = 0;
            while (i < rar_filter_ext.length) {
                this.filter.add(rar_filter_ext[i]);
                ++i;
            }
        } else if (type.equals(TYPE_PDF)) {
            int i = 0;
            while (i < pdf_filter_ext.length) {
                this.filter.add(pdf_filter_ext[i]);
                ++i;
            }
        } else if (type.equals(TYPE_EBOOK)) {
            int i = 0;
            while (i < ebook_filter_ext.length) {
                this.filter.add(ebook_filter_ext[i]);
                ++i;
            }
        } else if (type.equals(TYPE_EXE)) {
            int i = 0;
            while (i < exe_filter_ext.length) {
                this.filter.add(exe_filter_ext[i]);
                ++i;
            }
        } else {
            this.filter = null;
        }
    }

    public ExtFilter(ArrayList<String> extensions) {
        int i = 0;
        while (i < extensions.size()) {
            this.filter.add(extensions.get(i));
            ++i;
        }
    }

    public boolean isValid(String extension) {
        if (extension == null) {
            return false;
        }
        return this.filter.contains(extension.toLowerCase());
    }

    public boolean isValid(File fh) {
        if (fh.isDirectory()) {
            return false;
        }
        String fh_ext = ExtFilter.getExtension(fh);
        return this.isValid(fh_ext);
    }

    public ArrayList<File> getFilesOfTypeFromList(ArrayList<File> file_list) {
        if (file_list == null || file_list.isEmpty()) {
            return new ArrayList<File>();
        }
        ArrayList<File> type_file_list = new ArrayList<File>();
        int i = 0;
        while (i < file_list.size()) {
            File cur_file = file_list.get(i);
            if (this.isValid(cur_file)) {
                type_file_list.add(cur_file);
            }
            ++i;
        }
        return type_file_list;
    }

    public static String getExtension(File fh) {
        String fh_name = fh.getName();
        int last_period_index = fh_name.lastIndexOf(46);
        if (last_period_index == -1 || last_period_index == fh_name.length() - 1) {
            return null;
        }
        return fh_name.substring(last_period_index);
    }

    public static String getNameWithoutExtension(File fh) {
        String fh_name = fh.getName();
        String extension = ExtFilter.getExtension(fh);
        if (extension == null || extension.isEmpty()) {
            return fh_name;
        }
        return fh_name.substring(0, fh_name.length() - extension.length());
    }
}

