/*
 * Decompiled with CFR 0.152.
 */
package common.image;

import common.image.ImageData;
import common.image.PixelDataGroup;
import common.utils.FileUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static int isTwoPages(File image_file, int start_x, boolean try_harder, boolean allow_auto_split_color_scans, double grayscale_strictness, double color_strictness) {
        boolean is_two_pages;
        int try_harder_x_offset;
        int num_times_try_harder;
        ArrayList<PixelDataGroup> all_pdgs;
        boolean is_grayscale;
        int group_width;
        int num_binary_pattern_matches;
        block21: {
            int height;
            int width;
            BufferedImage image;
            int group_height;
            int num_desired_pdgs;
            block20: {
                num_binary_pattern_matches = 0;
                num_desired_pdgs = 20;
                group_width = 10;
                group_height = 20;
                is_grayscale = true;
                all_pdgs = null;
                num_times_try_harder = 5;
                try_harder_x_offset = 5;
                is_two_pages = false;
                image = ImageIO.read(image_file);
                width = image.getWidth();
                height = image.getHeight();
                if (height <= width) break block20;
                return -1;
            }
            if (start_x < 0) {
                start_x = (int)(0.5 * (double)width) - group_width / 2;
            }
            int[] start_ys = new int[num_desired_pdgs];
            int i = 0;
            while (i < num_desired_pdgs) {
                start_ys[i] = height * (i + 1) / num_desired_pdgs - group_height / 2;
                ++i;
            }
            all_pdgs = new ArrayList<PixelDataGroup>();
            i = 0;
            while (i < num_desired_pdgs) {
                PixelDataGroup new_group = new PixelDataGroup(image, start_x, start_ys[i], group_width, group_height);
                if (!new_group.isNull()) {
                    all_pdgs.add(new_group);
                }
                ++i;
            }
            i = 0;
            while (is_grayscale && i < all_pdgs.size()) {
                PixelDataGroup cur_pdg = (PixelDataGroup)all_pdgs.get(i);
                if (!cur_pdg.isPDGGrayscale()) {
                    is_grayscale = false;
                }
                ++i;
            }
            if (is_grayscale && !ImageUtils.isImageGrayscale(image)) {
                is_grayscale = false;
            }
            boolean is_half_grayscale_half_color = false;
            if (!is_grayscale) {
                is_half_grayscale_half_color = ImageUtils.isImageHalfGrayscaleHalfColor(image);
            }
            if (is_grayscale || is_half_grayscale_half_color || allow_auto_split_color_scans) break block21;
            return -1;
        }
        try {
            int i = 0;
            while (i < all_pdgs.size()) {
                if (((PixelDataGroup)all_pdgs.get(i)).isPDGRowsMatchingBinaryPattern()) {
                    ++num_binary_pattern_matches;
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double percentage_match = is_grayscale ? grayscale_strictness : color_strictness;
        if (all_pdgs != null && num_binary_pattern_matches >= (int)(percentage_match * (double)all_pdgs.size())) {
            is_two_pages = true;
        }
        if (is_two_pages) {
            return start_x + group_width / 2;
        }
        if (try_harder) {
            int i = 0;
            while (i < num_times_try_harder) {
                if (ImageUtils.isTwoPages(image_file, start_x - try_harder_x_offset * (i + 1), false, allow_auto_split_color_scans, grayscale_strictness, color_strictness) > 0) {
                    return start_x - try_harder_x_offset * (i + 1) + group_width / 2;
                }
                if (ImageUtils.isTwoPages(image_file, start_x + try_harder_x_offset * (i + 1), false, allow_auto_split_color_scans, grayscale_strictness, color_strictness) > 0) {
                    return start_x + try_harder_x_offset * (i + 1) + group_width / 2;
                }
                ++i;
            }
        }
        return -1;
    }

    public static ImageData getImageData(File image_file) {
        ImageData id = null;
        try {
            BufferedImage image = ImageIO.read(image_file);
            id = new ImageData(image.getWidth(), image.getHeight(), -1.0);
        }
        catch (Exception e) {
            return null;
        }
        return id;
    }

    public static ArrayList<ImageData> getImageDataOfFolder(File folder) {
        ArrayList<ImageData> ids = new ArrayList<ImageData>();
        ArrayList<File> image_file_list = FileUtils.getImageFileList(folder);
        int i = 0;
        while (i < image_file_list.size()) {
            File image_file = image_file_list.get(i);
            ids.add(ImageUtils.getImageData(image_file));
            ++i;
        }
        return ids;
    }

    public static ArrayList<ImageData> getImageDataOfImageFiles(ArrayList<File> image_files) {
        ArrayList<ImageData> ids = new ArrayList<ImageData>();
        int i = 0;
        while (i < image_files.size()) {
            File image_file = image_files.get(i);
            ids.add(ImageUtils.getImageData(image_file));
            ++i;
        }
        return ids;
    }

    public static Color getRGBColorFromInt(int rgb) {
        int red = (rgb & 0xFF0000) >> 16;
        int green = (rgb & 0xFF00) >> 8;
        int blue = rgb & 0xFF;
        return new Color(red, green, blue);
    }

    public static int getGrayLevelFromRGB(Color color) {
        return (11 * color.getRed() + 16 * color.getGreen() + 5 * color.getBlue()) / 32;
    }

    public static int getBinaryLevelFromGrayLevel(int gray_level) {
        if (gray_level > 128) {
            return 1;
        }
        return 0;
    }

    public static boolean isImageGrayscale(BufferedImage image) {
        boolean is_grayscale = true;
        int width = image.getWidth();
        int height = image.getHeight();
        int group_width = 6;
        int group_height = 6;
        int num_row_samples = 5;
        int num_col_samples = 5;
        int row = 1;
        while (is_grayscale && row <= num_row_samples) {
            int col = 1;
            while (is_grayscale && col <= num_col_samples) {
                int start_x = row * (width / num_row_samples) - group_width / 2;
                int start_y = col * (height / num_row_samples) - group_height / 2;
                PixelDataGroup pdg = new PixelDataGroup(image, start_x, start_y, group_width, group_height);
                if (!pdg.isPDGGrayscale()) {
                    is_grayscale = false;
                }
                ++col;
            }
            ++row;
        }
        return is_grayscale;
    }

    public static boolean isImageHalfGrayscaleHalfColor(BufferedImage image) {
        PixelDataGroup pdg;
        int start_y;
        int start_x;
        int col;
        boolean is_left_half_grayscale = true;
        boolean is_right_half_grayscale = true;
        int width = image.getWidth();
        int half_width = width / 2;
        int height = image.getHeight();
        int group_width = 6;
        int group_height = 6;
        int num_row_samples = 5;
        int num_col_samples = 5;
        int row = 1;
        while (is_left_half_grayscale && row <= num_row_samples) {
            col = 1;
            while (is_left_half_grayscale && col <= num_col_samples) {
                start_x = row * (half_width / num_row_samples) - group_width / 2;
                start_y = col * (height / num_row_samples) - group_height / 2;
                pdg = new PixelDataGroup(image, start_x, start_y, group_width, group_height);
                if (!pdg.isPDGGrayscale()) {
                    is_left_half_grayscale = false;
                }
                ++col;
            }
            ++row;
        }
        row = 1;
        while (is_right_half_grayscale && row <= num_row_samples) {
            col = 1;
            while (is_right_half_grayscale && col <= num_col_samples) {
                start_x = row * (half_width / num_row_samples) + half_width - group_width / 2;
                start_y = col * (height / num_row_samples) - group_height / 2;
                pdg = new PixelDataGroup(image, start_x, start_y, group_width, group_height);
                if (!pdg.isPDGGrayscale()) {
                    is_right_half_grayscale = false;
                }
                ++col;
            }
            ++row;
        }
        return is_left_half_grayscale ^ is_right_half_grayscale;
    }

    public static boolean isRGBColorGrayscale(Color color) {
        return color.getRed() == color.getGreen() && color.getRed() == color.getBlue();
    }
}

