/*
 * File Name: text_tasks.h
 */

/*
 * This file is part of uds-plugin-plaintext.
 *
 * uds-plugin-plaintext is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-plaintext is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef FB2_TASKS_H
#define FB2_TASKS_H

#include "thread.h"
#include "signal_slot.h"
#include "fb2_base_types.h"

using namespace std;
using namespace common;

namespace fb2
{

class FB2View;
class FB2Model;

/// @brief This is the first task for text plugin. It is executed by worker
///  thread once text view is initialized.
class InitializationTask : public common::Task
{
public:
    /// @brief Constructors and destructors
    InitializationTask(FB2View *view);
    virtual ~InitializationTask();

public:
    virtual void execute();

private:
    FB2View *view;
};

/// @brief This is the last task for text plugin. It is executed by worker
///  thread once text view is deinitialized.
class DeinitializationTask : public common::Task
{
public:
    /// @brief Constructors and destructors
    DeinitializationTask(FB2View *view);
    virtual ~DeinitializationTask();

public:
    virtual void execute();

private:
    FB2View *view;
};

/// @brief Pagination task definition for text plugin. The pagination task is
///  responsible for calculating start position and end position for a
///  specified page, and calculating total pages.
class PaginationTask : public common::Task
{
public:
    /// @brief Constructors and destructors
    PaginationTask(FB2View *view, const Position& _start, bool _is_child);
    virtual ~PaginationTask();

public:
    /// @brief Abort signal.
    utils::Signal<const Position&> abort_signal;

public:
    virtual void execute();

private:
    FB2View *view;
    Position start_pos;
    bool     is_child;
};


/// @brief Pagination abort tasks
///
/// A dummy task to abort the current pagination
///
class PaginationAbortTask : public common::Task
{
public:
    /// @brief Constructors and destructors
    PaginationAbortTask(FB2View *view);
    virtual ~PaginationAbortTask();

public:
    virtual void execute();

private:
    FB2View      *view;
};

/// @brief Render task definition for text plugin. The render task is
///  responsible for rendering a specified page.
class RenderTask : public common::Task
{
public:
    /// @brief Constructors and destructors
    RenderTask(unsigned int     _id,
               FB2View        *_view,
               const Position&  _pos,
               void            *_user_data,
               unsigned char   *_bmp);
    virtual ~RenderTask();

public:
    virtual void execute();

private:
    unsigned int  id;
    FB2View      *view;
    Position      start_pos;
    void          *user_data;
    unsigned char *bmp;
};

/// @brief Search task definition for text plugin. The search task is
///  responsible for find the previous/next/all occurrence of specified
///  pattern.
class SearchTask : public common::Task
{
public:
    /// @brief Constructors and destructors
    SearchTask(FB2Model *_model, SearchContext* _sc);
    virtual ~SearchTask();

public:
    utils::Signal<SearchContext*> abort_signal;

public:
    virtual void execute();

private:
    FB2Model     *model;
    SearchContext *sc;
};

}; // namespace text

#endif // TEXT_TASKS_H

