/*
 * File Name: model_test.cpp
 */

/*
 * This file is part of uds-plugin-plaintext.
 *
 * uds-plugin-plaintext is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-plaintext is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include <stdio.h>
#include <assert.h>
#include <string>
#include <plugin_inc.h>
#include <glib.h>
#include <dlfcn.h>

// string impl
class StringImpl : public _UDSString
{
public:
    StringImpl();
    explicit StringImpl(const char *str);
    explicit StringImpl(const std::string& str);
    explicit StringImpl(const StringImpl &src);
    ~StringImpl();

public:
    StringImpl& operator = (const StringImpl &right);
    bool operator == (const StringImpl &right);
    std::string& stl_string() { return impl; }

private:
    /// Implement all interfaces defined by UDSString
    static _UDSString * assign_impl(
        _UDSString * thiz,
        const char * src);

    /// Implement the get_buffer.
    static const char* get_buffer_impl(
        const _UDSString *thiz);

    /// Size in bytes.
    static unsigned int size_impl(
        const _UDSString   *thiz);

private:
    /// Helper functions
    static StringImpl * down_cast(_UDSString * ptr);
    static const StringImpl * down_cast(const _UDSString * ptr);

private:
    std::string impl;
};

StringImpl::StringImpl()
{
    assign = assign_impl;
    get_buffer = get_buffer_impl;
    size = size_impl;
}

StringImpl::StringImpl(const char *str)
: impl(str)
{
    assign = assign_impl;
    get_buffer = get_buffer_impl;
    size = size_impl;
}

StringImpl::StringImpl(const std::string& str)
: impl(str)
{
    assign = assign_impl;
    get_buffer = get_buffer_impl;
    size = size_impl;
}

StringImpl::StringImpl(const StringImpl &src)
: impl(src.impl)
{
    assign = assign_impl;
    get_buffer = get_buffer_impl;
    size = size_impl;
}

StringImpl::~StringImpl()
{
}

StringImpl& StringImpl::operator = (const StringImpl &right)
{
    if (this != &right)
    {
        impl = right.impl;
    }
    return *this;
}

bool StringImpl::operator == (const StringImpl &right)
{
    return (impl == right.impl);
}

StringImpl * StringImpl::down_cast(_UDSString * ptr)
{
    return static_cast<StringImpl *>(ptr);
}

const StringImpl * StringImpl::down_cast(const _UDSString * ptr)
{
    return static_cast<const StringImpl *>(ptr);
}

_UDSString * StringImpl::assign_impl(_UDSString * thiz,
                                     const char * src)
{
    assert(thiz);
    StringImpl * object = down_cast(thiz);
    object->impl = src;
    return thiz;
}

const char* StringImpl::get_buffer_impl(const _UDSString *thiz)
{
    assert(thiz);
    const StringImpl * object = down_cast(thiz);
    return object->impl.c_str();
}

unsigned int StringImpl::size_impl(const _UDSString   *thiz)
{
    assert(thiz);
    const StringImpl * object = down_cast(thiz);
    return static_cast<unsigned int>(object->impl.size());
}
////////////////////////////////////////////////////////////////////////////////
typedef IPluginUnknown* (*Create_plugin_library)();

int main(int argc, char* argv[])
{
    if (argc != 2)
    {
        fprintf(stderr, "Usage: %s <file_path>.\n", argv[0]);
        return -1;
    }

	g_thread_init(NULL);

	void* handle = dlopen("libuds-plugin-fb2.so",RTLD_LAZY|RTLD_GLOBAL);
	if(handle){
		Create_plugin_library cpl = (Create_plugin_library)dlsym(handle,"create_plugin_library");
		IPluginUnknown* libThiz = 0;
		if(cpl)
			libThiz = (cpl)();

		if(libThiz){
			StringImpl id("IPluginLibrary");
			IPluginLibrary* library;
			if(libThiz->query_interface(libThiz,&id, (void**)&library)==PLUGIN_OK){
				IPluginUnknown* docThiz = library->create_document(libThiz);
				if(docThiz){
					StringImpl id("IPluginDocument");
					IPluginDocument* doc;
					if(docThiz->query_interface(docThiz,&id, (void**)&doc)==PLUGIN_OK){
						IPluginUnknown* viewThiz = doc->create_view(docThiz);
						if(viewThiz){
							StringImpl path(argv[1]);
							if(doc->open(docThiz,&path)==PLUGIN_OK){
								if(doc->is_open(docThiz)==PLUGIN_TRUE){
									doc->close(docThiz);
								}
							}
							viewThiz->release(viewThiz);
						}
					}
					docThiz->release(docThiz);
				}
			}
			libThiz->release(libThiz);
		}
		dlclose(handle);
	}
    getchar();
    return 0;
}

