/*
 * File Name: render_settings_impl.h
 */

/*
 * This file is part of uds-plugin-plaintext.
 *
 * uds-plugin-plaintext is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-plaintext is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef TEXT_PLUGIN_RENDER_SETTINGS_IMPL_H_
#define TEXT_PLUGIN_RENDER_SETTINGS_IMPL_H_

#include <vector>
#include "plugin_inc.h"
#include "signal_slot.h"
#include "interfaces_utils.h"

using namespace utils;

namespace fb2
{

class PluginRenderSettingsImpl : public IPluginUnknown
                               , public IPluginClone
                               , public IPluginRenderSettings
                               // , public IPluginZoom
                               // , public IPluginRotation
{
public:
    PluginRenderSettingsImpl(void);
    PluginRenderSettingsImpl(const PluginRenderSettingsImpl &ref);
    ~PluginRenderSettingsImpl(void);

    static PluginRenderSettingsImpl * query_instance(IPluginUnknown * thiz);

public:
    Signal<PluginRenderSettingsImpl *> release_signal;

private:
    // IPluginUnknown
    static PluginStatus query_interface_impl(
        IPluginUnknown    *thiz,
        const UDSString   *id,
        void              **ptr);

    static int release_impl(
        IPluginUnknown  *thiz);

    // IPluginClone
    static IPluginUnknown* create_clone_object_impl(
        IPluginUnknown *thiz);

    // IPluginZoom. No such interface.

    // IPluginRotation. No such interface.

private:
    static utils::ObjectTable<PluginRenderSettingsImpl> g_instances_table;
};

};  // namespace text

#endif

