/*
 * File Name: text_config.h
 */

/*
 * This file is part of uds-plugin-plaintext.
 *
 * uds-plugin-plaintext is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-plaintext is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef FB2_CONFIG_H
#define FB2_CONFIG_H

#include "plugin_config.h"

#define DEFAULT_LANGUAGE        "en"
#define DEFAULT_ASCII_FONT      "vera"
#define DEFAULT_CHINESE_FONT    "simsun"
#define DEFAULT_EMPTY_HEIGHT    0
#define DEFAULT_LINE_SPACING    3
#define DEFAULT_PARA_SPACING    9
#define DEFAULT_DPI             96
#define MAX_FONT_SIZE           30
#define MIN_FONT_SIZE           8
#define DEFAULT_FONT_SPAN       1
#define DEFAULT_FONT_SIZE       PLUGIN_FONT_SIZE_DEFAULT 
#define DEFAULT_LEFT_MARGIN     0
#define DEFAULT_RIGHT_MARGIN    0
#define DEFAULT_TOP_MARGIN      0
#define DEFAULT_BOTTOM_MARGIN   0
#define DEFAULT_BK_COLOR        0xFF
#define DEFAULT_FREE_MEMORY     1024 * 1024 * 8
#define DEFAULT_SAFE_MEMORY     1024 * 1024 * 10
#define DEFAULT_ROTATE          0
#define DEFAULT_COLOR_DEPTH     8

#define DEFAULT_SURFACE_WIDTH   1024
#define DEFAULT_SURFACE_HEIGHT  1280

#endif // FB2_CONFIG_H

