/*
 * File Name: search_test.cpp
 */

/*
 * This file is part of uds-plugin-plaintext.
 *
 * uds-plugin-plaintext is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-plaintext is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include <stdio.h>
#include <string.h>
/*#include "fb2_model.h"*/

//using namespace fb2;

int main(int argc, char* argv[])
{
    if (argc != 2)
    {
        fprintf(stderr, "Usage: %s <file_name>.\n", argv[0]);
        return -1;
    }
#if 1
	IPluginUnknown* plugin = create_plugin_library();

	plugin->
#else	
    FB2Model model;
    model.open(argv[1]);

    // Set search criteria.
    const char* search_text = "Х";
    Position from(16, 0);
    bool case_sensitive = false;
    bool forward = false;
    bool match_whole_word = false;

    // Convert the search text to UTF-8 encoded string.
    const char* in_p = search_text;
	size_t in_bytes_left = strlen(search_text);
    char out_buf[1024];
    char *out_p = out_buf;
    size_t out_bytes_left = sizeof(out_buf);

	iconv_t conv = iconv_open("UTF-8", "GB2312");
    iconv(conv, &in_p, &in_bytes_left, &out_p, &out_bytes_left);
    iconv_close(conv);
    *out_p = 0;

    // Test search all function
    /*
    std::vector<Range> result_ranges;
    model.search_all(result_ranges, out_buf, case_sensitive, match_whole_word);
    for (unsigned int i=0; i<result_ranges.size(); i++)
    {
        printf("Match %d: (%d, %d) ~ (%d, %d)\n",
            i+1, 
            result_ranges[i].start.paragraph,
            result_ranges[i].start.offset,
            result_ranges[i].end.paragraph,
            result_ranges[i].end.offset);
    }*/

    // Test search next function.
    Range result;
    bool ret = model.search(result, from, out_buf, case_sensitive, forward, match_whole_word);
    if (ret == false)
    {
        printf("No match.\n");
    }
    else
    {
        printf("Pattern found: (%d, %d) ~ (%d, %d)\n",
            result.start.paragraph,
            result.start.offset,
            result.end.paragraph,
            result.end.offset);
    }
#endif
    getchar();
    return 0;
}

