/*
 * File Name: encoding_test.cpp
 */

/*
 * This file is part of uds-plugin-plaintext.
 *
 * uds-plugin-plaintext is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-plaintext is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include <stdio.h>

#include <string>
#include <cassert>

#include "tut.h"
#include "tut_reporter.h"
#include "encoding.h"

#define BUFSIZE 1024

namespace tut
{
    using namespace text;
    struct empty
    { 
    };

    typedef test_group<empty> tf;
    typedef tf::object object;
    tf interface_ptr_group("encoding test");

    // Test 1: Test GB2312
    template<>
    template<>
    void object::test<1>()
    {
        std::string file_path = "GB2312";
        FILE* fp = fopen(file_path.c_str(), "r");
        
        if (fp)
        {
            char buf[BUFSIZE];
            size_t bytes_read = fread(buf, 1, BUFSIZE, fp);
            fclose(fp);

            // Get encodings
            std::string enc = Encoding::get_enc("zh", (unsigned char *)buf, bytes_read);
            ensure(enc == file_path);
        }
        else
        {
            ensure(false);
        }
    }

    // Test 2: Test utf-8
    template<>
    template<>
    void object::test<2>()
    {
        std::string file_path = "UTF-8";
        FILE* fp = fopen(file_path.c_str(), "r");
        
        if (fp)
        {
            char buf[BUFSIZE];
            size_t bytes_read = fread(buf, 1, BUFSIZE, fp);
            fclose(fp);

            // Get encodings
            std::string enc = Encoding::get_enc("zh", (unsigned char *)buf, bytes_read);
            ensure(enc == file_path);
        }
        else
        {
            ensure(false);
        }
    }
}

using std::exception;
using std::cerr;
using std::endl;

namespace tut
{
    test_runner_singleton runner;
}

int main()
{
    tut::reporter reporter;
    tut::runner.get().set_callback(&reporter);

    try
    {
        tut::runner.get().run_tests();
    }
    catch (const std::exception& ex)
    {
        cerr << "tut raised ex: " << ex.what() << endl;
        return 1;
    }

    return 0;
}


