/*
 * File Name: text_base_types.cpp
 */

/*
 * This file is part of uds-plugin-plaintext.
 *
 * uds-plugin-plaintext is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-plaintext is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include "log.h"
#include "fb2_base_types.h"

namespace fb2
{

Position::Position(unsigned int paragraph_index, unsigned int offset)
: paragraph(paragraph_index),
  offset(offset)
{
}

Position::Position(const std::string& from_string)
{
    if (from_string == "")
    {
        paragraph = offset = 0;
    }
    else
    {
        if (2 != sscanf(from_string.c_str(), "fb2://%d:%d", &paragraph, &offset))
        {
            // Invalid anchor.
            ERRORPRINTF("Invalid text anchor detected!");
            paragraph = offset = 0;
        }
    }
}

Position::~Position()
{
}

std::string Position::to_string() const
{
    char buf[32];
    g_snprintf(buf, 32, "fb2://%d:%d", paragraph, offset);
    return std::string(buf);
}

}


