/*
 * File Name: text_controller.h
 */

/*
 * This file is part of uds-plugin-plaintext.
 *
 * uds-plugin-plaintext is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-plaintext is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef FB2_CONTROLLER_H
#define FB2_CONTROLLER_H

#include "fb2_tasks.h"
#include "fb2_model.h"
#include "thread.h"

namespace fb2
{

class FB2Model;
class FB2View;

class FB2Controller
{
public:
    /// @brief Constructors and destructors.
    FB2Controller(FB2Model *_model);
	~FB2Controller();

	void set_view(FB2View *_view);
public:
    /// @brief Start working thread.
    void start();

    /// @brief Stop working thread.
    void stop();

    /// @brief Render specified page.
    void render(unsigned int id, unsigned int page_index, void *data, unsigned char* bmp);

    /// @brief Render a page start with start_pos.
    void render(unsigned int id, const Position& start_pos, void *data, unsigned char* bmp);

    /// @brief Paginate.
    void paginate(const Position& start, bool send_start_notification);

    /// @brief Search specified pattern in text model.
    /// @param search_context Search type and search criteria.
    void search(SearchContext* sc);

    /// @brief Pause pagination
    ///
    /// Called when document window is deactivated
    ///
    void pause_pagination();

    /// @brief Restart pagination again after it was paused
    ///
    /// Called when document windows is activated again
    ///
    void restart_pagination();

private:
    void on_pagination_aborted(const Position& start);
    void on_pagination_finished(unsigned int, unsigned int);
    void on_search_aborted(SearchContext* sc);

private:
    /// @brief Text model.
    FB2Model *model;

    /// @brief Text view.
    FB2View *view;

    /// @brief Worker thread
    common::Thread thread;

    /// @brief Flag to indicate if pagination is busy
    ///
    /// Note, this flag will stay busy even if pagination is paused
    ///
    bool pagination_pending;

    /// @brief Flag to indicate if pagination was paused
    bool pagination_paused;


};

}; // namespace text

#endif // FB2_CONTROLLER_H


