/*
 * Actually DjVu-doc, tries to mimic the behaviour of the poppler PDFDoc class
 * and other poppler classes
 */

#ifndef PDF_DOC_H_
#define PDF_DOC_H_

#include <goo/GooString.h>
#include <goo/GooList.h>

#include <libdjvu/ddjvuapi.h>
#include <libdjvu/miniexp.h>

#include "log.h"
#include "mutex.h"



class GlobalParams {
public:
	GlobalParams();
	~GlobalParams();
	ddjvu_context_t* getContext() { return ctx; }
	pdf::Mutex* getMutex() { return mtx; }
private:
	ddjvu_context_t *ctx;
	pdf::Mutex* mtx;
};
extern GlobalParams *globalParams;

class XRef {
	
};

class TextWord {
public:
	int getLength() { return 0; }
	GooString *getText() { return &text; }
	void getBBox(double* xMinA, double* yMinA, double* xMaxA, double* yMaxA) { 
		WARNPRINTF("TextWord::getBBox not implemented");
		*xMinA = 0.0; *yMinA=0.0; *xMaxA = 0.0; *yMaxA = 0.0;
	}
	void getCharBBox(int charIdx, double* xMinA, double* yMinA, double* xMaxA, double* yMaxA) {
		WARNPRINTF("TextWord::getCharBBox not implemented");
		*xMinA = 0.0; *yMinA=0.0; *xMaxA = 0.0; *yMaxA = 0.0;
	}
private:
	GooString text;	
};

class TextWordList {
public:
	int getLength() { return 0; }
	TextWord* get(int idx) { return 0; }
};

class PDFRectangle {
public:
	double x1,y1,x2,y2;
	PDFRectangle() { x1 = y1 = x2 = y2 = 0; }
	PDFRectangle(double x1a, double y1a, double x2a, double y2a) { x1 = x1a; y1 = y1a; x2 = x2a; y2 = y2a; }
	GBool isValid() { return x1 != 0 || y1 != 0 || x2 != 0 || y2 != 0; }
};

class Ref {
public:
	int num;
	int gen;
};

class Outline {
public:
	GooList *getItems() { return items; }
	void open() { }
	void close() { }
	GooList *getKids() { /* return kids; */ return 0; }
private:
	GooList *items;
	GooList *kids; // NULL indien geen kids?
};

typedef unsigned int Unicode;

enum LinkActionKind { actionGoTo };

class LinkAction {
public:
	LinkActionKind getKind() { return actionGoTo; }
};

class OutlineItem {
public:
	OutlineItem() { WARNPRINTF("Constructing OutlineItem"); unic = 0; }
	~OutlineItem() { WARNPRINTF("Destructing OutlineItem"); }
	LinkAction* getAction() { WARNPRINTF("OutlineItem::getAction"); return &action; }
	Unicode* getTitle() { WARNPRINTF("OutlineItem::getTitle"); return &unic; }
	int getTitleLength() { WARNPRINTF("OutlineItem::getTitleLength"); return 0; }
	void open() { WARNPRINTF("OutlineItem::open"); }
	void close() { WARNPRINTF("OutlineItem::close"); }
	GooList *getKids() { WARNPRINTF("OutlineItem::getKids"); return 0; }
private:
	Unicode unic;
	LinkAction action;
};



class LinkDest {
public:
	GBool isPageRef() { WARNPRINTF("LinkDest::isPageRef"); return gFalse; }
	Ref getPageRef() { WARNPRINTF("LinkDest::getPageRef"); ref.gen = 0; ref.num = 0; return ref; }
private:
	Ref ref;
};

class LinkGoTo : public LinkAction {
public:
	LinkDest* getDest() { WARNPRINTF("LinkGoTo::getDest"); return 0; } // fixme need to return non-null?
	GooString* getNamedDest() { WARNPRINTF("LinkGoTo::getNamedDest"); return 0; }
};

class Link {
public:
	void getRect(double *xa1, double *ya1, double *xa2, double *ya2) { WARNPRINTF("Link::getRect"); }
	GBool inRect(double x, double y) { WARNPRINTF("Link::inRect"); return false; }
	LinkAction* getAction() { WARNPRINTF("Link::getAction"); return &action; }
private:
	LinkGoTo action;
};


class Links {
public:
	int getNumLinks() { WARNPRINTF("Links::getNumLinks"); return 0; }
	Link* getLink(int i) const { WARNPRINTF("Links::getLink"); return 0; }
	GBool onLink(double x, double y) const { WARNPRINTF("Links::onLink"); return false; }
};


enum SplashColorMode { splashModeMono8 };
typedef Guchar *SplashColorPtr;

// only gray8 color model supported
class SplashBitmap {
public:
	SplashBitmap(int w, int h);
	~SplashBitmap() { delete[] data; }
	int getWidth() { return w; }
	int getHeight() { return h; }
	void getPixel(int x, int y, SplashColorPtr pxl) { pxl[0] = data[x+w*y]; }
	int getRowSize() { return rowSize; }
	SplashColorPtr getDataPtr() { return data; }
private:
	int w;
	int h;
	int rowSize;
	SplashColorPtr data;
};

class OutputDev {
public:
	OutputDev() { WARNPRINTF("Creating OutputDev"); bmp = 0; }
	virtual ~OutputDev() { WARNPRINTF("Destructing OutputDev"); if(bmp) delete bmp; }
	void startDoc(XRef *xref) { WARNPRINTF("OutputDev::startDoc"); } // unused, so no need for virtual
	void setBitmap(SplashBitmap *b) { if(bmp) delete bmp; bmp = b; } // should actually be placed in SplashOutputDev
	SplashBitmap* takeBitmap();
private:
	SplashBitmap *bmp;
};

class SplashOutputDev : public OutputDev {
public:
	SplashOutputDev(SplashColorMode colorModeA, int bitmapRowPadA,
				   GBool reverseVideoA, SplashColorPtr paperColorA);
	~SplashOutputDev();
	double* getDefCTM() { return defCtm; }
	double* getDefICTM() { return defIctm; }
private:
	double defCtm[6];  // coordinate transform matrix
	double defIctm[6]; // inverse coordinate transform matrix

		
};

class TextPage {
public:
	TextWordList *makeWordList(GBool physLayout) { return &wl; }
private:
	TextWordList wl;
};

class TextOutputDev : public OutputDev {
public:
	TextOutputDev(char *fileName, GBool physLayoutA,
				  GBool rawOrderA, GBool append);
	virtual ~TextOutputDev();
//	void startDoc(XRef* xref);
	TextPage* takeText() { return 0; }
};


enum RenderRet {
	Render_Done = 0,
	Render_Error = 1,
	Render_Abort = 2,
	Render_Invalid
};


class Annot {
	
};

class PDFDoc {
public:	
	PDFDoc(GooString *fileNameA);
	~PDFDoc();
	GBool isOk() { WARNPRINTF("PDFDoc::isOk"); return ok; }
	int getNumPages() 
	{
		if(twoPageMode) 
			return 2*(nPages-FirstFullPagesCount)+FirstFullPagesCount;
		return nPages;
	}
	int getRealPage(int page);
	bool is_left(int page)
	{
		if(startFromSecond) 
			page++;
		return (page-FirstFullPagesCount) % 2 != 0;
	}
	double getPageCropWidth(int page) 
	{
		page = getRealPage(page);
		refreshPage(page-1);
		if(twoPageMode && page > FirstFullPagesCount)
			return 0.5 * 72.0 * (double)pages[page-1].pageWidths / (double)pages[page-1].pageDpis;
		return 72.0 * (double)pages[page-1].pageWidths / (double)pages[page-1].pageDpis;
	}
	double getPageCropHeight(int page) 
	{
		page = getRealPage(page);
		refreshPage(page-1);
		return 72.0 * (double)pages[page-1].pageHeights / (double)pages[page-1].pageDpis;
	}
	int getPageRotate(int page) 
	{
		page = getRealPage(page);
		refreshPage(page-1);
		return pages[page-1].pageRotations;
	} // fixme check value?
	Links* getLinks(int page) { return 0; } // fixme
	Links* generateLinks(int page) { WARNPRINTF("PDFDoc::generateLinks"); return 0; } // added by iRex, generate links without rendering?
	int findPage(int num, int gen) { WARNPRINTF("PDFDoc::findPage"); return 0; } // find page given object id, 0 = not found
	LinkDest* findDest(GooString *name) { WARNPRINTF("PDFDoc::findDest"); return 0; } // not a destination	
	Outline* getOutline() { WARNPRINTF("PDFDoc::getOutline"); /* return outline; */ return 0; }
	RenderRet displayPage(OutputDev *out, int page, double hDPI, double vDPI,
				int rotate, GBool useMediaBox, GBool Crop, GBool printing,
				GBool (*abortCheckCbk)(void *data) = 0,
				void* abortCheckCbkData = 0,
				GBool (*annotDisplayDecideCbk) (Annot* annot, void *user_data) = 0,
				void *annotDisplayDecideCbkData = 0
						  );
	XRef *getXRef() { WARNPRINTF("PDFDoc::getXRef"); return &xref; }  // get xref table
		
	// should this be mutexed?
	void refreshPage(int page) 
	{ 
		if(pages[page].pageWidths == -1) 
		{
			ddjvu_pageinfo_t pi;
			ddjvu_document_get_pageinfo(doc,page,&pi);
			pages[page].pageWidths = pi.width;
			pages[page].pageHeights = pi.height;
			pages[page].pageDpis = pi.dpi;
			pages[page].pageRotations = pi.rotation;
			// WARNPRINTF("pageinfo: p: %d, w: %d, h: %d, dpi: %d", page, pi.width, pi.height, pi.dpi);
		}
	}
private:
	int nPages;
	int FirstFullPagesCount;
	GBool twoPageMode,startFromSecond; // artificially split pages

	ddjvu_document_t *doc;
	GBool ok;
	XRef xref;
	// Outline* outline;
	struct page_info_t{
		int pageWidths; // -1 if info for this page not loaded
		int pageHeights;
		int pageDpis;
		int pageRotations;
	};
	page_info_t* pages;
//	int *pageWidths; // -1 if info for this page not loaded
//	int *pageHeights;
//	int *pageDpis;
//	int *pageRotations;
};

#define splashMaxColorComps 4
typedef Guchar SplashColor[splashMaxColorComps];
typedef Guchar *SplashColorPtr;



#endif
