#!/bin/bash

echo ""
echo ""
echo "Work directory = " `pwd`
echo ""
echo "E-reader filesystem = " $EREADER_ROOT
echo "-------------------"
echo ""

set_environment()
{
    if [ "$PKG_CONFIG_SYSROOT_DIR" = "" ]
    then
        echo "-- Host compilation"
        CONFIGURE_OPTIONS="--sysconfdir=/etc --prefix=/media/mmcblk0p1/Programs/_xmahjongg"
        DESTDIR="/"
    else
        echo "-- Cross compilation"
        CONFIGURE_OPTIONS="--host=arm-poky-linux-gnueabi --sysconfdir=/etc --prefix=/media/mmcblk0p1/Programs/_xmahjongg"
        DESTDIR="/usr/local/poky/eabi-glibc/arm/arm-poky-linux-gnueabi"
    fi
    export DESTDIR
}

set -e  # stop on error
set -v  # verbose
##set -x  # show executed commands


# Install build environment
set_environment
#intltoolize --copy --force --automake
#autoreconf --install --force
./configure ${CONFIGURE_OPTIONS} $*


# Build new object files
#make clean
make

# Generate language files
cd po
rm -f *.gmo
make update-po
make
cd ..

# Install new object and data files
if [ "$PKG_CONFIG_SYSROOT_DIR" != ""  -a  "$EREADER_ROOT" != "" ]
then
    make install DESTDIR="$EREADER_ROOT"
fi


echo "Done ok"

