from __future__ import with_statement
# coding: utf-8
from calibre.web.feeds.news import BasicNewsRecipe, AutomaticNewsRecipe
__license__ = 'GPL v3'
__copyright__ = '2010, BlonG'
'''
dnevnik.si
'''
from calibre.web.feeds.news import BasicNewsRecipe
class Dnevnik(BasicNewsRecipe):
  title = u'Dnevnik.si'
  __author__ = u'BlonG'
  description = u"Dnevnik je časnik z več kot polstoletno zgodovino. Pod sloganom »Življenje ima besedo« na svojih straneh prinaša bralcem bogastvo informacij, komentarjev in kolumen in raznovrstnost pogledov, zaznamovanih z odgovornostjo do posameznika in širše družbe."
  oldest_article = 3
  max_articles_per_feed = 20
  no_stylesheets = True
  use_embedded_content = False

  cover_url = 'https://sites.google.com/site/javno2010/home/dnevnik_cover.jpg'

  extra_css = '''
	h1{font-family:Arial,Helvetica,sans-serif; font-weight:bold;font-size:large;}
	h2{font-family:Arial,Helvetica,sans-serif; font-weight:normal;font-size:small;}
	p{font-family:Arial,Helvetica,sans-serif;font-size:small;}
	body{font-family:Helvetica,Arial,sans-serif;font-size:small;}
	'''

  html2lrf_options = ['--base-font-size', '10']

  keep_only_tags = [
	dict(name='div', attrs={'id':'_iprom_inStream'}),
	dict(name='div', attrs={'class':'entry-content'}),
	]

  remove_tags = [
	dict(name='div', attrs={'class':'fb_article_top'}),
	dict(name='div', attrs={'class':'related'}),
	dict(name='div', attrs={'class':'fb_article_foot'}),
	dict(name='div', attrs={'class':'spreading'}),
	dict(name='dl', attrs={'class':'ad'}),
	dict(name='p', attrs={'class':'report'}),
	dict(name='div', attrs={'class':'hfeed comments'}),
	dict(name='dl', attrs={'id':'entryPanel'}),
	dict(name='dl', attrs={'class':'infopush ip_wide'}),
	dict(name='div', attrs={'class':'sidebar'}),
	dict(name='dl', attrs={'class':'bottom'}),
	dict(name='div', attrs={'id':'footer'}),
	]


  feeds = [
	(u'Slovenija', u'http://www.dnevnik.si/rss/?articleType=1&articleSection=13')
	,(u'Svet', u'http://www.dnevnik.si/rss/?articleType=1&articleSection=14')
	,(u'EU', u'http://www.dnevnik.si/rss/?articleType=1&articleSection=116')
	,(u'Poslovni dnevnik', u'http://www.dnevnik.si/rss/?articleType=1&articleSection=5')
	,(u'Kronika', u'http://www.dnevnik.si/rss/?articleType=1&articleSection=15')
	,(u'Kultura', u'http://www.dnevnik.si/rss/?articleType=1&articleSection=17')
	,(u'Zdravje', u'http://www.dnevnik.si/rss/?articleType=1&articleSection=18')
	,(u'Znanost in IT', u'http://www.dnevnik.si/rss/?articleType=1&articleSection=19')
	,(u'(Ne)verjetno', u'http://www.dnevnik.si/rss/?articleType=1&articleSection=20')
	,(u'E-strada', u'http://www.dnevnik.si/rss/?articleType=1&articleSection=21')
	,(u'Svet vozil', u'http://www.dnevnik.si/rss/?articleType=1&articleSection=22')
	]