/*
 * Decompiled with CFR 0.152.
 */
package common.image;

import common.image.ImageUtils;
import common.image.PixelData;
import common.utils.ExtFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class PixelDataGroup {
    private BufferedImage image;
    private PixelData[] pd_array;
    private int start_x;
    private int start_y;
    private int group_width;
    private int group_height;
    private int num_pixels;

    public PixelDataGroup(BufferedImage image, int start_x, int start_y, int group_width, int group_height) {
        this.image = image;
        this.start_x = start_x;
        this.start_y = start_y;
        this.group_width = group_width;
        this.group_height = group_height;
        this.num_pixels = 0;
        int image_width = image.getWidth();
        int image_height = image.getHeight();
        if (start_x < 0 || start_x + group_width > image_width || start_y < 0 || start_y + group_height > image_height) {
            this.pd_array = null;
        } else {
            this.num_pixels = group_width * group_height;
            this.pd_array = new PixelData[this.num_pixels];
            int y = start_y;
            int j = 0;
            while (j < group_height) {
                int x = start_x;
                int i = 0;
                while (i < group_width) {
                    PixelData pd;
                    int rgb = image.getRGB(x, y);
                    Color color = ImageUtils.getRGBColorFromInt(rgb);
                    this.pd_array[group_width * j + i] = pd = new PixelData(x, y, color);
                    ++x;
                    ++i;
                }
                ++y;
                ++j;
            }
        }
    }

    public PixelDataGroup getRow(int row_num) {
        if (row_num >= this.group_height) {
            return null;
        }
        PixelData[] row = new PixelData[this.group_width];
        int i = row_num * this.group_width;
        int index = 0;
        while (index < this.group_width) {
            row[index] = this.pd_array[i];
            ++i;
            ++index;
        }
        return new PixelDataGroup(this.image, this.start_x, this.start_y + row_num, this.group_width, 1);
    }

    public PixelDataGroup getColumn(int col_num) {
        if (col_num >= this.group_width) {
            return null;
        }
        PixelData[] col = new PixelData[this.group_height];
        int i = col_num;
        int index = 0;
        while (index < this.group_height) {
            col[index] = this.pd_array[i];
            i += this.group_width;
            ++index;
        }
        return new PixelDataGroup(this.image, this.start_x + col_num, this.start_y, 1, this.group_height);
    }

    public PixelData getPixelData(int index) {
        return this.pd_array[index];
    }

    public PixelData getPixelData(int row_index, int column_index) {
        int index = row_index * this.group_width + column_index;
        if (index > this.pd_array.length || row_index > this.group_height - 1 || column_index > this.group_width - 1) {
            return null;
        }
        return this.pd_array[index];
    }

    public int getStartX() {
        return this.start_x;
    }

    public int getStartY() {
        return this.start_y;
    }

    public int getGroupWidth() {
        return this.group_width;
    }

    public int getGroupHeight() {
        return this.group_height;
    }

    public int getNumPixels() {
        return this.num_pixels;
    }

    public boolean isNull() {
        return this.pd_array == null || this.pd_array.length == 0;
    }

    public void outputAsImage(File output_file) {
        try {
            String image_file_ext;
            String image_file_ext_no_period = image_file_ext = ExtFilter.getExtension(output_file);
            if (image_file_ext_no_period.charAt(0) == '.') {
                image_file_ext_no_period = image_file_ext_no_period.substring(1);
            }
            BufferedImage out_image = this.image.getSubimage(this.start_x, this.start_y, this.group_width, this.group_height);
            ImageIO.write((RenderedImage)out_image, image_file_ext_no_period, output_file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isWholePDGWithinColorThreshold(int threshold) {
        boolean is_within_color_threshold = true;
        int i = 0;
        while (is_within_color_threshold && i < this.group_height) {
            if (!this.isPDGRowWithinColorThreshold(i, threshold)) {
                is_within_color_threshold = false;
            }
            ++i;
        }
        i = 0;
        while (is_within_color_threshold && i < this.group_width) {
            if (!this.isPDGColWithinColorThreshold(i, threshold)) {
                is_within_color_threshold = false;
            }
            ++i;
        }
        return is_within_color_threshold;
    }

    public boolean isPDGRowWithinColorThreshold(int row_num, int threshold) {
        boolean is_within_color_threshold = true;
        PixelDataGroup pdg_row = this.getRow(row_num);
        int i = 0;
        while (is_within_color_threshold && i < pdg_row.getNumPixels() - 1) {
            PixelData cur_pd = pdg_row.getPixelData(i);
            int j = i + 1;
            while (is_within_color_threshold && j < pdg_row.getNumPixels()) {
                PixelData comp_pd = pdg_row.getPixelData(j);
                if (!cur_pd.isPixelDataWithinColorThreshold(comp_pd, threshold)) {
                    is_within_color_threshold = false;
                }
                ++j;
            }
            ++i;
        }
        return is_within_color_threshold;
    }

    public boolean isPDGColWithinColorThreshold(int col_num, int threshold) {
        boolean is_within_color_threshold = true;
        PixelDataGroup pdg_col = this.getColumn(col_num);
        int i = 0;
        while (is_within_color_threshold && i < pdg_col.getNumPixels() - 1) {
            PixelData cur_pd = pdg_col.getPixelData(i);
            int j = i + 1;
            while (is_within_color_threshold && j < pdg_col.getNumPixels()) {
                PixelData comp_pd = pdg_col.getPixelData(j);
                if (!cur_pd.isPixelDataWithinColorThreshold(comp_pd, threshold)) {
                    is_within_color_threshold = false;
                }
                ++j;
            }
            ++i;
        }
        return is_within_color_threshold;
    }

    public boolean isPDGGrayscale() {
        boolean is_grayscale = true;
        int i = 0;
        while (is_grayscale && i < this.num_pixels) {
            if (!this.getPixelData(i).isGrayscale()) {
                is_grayscale = false;
            }
            ++i;
        }
        return is_grayscale;
    }

    public boolean isPDGRowsMatchingBinaryPattern() {
        boolean is_rows_matching_binary_pattern = true;
        String first_row_binary_pattern = this.getPDGRowBinaryPattern(0);
        int i = 1;
        while (is_rows_matching_binary_pattern && i < this.group_height) {
            String cur_row_binary_pattern = this.getPDGRowBinaryPattern(i);
            if (!first_row_binary_pattern.equals(cur_row_binary_pattern)) {
                is_rows_matching_binary_pattern = false;
            }
            ++i;
        }
        return is_rows_matching_binary_pattern;
    }

    public boolean isPDGRowsMatchingBinaryPattern(int num_pattern_switches) {
        boolean is_rows_matching_binary_pattern = true;
        int num_observed_pattern_switches = 0;
        String prev_row_binary_pattern = this.getPDGRowBinaryPattern(0);
        int i = 1;
        while (is_rows_matching_binary_pattern && i < this.group_height) {
            String cur_row_binary_pattern = this.getPDGRowBinaryPattern(i);
            if (!prev_row_binary_pattern.equals(cur_row_binary_pattern) && ++num_observed_pattern_switches > num_pattern_switches) {
                is_rows_matching_binary_pattern = false;
            }
            prev_row_binary_pattern = cur_row_binary_pattern;
            ++i;
        }
        return is_rows_matching_binary_pattern;
    }

    public String getPDGRowBinaryPattern(int row_num) {
        PixelDataGroup pdg_row = this.getRow(row_num);
        if (pdg_row.getNumPixels() == 0) {
            return null;
        }
        String binary_pattern = "";
        int i = 0;
        while (i < pdg_row.getNumPixels()) {
            binary_pattern = String.valueOf(binary_pattern) + pdg_row.getPixelData(i).getBinaryLevel();
            ++i;
        }
        return binary_pattern;
    }

    public String toString() {
        String to_string = null;
        String[] all_pd_strings = new String[this.num_pixels];
        int longest_length = 0;
        int i = 0;
        while (i < this.num_pixels) {
            String new_pd_string = "(" + this.getPixelData(i).toString() + ")";
            if (new_pd_string.length() > longest_length) {
                longest_length = new_pd_string.length();
            }
            all_pd_strings[i] = new_pd_string;
            ++i;
        }
        i = 0;
        while (i < this.num_pixels) {
            String cur_pd_string = all_pd_strings[i];
            if (i == 0 || i != 0 && (i + 1) % this.group_width != 0) {
                int j = cur_pd_string.length();
                while (j <= longest_length) {
                    cur_pd_string = String.valueOf(cur_pd_string) + " ";
                    ++j;
                }
            }
            all_pd_strings[i] = cur_pd_string;
            ++i;
        }
        to_string = "";
        i = 0;
        while (i < this.group_height) {
            int j = 0;
            while (j < this.group_width) {
                to_string = String.valueOf(to_string) + all_pd_strings[i * this.group_width + j];
                ++j;
            }
            if (i != this.group_height - 1) {
                to_string = String.valueOf(to_string) + "\n";
            }
            ++i;
        }
        return to_string;
    }
}

