/*
 * Decompiled with CFR 0.152.
 */
package manga;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesLoader {
    private Properties props = new Properties();
    private File properties_file = null;
    protected final String key_width = "width";
    protected final String key_height = "height";
    protected final String key_max_dpi = "max_dpi";
    protected final String key_auto_trim = "auto_trim";
    protected final String key_trim_fuzz = "trim_fuzz";
    protected final String key_trim_cancel = "trim_cancel";
    protected final String key_add_border = "add_border";
    protected final String key_add_border_color = "add_border_color";
    protected final String key_auto_rotate = "auto_rotate";
    protected final String key_color_mode = "color_mode";
    protected final String key_num_colors = "num_colors";
    protected final String key_manga_prefix = "manga_prefix";
    protected final String key_page_filename_length = "page_filename_length";
    protected final String key_auto_sense_suffix_length = "auto_sense_suffix_length";
    protected final String key_use_original_filenames = "use_original_filenames";
    protected final String key_output_base_folder = "output_base_folder";
    protected final String key_del_output_image_folders = "del_output_image_folders";
    protected final String key_archive_input_image_folders = "archive_input_image_folders";
    protected final String key_unarchive_input_image_archives = "unarchive_input_image_archives";
    protected final String key_pdf = "pdf";
    protected final String key_pdf_r_to_l = "pdf_r_to_l";
    protected final String key_archive = "archive";
    protected final String key_archive_format = "archive_format";
    protected final String key_epub = "epub";
    protected final String key_epub_r_to_l = "epub_r_to_l";
    protected final String key_auto_bind = "auto_bind";
    protected final String key_auto_bind_size = "auto_bind_size";
    protected final String key_auto_split_landscape_scans = "auto_split_landscape_scans";
    protected final String key_auto_split_r_first = "auto_split_r_first";
    protected final String key_auto_split_keep_unsplit_scans = "auto_split_keep_unsplit_scans";
    protected final String key_auto_split_buffer = "auto_split_buffer";
    protected final String key_allow_auto_split_color_scans = "allow_auto_split_color_scans";
    protected final String key_auto_split_gray_strictness = "auto_split_gray_strictness";
    protected final String key_auto_split_color_strictness = "auto_split_color_strictness";
    protected final String key_auto_sense_landscape_folders = "auto_sense_landscape_folders";
    protected final String key_image_format = "image_format";
    protected final String key_image_magick_dir = "image_magick_dir";
    protected final String key_kindle_bookmark = "kindle_bookmark";
    protected final String key_comic_zeal_naming = "comic_zeal_naming";

    public PropertiesLoader(File n_properties_file) {
        this.properties_file = n_properties_file;
        if (!this.properties_file.exists()) {
            System.out.println("ERROR: Couldn't load .properties file. Please make sure that " + this.properties_file.getAbsolutePath() + " exists.");
            System.out.println("You can run Canti without any options (java -jar Canti.jar) for instructions on creating a .properties file.");
            System.exit(1);
        }
        try {
            FileInputStream fis = new FileInputStream(this.properties_file);
            this.props.load(fis);
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PropertiesLoader(InputStream is) {
        try {
            this.props.load(is);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getWidth() {
        return this.intKeyValue(this.props.getProperty("width"));
    }

    public int getHeight() {
        return this.intKeyValue(this.props.getProperty("height"));
    }

    public int getMaxDPI() {
        return this.intKeyValue(this.props.getProperty("max_dpi"));
    }

    public String getMangaPrefix() {
        return this.props.getProperty("manga_prefix");
    }

    public int getPageFilenameLength() {
        return this.intKeyValue(this.props.getProperty("page_filename_length"));
    }

    public int getAutoSenseSuffixLength() {
        return this.intKeyValue(this.props.getProperty("auto_sense_suffix_length"));
    }

    public boolean getUseOriginalFilenames() {
        return this.booleanKeyValue(this.props.getProperty("use_original_filenames"));
    }

    public String getOutputBaseFolder() {
        return this.props.getProperty("output_base_folder").trim();
    }

    public boolean getArchiveInputImageFolders() {
        return this.booleanKeyValue(this.props.getProperty("archive_input_image_folders"));
    }

    public boolean getUnarchiveInputImageArchives() {
        return this.booleanKeyValue(this.props.getProperty("unarchive_input_image_archives"));
    }

    public boolean getDelOutputImageFolders() {
        return this.booleanKeyValue(this.props.getProperty("del_output_image_folders"));
    }

    public boolean getAutoTrim() {
        return this.booleanKeyValue(this.props.getProperty("auto_trim"));
    }

    public int getTrimFuzz() {
        return this.intKeyValue(this.props.getProperty("trim_fuzz"));
    }

    public double getTrimCancel() {
        return this.doubleKeyValue(this.props.getProperty("trim_cancel"));
    }

    public boolean getAddBorder() {
        return this.booleanKeyValue(this.props.getProperty("add_border"));
    }

    public String getAddBorderColor() {
        return this.props.getProperty("add_border_color");
    }

    public boolean getAutoRotate() {
        return this.booleanKeyValue(this.props.getProperty("auto_rotate"));
    }

    public String getColorMode() {
        return this.props.getProperty("color_mode");
    }

    public int getNumColors() {
        return this.intKeyValue(this.props.getProperty("num_colors"));
    }

    public boolean getPdf() {
        return this.booleanKeyValue(this.props.getProperty("pdf"));
    }

    public boolean getPdfRToL() {
        return this.booleanKeyValue(this.props.getProperty("pdf_r_to_l"));
    }

    public boolean getArchive() {
        return this.booleanKeyValue(this.props.getProperty("archive"));
    }

    public String getArchiveFormat() {
        return this.props.getProperty("archive_format");
    }

    public boolean getEpub() {
        return this.booleanKeyValue(this.props.getProperty("epub"));
    }

    public boolean getEpubRToL() {
        return this.booleanKeyValue(this.props.getProperty("epub_r_to_l"));
    }

    public boolean getAutoBind() {
        return this.booleanKeyValue(this.props.getProperty("auto_bind"));
    }

    public int getAutoBindSize() {
        return this.intKeyValue(this.props.getProperty("auto_bind_size"));
    }

    public boolean getAutoSplitLandscapeScans() {
        return this.booleanKeyValue(this.props.getProperty("auto_split_landscape_scans"));
    }

    public boolean getAutoSplitRFirst() {
        return this.booleanKeyValue(this.props.getProperty("auto_split_r_first"));
    }

    public boolean getAutoSplitKeepUnsplitScans() {
        return this.booleanKeyValue(this.props.getProperty("auto_split_keep_unsplit_scans"));
    }

    public boolean getAllowAutoSplitColorScans() {
        return this.booleanKeyValue(this.props.getProperty("allow_auto_split_color_scans"));
    }

    public double getAutoSplitGrayStrictness() {
        return this.doubleKeyValue(this.props.getProperty("auto_split_gray_strictness"));
    }

    public double getAutoSplitColorStrictness() {
        return this.doubleKeyValue(this.props.getProperty("auto_split_color_strictness"));
    }

    public double getAutoSplitBuffer() {
        return this.doubleKeyValue(this.props.getProperty("auto_split_buffer"));
    }

    public boolean getAutoSenseLandscapeFolders() {
        return this.booleanKeyValue(this.props.getProperty("auto_sense_landscape_folders"));
    }

    public String getImageFormat() {
        return this.props.getProperty("image_format");
    }

    public String getImageMagickDir() {
        return this.props.getProperty("image_magick_dir").trim();
    }

    public boolean getKindleBookmark() {
        return this.booleanKeyValue(this.props.getProperty("kindle_bookmark"));
    }

    public boolean getComicZealNaming() {
        return this.booleanKeyValue(this.props.getProperty("comic_zeal_naming"));
    }

    public int intKeyValue(String value) {
        value = value.trim();
        return Integer.parseInt(value);
    }

    public double doubleKeyValue(String value) {
        value = value.trim();
        return Double.parseDouble(value);
    }

    public boolean booleanKeyValue(String value) {
        if ((value = value.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return false;
    }

    public void printProperties() {
        boolean use_original_filenames;
        int width;
        if (this.properties_file != null) {
            System.out.println("\nUsing these settings stored in " + this.properties_file.getAbsolutePath() + ":");
        }
        if ((width = this.getWidth()) != -1) {
            System.out.println("  width (in pixels):  " + width);
        } else {
            System.out.println("  width (in pixels):  original");
        }
        int height = this.getHeight();
        if (height != -1) {
            System.out.println("  height (in pixels): " + height);
        } else {
            System.out.println("  height (in pixels): original");
        }
        int max_dpi = this.getMaxDPI();
        if (max_dpi != -1) {
            System.out.println("  maximum dpi: " + max_dpi);
        } else {
            System.out.println("  maximum dpi: original");
        }
        boolean use_autotrim = this.getAutoTrim();
        System.out.println("  auto trim: " + use_autotrim);
        if (use_autotrim) {
            System.out.println("    trim fuzz: " + this.getTrimFuzz() + "%");
            System.out.println("    trim cancel: " + this.getTrimCancel());
        }
        boolean use_add_border = this.getAddBorder();
        System.out.println("  add border: " + use_add_border);
        if (use_add_border) {
            System.out.println("    border color: " + this.getAddBorderColor());
        }
        System.out.println("  auto rotate: " + this.getAutoRotate());
        System.out.println("  color mode: " + this.getColorMode());
        int num_colors = this.getNumColors();
        if (num_colors != -1) {
            System.out.println("  num colors: " + num_colors);
        } else {
            System.out.println("  num colors: full");
        }
        boolean use_pdf = this.getPdf();
        System.out.println("  pdf chapters: " + use_pdf);
        if (use_pdf) {
            System.out.println("    pdf r to l: " + this.getPdfRToL());
        }
        boolean use_archive = this.getArchive();
        System.out.println("  archive chapters: " + use_archive);
        if (use_archive) {
            System.out.println("    archive format: " + this.getArchiveFormat());
        }
        boolean use_epub = this.getEpub();
        System.out.println("  epub chapters: " + use_epub);
        if (use_epub) {
            System.out.println("    epub r to l: " + this.getEpubRToL());
        }
        boolean use_auto_bind = this.getAutoBind();
        System.out.println("  auto bind: " + use_auto_bind);
        if (use_auto_bind) {
            System.out.println("    auto bind size: " + this.getAutoBindSize());
        }
        boolean use_auto_split_landscape_scans = this.getAutoSplitLandscapeScans();
        System.out.println("  auto split landscape scans: " + use_auto_split_landscape_scans);
        if (use_auto_split_landscape_scans) {
            System.out.println("    split right page first: " + this.getAutoSplitRFirst());
            System.out.println("    keep unsplit scans: " + this.getAutoSplitKeepUnsplitScans());
            System.out.println("    allow auto split color scans: " + this.getAllowAutoSplitColorScans());
            System.out.println("    auto split gray strictness: " + this.getAutoSplitGrayStrictness());
            System.out.println("    auto split color strictness: " + this.getAutoSplitColorStrictness());
            System.out.println("    auto split buffer: " + this.getAutoSplitBuffer());
            System.out.println("    auto sense landacape folders: " + this.getAutoSenseLandscapeFolders());
        }
        if (!(use_original_filenames = this.getUseOriginalFilenames())) {
            System.out.println("  manga prefix: " + this.getMangaPrefix());
        }
        int auto_sense_suffix_length = this.getAutoSenseSuffixLength();
        if (!use_original_filenames && auto_sense_suffix_length > 0) {
            System.out.println("  auto sense suffix length: " + auto_sense_suffix_length);
        }
        System.out.println("  use original filenames: " + use_original_filenames);
        boolean unarchive_input_image_archives = this.getUnarchiveInputImageArchives();
        if (unarchive_input_image_archives) {
            System.out.println("  unarchive input image archives: " + unarchive_input_image_archives);
        } else {
            System.out.println("  archive input image folders: " + this.getArchiveInputImageFolders());
        }
        System.out.println("  delete output image folders: " + this.getDelOutputImageFolders());
        System.out.println("  image format: " + this.getImageFormat());
        System.out.println("  kindle bookmark: " + this.getKindleBookmark());
        System.out.println("  comic zeal naming: " + this.getComicZealNaming());
        System.out.println("  ImageMagick home directory: " + this.getImageMagickDir());
        System.out.println("");
    }
}

