/*
 * Decompiled with CFR 0.152.
 */
package manga;

import common.image.ImageMagick;
import common.utils.ExtFilter;
import common.utils.FileUtils;
import common.utils.SystemRar;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class MangaCollection {
    private File parent_folder;
    private long num_zips;
    private long num_rars;
    private long num_pdfs;
    private long num_image_folders;
    private long num_scans_zips;
    private long num_scans_rars;
    private long num_scans_pdfs;
    private long num_scans_image_folders;
    private long total_size_zips;
    private long total_size_rars;
    private long total_size_pdfs;
    private long total_size_image_folders;
    private ExtFilter image_ext_filter;
    private ImageMagick im;
    private SystemRar sysrar;

    public MangaCollection(File parent_folder, File properties_file) {
        this.parent_folder = parent_folder;
        this.image_ext_filter = new ExtFilter("image");
        this.im = new ImageMagick(properties_file);
        this.sysrar = new SystemRar();
        this.num_zips = 0L;
        this.num_rars = 0L;
        this.num_pdfs = 0L;
        this.num_image_folders = 0L;
        this.num_scans_zips = 0L;
        this.num_scans_rars = 0L;
        this.num_scans_pdfs = 0L;
        this.num_scans_image_folders = 0L;
        this.total_size_zips = 0L;
        this.total_size_rars = 0L;
        this.total_size_pdfs = 0L;
        this.total_size_image_folders = 0L;
        if (!this.sysrar.canUnrar()) {
            System.out.println("  WARNING: Cannot find a compatible rar handler, so will not be able to analyze the contents of rar files. Please see readme.txt for instructions on setting up a compatible rar handler.");
        }
    }

    public void collectData() {
        if (!this.parent_folder.exists()) {
            System.out.println("  ERROR: " + this.parent_folder.getAbsolutePath() + " does not exist. Please make sure the path is correct and try again.");
            System.exit(1);
        } else if (!this.parent_folder.isDirectory()) {
            System.out.println("  ERROR: " + this.parent_folder.getAbsolutePath() + " is not a directory. Please make sure the path points to a folder and try again.");
            System.exit(1);
        } else {
            this.collectData(this.parent_folder);
        }
    }

    private void collectData(File folder) {
        ArrayList<File> folder_list = FileUtils.getFolderList(folder);
        ArrayList<File> zip_list = FileUtils.getZipFileList(folder);
        ArrayList<File> rar_list = FileUtils.getRarFileList(folder);
        ArrayList<File> pdf_list = FileUtils.getPdfFileList(folder);
        ArrayList<File> image_list = FileUtils.getImageFileList(folder);
        int i = 0;
        while (i < folder_list.size()) {
            File cur_folder = folder_list.get(i);
            this.collectData(cur_folder);
            ++i;
        }
        long prev_num_scans_zips = this.num_scans_zips;
        int i2 = 0;
        while (i2 < zip_list.size()) {
            File cur_zip = zip_list.get(i2);
            int num_images_cur_zip = this.countImagesInZip(cur_zip);
            this.num_scans_zips += (long)num_images_cur_zip;
            this.total_size_zips += cur_zip.length();
            ++this.num_zips;
            ++i2;
        }
        i2 = 0;
        while (i2 < rar_list.size()) {
            File cur_rar = rar_list.get(i2);
            int num_images_cur_rar = this.countImagesInRar(cur_rar);
            this.num_scans_rars += (long)num_images_cur_rar;
            this.total_size_rars += cur_rar.length();
            ++this.num_rars;
            ++i2;
        }
        long prev_num_scans_pdfs = this.num_scans_pdfs;
        int i3 = 0;
        while (i3 < pdf_list.size()) {
            File cur_pdf = pdf_list.get(i3);
            int num_pages_cur_pdf = this.countPagesInPdf(cur_pdf);
            this.num_scans_pdfs += (long)num_pages_cur_pdf;
            ++this.num_pdfs;
            ++i3;
        }
        long prev_num_scans_image_folders = this.num_scans_image_folders;
        int i4 = 0;
        while (i4 < image_list.size()) {
            File cur_image = image_list.get(i4);
            this.total_size_image_folders += cur_image.length();
            ++this.num_scans_image_folders;
            ++i4;
        }
        if (prev_num_scans_zips == this.num_scans_zips && prev_num_scans_pdfs == this.num_scans_pdfs && prev_num_scans_image_folders < this.num_scans_image_folders) {
            ++this.num_image_folders;
        }
    }

    private int countImagesInZip(File zip_file) {
        int num_images = 0;
        ArrayList<String> zip_entry_names = FileUtils.getZipEntryNames(zip_file);
        int j = 0;
        while (j < zip_entry_names.size()) {
            File zip_entry_file = new File(zip_entry_names.get(j));
            String zip_entry_file_extension = ExtFilter.getExtension(zip_entry_file);
            if (this.image_ext_filter.isValid(zip_entry_file_extension)) {
                ++num_images;
            }
            ++j;
        }
        return num_images;
    }

    private int countImagesInRar(File rar_file) {
        int num_images = 0;
        ArrayList<String> rar_entry_names = this.sysrar.listRar(rar_file);
        if (rar_entry_names == null) {
            return 0;
        }
        int j = 0;
        while (j < rar_entry_names.size()) {
            File rar_entry_file = new File(rar_entry_names.get(j));
            String rar_entry_file_extension = ExtFilter.getExtension(rar_entry_file);
            if (this.image_ext_filter.isValid(rar_entry_file_extension)) {
                ++num_images;
            }
            ++j;
        }
        return num_images;
    }

    private int countPagesInPdf(File pdf_file) {
        int num_pages = this.im.getNumPagesPdf(pdf_file);
        if (num_pages == -1) {
            return 0;
        }
        return num_pages;
    }

    private String convertBToMb(long bytes) {
        DecimalFormat df_size = new DecimalFormat("#0.00Mb");
        return df_size.format((float)bytes / 1048576.0f);
    }

    public String toString() {
        String to_string = "";
        to_string = String.valueOf(to_string) + "Parent folder: " + this.parent_folder.getAbsolutePath() + "\n";
        to_string = String.valueOf(to_string) + "\n--File Type Stats--\n";
        to_string = String.valueOf(to_string) + "# zips:          " + this.num_zips + "\n";
        to_string = String.valueOf(to_string) + "# rars:          " + this.num_rars + "\n";
        to_string = String.valueOf(to_string) + "# pdfs:          " + this.num_pdfs + "\n";
        to_string = String.valueOf(to_string) + "# image folders: " + this.num_image_folders + "\n";
        to_string = String.valueOf(to_string) + "\n--Scan Stats--\n";
        to_string = String.valueOf(to_string) + "# scans from zips:              " + this.num_scans_zips + "\n";
        if (this.sysrar.canUnrar()) {
            to_string = String.valueOf(to_string) + "# scans from rars:              " + this.num_scans_rars + "\n";
        }
        to_string = String.valueOf(to_string) + "# scans from pdfs:              " + this.num_scans_pdfs + "\n";
        to_string = String.valueOf(to_string) + "# scans from image folders:     " + this.num_scans_image_folders + "\n";
        if (this.num_zips > 0L) {
            to_string = String.valueOf(to_string) + "avg # scans in a zip:           " + this.num_scans_zips / this.num_zips + "\n";
        }
        if (this.num_rars > 0L && this.sysrar.canUnrar()) {
            to_string = String.valueOf(to_string) + "avg # scans in a rar:           " + this.num_scans_rars / this.num_rars + "\n";
        }
        if (this.num_pdfs > 0L) {
            to_string = String.valueOf(to_string) + "avg # scans in a pdf:           " + this.num_scans_pdfs / this.num_pdfs + "\n";
        }
        if (this.num_image_folders > 0L) {
            to_string = String.valueOf(to_string) + "avg # scans in an image folder: " + this.num_scans_image_folders / this.num_image_folders + "\n";
        }
        to_string = String.valueOf(to_string) + "\n--Size Stats--\n";
        to_string = String.valueOf(to_string) + "total size of zips:          " + this.convertBToMb(this.total_size_zips) + "\n";
        to_string = String.valueOf(to_string) + "total size of rars:          " + this.convertBToMb(this.total_size_rars) + "\n";
        to_string = String.valueOf(to_string) + "total size of pdfs:          " + this.convertBToMb(this.total_size_pdfs) + "\n";
        to_string = String.valueOf(to_string) + "total size of image folders: " + this.convertBToMb(this.total_size_image_folders) + "\n";
        if (this.num_zips > 0L) {
            to_string = String.valueOf(to_string) + "avg size of a zip:           " + this.convertBToMb(this.total_size_zips / this.num_zips) + "\n";
        }
        if (this.num_rars > 0L) {
            to_string = String.valueOf(to_string) + "avg size of a rar:           " + this.convertBToMb(this.total_size_rars / this.num_rars) + "\n";
        }
        if (this.num_pdfs > 0L) {
            to_string = String.valueOf(to_string) + "avg size of a pdf:           " + this.convertBToMb(this.total_size_pdfs / this.num_pdfs) + "\n";
        }
        if (this.num_image_folders > 0L) {
            to_string = String.valueOf(to_string) + "avg size of an image folder: " + this.convertBToMb(this.total_size_image_folders / this.num_image_folders) + "\n";
        }
        to_string = String.valueOf(to_string) + "\n--Total Stats--\n";
        to_string = String.valueOf(to_string) + "total # scans: " + (this.num_scans_zips + this.num_scans_rars + this.num_scans_pdfs + this.num_scans_image_folders) + "\n";
        to_string = String.valueOf(to_string) + "total size of collection: " + this.convertBToMb(this.total_size_zips + this.total_size_rars + this.total_size_pdfs + this.total_size_image_folders) + "\n";
        return to_string;
    }
}

