/*
 * Decompiled with CFR 0.152.
 */
package manga;

import common.utils.ExtFilter;
import common.utils.FileUtils;
import common.utils.JarUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.zip.ZipOutputStream;

public class EpubMaker {
    private static String default_loc = "/manga/epub/";
    private static String default_mimetype_filename = "mimetype";
    private static String default_container_filename = "container.xml";
    private static String default_pagetemplate_filename = "page-template.xpgt";
    private static String default_stylesheet_filename = "stylesheet.css";
    private String epub_title = null;
    private File epub_file = null;
    private boolean epub_r_to_l = false;
    private int page_filename_length;
    private ArrayList<File> manga_folders = null;
    private ArrayList<Integer> num_images_each_manga_folder = null;
    private File tmp_folder = null;
    private String uuid = null;
    File metainf_folder = null;
    File oebps_folder = null;
    File images_folder = null;

    public EpubMaker(String n_epub_title, File n_epub_file, File n_manga_folder, int n_page_filename_length, boolean n_epub_r_to_l) {
        this.epub_title = n_epub_title;
        this.epub_file = n_epub_file;
        this.manga_folders = new ArrayList();
        this.manga_folders.add(n_manga_folder);
        this.num_images_each_manga_folder = new ArrayList();
        this.tmp_folder = new File(String.valueOf(this.epub_file.getAbsolutePath()) + "_tmp" + File.separatorChar);
        this.page_filename_length = n_page_filename_length;
        this.epub_r_to_l = n_epub_r_to_l;
        this.metainf_folder = new File(String.valueOf(this.tmp_folder.getAbsolutePath()) + File.separatorChar + "META-INF");
        this.oebps_folder = new File(String.valueOf(this.tmp_folder.getAbsolutePath()) + File.separatorChar + "OEBPS");
        this.images_folder = new File(String.valueOf(this.oebps_folder.getAbsolutePath()) + File.separatorChar + "images");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        this.uuid = "canti" + sdf.format(date);
    }

    public EpubMaker(String n_epub_title, File n_epub_file, ArrayList<File> n_manga_folders, int n_page_filename_length, boolean n_epub_r_to_l) {
        this.epub_title = n_epub_title;
        this.epub_file = n_epub_file;
        this.manga_folders = n_manga_folders;
        this.num_images_each_manga_folder = new ArrayList();
        this.tmp_folder = new File(String.valueOf(this.epub_file.getAbsolutePath()) + "_tmp" + File.separatorChar);
        this.page_filename_length = n_page_filename_length;
        this.epub_r_to_l = n_epub_r_to_l;
        this.metainf_folder = new File(String.valueOf(this.tmp_folder.getAbsolutePath()) + File.separatorChar + "META-INF");
        this.oebps_folder = new File(String.valueOf(this.tmp_folder.getAbsolutePath()) + File.separatorChar + "OEBPS");
        this.images_folder = new File(String.valueOf(this.oebps_folder.getAbsolutePath()) + File.separatorChar + "images");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        this.uuid = "canti" + sdf.format(date);
    }

    public void makeEpub() {
        if (this.epub_title == null || this.epub_file == null || this.manga_folders == null) {
            return;
        }
        this.setupEpub();
        this.copyMangaImages();
        this.createXhtml();
        this.createContent();
        this.createToc();
        this.finalizeEpub();
    }

    private void copyMangaImages() {
        int next_starting_number = 0;
        int i = 0;
        while (i < this.manga_folders.size()) {
            File manga_folder = this.manga_folders.get(i);
            ArrayList<File> image_files = FileUtils.getImageFileList(manga_folder);
            Collections.sort(image_files);
            try {
                int j = 0;
                while (j < image_files.size()) {
                    File cur_image = image_files.get(j);
                    String extension = ExtFilter.getExtension(cur_image);
                    String new_name = Integer.toString(next_starting_number + j);
                    while (new_name.length() < this.page_filename_length) {
                        new_name = "0" + new_name;
                    }
                    new_name = String.valueOf(new_name) + extension;
                    FileUtils.copyFile(cur_image, new File(String.valueOf(this.images_folder.getAbsolutePath()) + File.separatorChar + new_name));
                    ++j;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            next_starting_number += image_files.size();
            this.num_images_each_manga_folder.add(image_files.size());
            ++i;
        }
    }

    private void createXhtml() {
        int next_starting_number = 0;
        int i = 0;
        while (i < this.manga_folders.size()) {
            File manga_folder = this.manga_folders.get(i);
            ArrayList<File> image_files = FileUtils.getImageFileList(this.images_folder);
            Collections.sort(image_files);
            image_files = new ArrayList<File>(image_files.subList(next_starting_number, this.num_images_each_manga_folder.get(i) + next_starting_number));
            int j = 0;
            while (j < image_files.size()) {
                File xhtml_file = new File(String.valueOf(this.oebps_folder.getAbsolutePath()) + File.separatorChar + manga_folder.getName() + "_split_" + j + ".xhtml");
                File cur_image_file = image_files.get(j);
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(xhtml_file));
                    bw.write("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n");
                    bw.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n");
                    bw.write("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
                    bw.write("<head>\n");
                    bw.write("  <title>" + manga_folder.getName() + "</title>\n");
                    bw.write("  <link href=\"../stylesheet.css\" type=\"text/css\" rel=\"stylesheet\" />\n");
                    bw.write("  <link rel=\"stylesheet\" type=\"application/vnd.adobe-page-template+xml\" href=\"page-template.xpgt\"/>\n");
                    bw.write("</head>\n");
                    bw.write("<body>\n\n");
                    bw.write("<img src=\"images/" + cur_image_file.getName() + "\" class=\"imgclass\" id=\"image" + ExtFilter.getNameWithoutExtension(cur_image_file) + "\"/>\n");
                    bw.write("\n</body>\n");
                    bw.write("</html>");
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            next_starting_number += this.num_images_each_manga_folder.get(i).intValue();
            ++i;
        }
    }

    private void createContent() {
        File content_file = new File(String.valueOf(this.tmp_folder.getAbsolutePath()) + File.separatorChar + "content.opf");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(content_file));
            bw.write("<?xml version=\"1.0\"?>\n");
            bw.write("<package version=\"2.0\" xmlns=\"http://www.idpf.org/2007/opf\"\n");
            bw.write("         unique-identifier=\"BookId\">\n");
            bw.write(" <metadata xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n");
            bw.write("           xmlns:opf=\"http://www.idpf.org/2007/opf\">\n");
            bw.write("   <dc:title>" + this.epub_title + "</dc:title>\n");
            bw.write("   <dc:creator opf:file-as=\"Canti\" opf:role=\"aut\">Canti</dc:creator>\n");
            bw.write("   <dc:language>en-US</dc:language>\n");
            bw.write("   <dc:rights>Public Domain</dc:rights>\n");
            bw.write("   <dc:publisher>Canti</dc:publisher>\n");
            bw.write("   <dc:identifier id=\"BookId\">urn:uuid:" + this.uuid + "</dc:identifier>\n");
            bw.write(" </metadata>\n");
            bw.write(" <manifest>\n");
            bw.write("  <item id=\"ncx\" href=\"toc.ncx\" media-type=\"text/xml\" />\n");
            bw.write("  <item id=\"style\" href=\"stylesheet.css\" media-type=\"text/css\" />\n");
            bw.write("  <item id=\"pagetemplate\" href=\"page-template.xpgt\" media-type=\"application/vnd.adobe-page-template+xml\" />\n");
            int i = 0;
            while (i < this.manga_folders.size()) {
                File manga_folder = this.manga_folders.get(i);
                int j = 0;
                while (j < this.num_images_each_manga_folder.get(i)) {
                    bw.write("  <item id=\"" + manga_folder.getName() + "_split_" + j + "\" href=\"" + this.oebps_folder.getName() + "/" + manga_folder.getName() + "_split_" + j + ".xhtml\" media-type=\"application/xhtml+xml\" />\n");
                    ++j;
                }
                ++i;
            }
            ArrayList<File> image_list = FileUtils.getImageFileList(this.images_folder);
            int i2 = 0;
            while (i2 < image_list.size()) {
                bw.write("  <item id=\"" + this.oebps_folder.getName() + "/" + this.images_folder.getName() + "/image" + ExtFilter.getNameWithoutExtension(image_list.get(i2)) + "\" media-type=\"image/jpeg\" />\n");
                ++i2;
            }
            bw.write(" </manifest>\n");
            bw.write(" <spine toc=\"ncx\">\n");
            if (this.epub_r_to_l) {
                i2 = this.manga_folders.size() - 1;
                while (i2 >= 0) {
                    File manga_folder = this.manga_folders.get(i2);
                    int j = this.num_images_each_manga_folder.get(i2) - 1;
                    while (j >= 0) {
                        bw.write("  <itemref idref=\"" + manga_folder.getName() + "_split_" + j + "\" />\n");
                        --j;
                    }
                    --i2;
                }
            } else {
                i2 = 0;
                while (i2 < this.manga_folders.size()) {
                    File manga_folder = this.manga_folders.get(i2);
                    int j = 0;
                    while (j < this.num_images_each_manga_folder.get(i2)) {
                        bw.write("  <itemref idref=\"" + manga_folder.getName() + "_split_" + j + "\" />\n");
                        ++j;
                    }
                    ++i2;
                }
            }
            bw.write(" </spine>\n");
            bw.write("</package>\n");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createToc() {
        File toc_file = new File(String.valueOf(this.tmp_folder.getAbsolutePath()) + File.separatorChar + "toc.ncx");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(toc_file));
            bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            bw.write("<ncx xmlns=\"http://www.daisy.org/z3986/2005/ncx/\" version=\"2005-1\">\n");
            bw.write("  <head>\n");
            bw.write("    <meta name=\"dtb:uid\" content=\"" + this.uuid + "\"/>\n");
            bw.write("    <meta name=\"dtb:depth\" content=\"1\"/>\n");
            bw.write("    <meta name=\"dtb:totalPageCount\" content=\"0\"/>\n");
            bw.write("    <meta name=\"dtb:maxPageNumber\" content=\"0\"/>\n");
            bw.write("  </head>\n");
            bw.write("  <docTitle>\n");
            bw.write("    <text>" + this.epub_title + "</text>\n");
            bw.write("  </docTitle>\n");
            bw.write("  <navMap>\n");
            int i = 0;
            while (i < this.manga_folders.size()) {
                File manga_folder = this.manga_folders.get(i);
                bw.write("    <navPoint id=\"" + manga_folder.getName() + "\" playOrder=\"" + (i + 1) + "\">\n");
                bw.write("      <navLabel>\n");
                bw.write("        <text>" + manga_folder.getName() + "</text>\n");
                bw.write("      </navLabel>\n");
                bw.write("      <content src=\"" + this.oebps_folder.getName() + "/" + manga_folder.getName() + "_split_0.xhtml\"/>\n");
                bw.write("    </navPoint>\n");
                ++i;
            }
            bw.write("  </navMap>\n");
            bw.write("</ncx>");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setupEpub() {
        if (this.tmp_folder.exists()) {
            FileUtils.deleteDirectory(this.tmp_folder);
        }
        this.tmp_folder.mkdir();
        this.metainf_folder.mkdir();
        this.oebps_folder.mkdir();
        this.images_folder.mkdir();
        JarUtils ju = new JarUtils();
        ju.copyJarFileToFilesystem(String.valueOf(default_loc) + default_mimetype_filename, new File(String.valueOf(this.tmp_folder.getAbsolutePath()) + File.separatorChar + default_mimetype_filename));
        ju.copyJarFileToFilesystem(String.valueOf(default_loc) + default_container_filename, new File(String.valueOf(this.metainf_folder.getAbsolutePath()) + File.separatorChar + default_container_filename));
        ju.copyJarFileToFilesystem(String.valueOf(default_loc) + default_pagetemplate_filename, new File(String.valueOf(this.oebps_folder.getAbsolutePath()) + File.separatorChar + default_pagetemplate_filename));
        ju.copyJarFileToFilesystem(String.valueOf(default_loc) + default_stylesheet_filename, new File(String.valueOf(this.tmp_folder.getAbsolutePath()) + File.separatorChar + default_stylesheet_filename));
    }

    private void finalizeEpub() {
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(this.epub_file));
            FileUtils.zipFolderRecursive(this.tmp_folder.getAbsolutePath(), this.tmp_folder.getAbsolutePath(), zos);
            zos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileUtils.deleteDirectory(this.tmp_folder);
    }
}

