/*
 * Decompiled with CFR 0.152.
 */
package manga;

import common.utils.ExtFilter;
import common.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import manga.ConvertManga;

public class CMFileObject {
    private File parent_file_handle;
    private File parent_folder_handle;
    private File output_folder_handle;
    private String suffix = "";
    File existing_output_folder_handle = null;
    File existing_output_archive_handle = null;
    private File output_archive_handle = null;
    private File output_pdf_handle = null;
    private File output_epub_handle = null;
    private boolean must_restore_parent = false;
    private boolean must_copy_parent = false;
    private boolean must_process = false;
    private boolean must_restore_output = false;
    protected static Comparator<CMFileObject> comp_suffix_order = new Comparator<CMFileObject>(){

        @Override
        public int compare(CMFileObject cmfo1, CMFileObject cmfo2) {
            String cmfo1_suffix = cmfo1.suffix;
            String cmfo2_suffix = cmfo2.suffix;
            if (cmfo1_suffix.contains("-")) {
                cmfo1_suffix = cmfo1_suffix.substring(0, cmfo1_suffix.indexOf(45));
            }
            if (cmfo2_suffix.contains("-")) {
                cmfo2_suffix = cmfo2_suffix.substring(0, cmfo2_suffix.indexOf(45));
            }
            if (cmfo1_suffix.isEmpty() || cmfo2_suffix.isEmpty()) {
                return cmfo1.getOutputFolderHandle().getName().compareTo(cmfo2.getOutputFolderHandle().getName());
            }
            try {
                return Double.valueOf(cmfo1_suffix).compareTo(Double.valueOf(cmfo2_suffix));
            }
            catch (Exception e) {
                return cmfo1.getOutputFolderHandle().getName().compareTo(cmfo2.getOutputFolderHandle().getName());
            }
        }
    };
    protected static Comparator<CMFileObject> comp_filename_order = new Comparator<CMFileObject>(){

        @Override
        public int compare(CMFileObject cmfo1, CMFileObject cmfo2) {
            String cmfo1_filename = cmfo1.output_folder_handle.getName();
            String cmfo2_filename = cmfo2.output_folder_handle.getName();
            return cmfo1_filename.compareTo(cmfo2_filename);
        }
    };

    public CMFileObject(File parent_file) {
        this.parent_file_handle = parent_file;
        if (this.parent_file_handle.isDirectory()) {
            this.parent_folder_handle = this.parent_file_handle;
        } else {
            String parent_file_filename_noext = ExtFilter.getNameWithoutExtension(this.parent_file_handle);
            this.parent_folder_handle = new File(String.valueOf(this.parent_file_handle.getParent()) + File.separatorChar + parent_file_filename_noext);
        }
        if (ConvertManga.auto_sense_suffix && !ConvertManga.use_original_filenames) {
            this.suffix = ConvertManga.auto_sense_suffix_length > 0 ? ConvertManga.getFileNumberSuffixPadded(this.parent_folder_handle, true, '0', ConvertManga.auto_sense_suffix_length) : ConvertManga.getFileNumberSuffix(this.parent_folder_handle, true);
        } else if (!ConvertManga.use_original_filenames) {
            this.suffix = this.parent_folder_handle.getName().substring(this.parent_folder_handle.getName().length() - ConvertManga.num_chars_keep_suffix);
        }
        this.output_folder_handle = ConvertManga.getOutputFolderHandleFromParentFile(this.parent_folder_handle, true);
        if (this.output_folder_handle.exists()) {
            this.existing_output_folder_handle = this.output_folder_handle;
        }
        String comic_zeal_prefix = String.valueOf(ConvertManga.title) + "~" + this.output_folder_handle.getName();
        comic_zeal_prefix = comic_zeal_prefix.replaceAll(" ", "_");
        if (ConvertManga.use_archive) {
            this.output_archive_handle = ConvertManga.use_original_filenames ? new File(String.valueOf(ConvertManga.output_folder_file.getAbsolutePath()) + File.separatorChar + this.parent_folder_handle.getName() + ConvertManga.archive_extension) : (ConvertManga.use_comic_zeal_naming ? new File(String.valueOf(ConvertManga.output_folder_file.getAbsolutePath()) + File.separatorChar + comic_zeal_prefix + ConvertManga.archive_extension) : new File(String.valueOf(ConvertManga.output_folder_file.getAbsolutePath()) + File.separatorChar + this.output_folder_handle.getName() + ConvertManga.archive_extension));
        }
        if (ConvertManga.use_pdf) {
            this.output_pdf_handle = ConvertManga.use_original_filenames ? new File(String.valueOf(ConvertManga.output_folder_file.getAbsolutePath()) + File.separatorChar + this.parent_folder_handle.getName() + ".pdf") : (ConvertManga.use_comic_zeal_naming ? new File(String.valueOf(ConvertManga.output_folder_file.getAbsolutePath()) + File.separatorChar + comic_zeal_prefix + ".pdf") : new File(String.valueOf(ConvertManga.output_folder_file.getAbsolutePath()) + File.separatorChar + this.output_folder_handle.getName() + ".pdf"));
        }
        if (ConvertManga.use_epub) {
            this.output_epub_handle = ConvertManga.use_original_filenames ? new File(String.valueOf(ConvertManga.output_folder_file.getAbsolutePath()) + File.separatorChar + this.parent_folder_handle.getName() + ".epub") : new File(String.valueOf(ConvertManga.output_folder_file.getAbsolutePath()) + File.separatorChar + this.output_folder_handle.getName() + ".epub");
        }
        if (this.existing_output_folder_handle == null && !ConvertManga.isFolderProcessed(ConvertManga.progress_file, this.output_folder_handle)) {
            this.must_copy_parent = true;
            if (!this.parent_folder_handle.exists()) {
                this.must_restore_parent = true;
            }
        }
        ArrayList<File> output_zipList = FileUtils.getZipFileList(ConvertManga.output_folder_file);
        ArrayList<File> output_rarList = FileUtils.getRarFileList(ConvertManga.output_folder_file);
        boolean done = false;
        int i = 0;
        while (!done && i < output_zipList.size()) {
            File cur_zip_file = output_zipList.get(i);
            File cur_zip_file_ofh = ConvertManga.getOutputFolderHandleFromOutputFile(cur_zip_file);
            if (cur_zip_file_ofh.getAbsolutePath().equals(this.output_folder_handle.getAbsolutePath())) {
                this.existing_output_archive_handle = cur_zip_file;
                done = true;
            }
            ++i;
        }
        if (ConvertManga.sysrar.canUnrar()) {
            i = 0;
            while (!done && i < output_rarList.size()) {
                File cur_rar_file = output_rarList.get(i);
                File cur_rar_file_ofh = ConvertManga.getOutputFolderHandleFromOutputFile(cur_rar_file);
                if (cur_rar_file_ofh.getAbsolutePath().equals(this.output_folder_handle.getAbsolutePath())) {
                    this.existing_output_archive_handle = cur_rar_file;
                    done = true;
                }
                ++i;
            }
        }
        if (!ConvertManga.isFolderProcessed(ConvertManga.progress_file, this.output_folder_handle)) {
            this.must_process = true;
        }
        if (this.output_archive_handle != null && !this.output_archive_handle.exists()) {
            this.must_process = true;
        }
        if (this.output_pdf_handle != null && !this.output_pdf_handle.exists()) {
            this.must_process = true;
        }
        if (this.output_epub_handle != null && !this.output_epub_handle.exists()) {
            this.must_process = true;
        }
        if (this.existing_output_archive_handle != null && this.existing_output_folder_handle == null && ConvertManga.use_bind && ConvertManga.isFolderProcessed(ConvertManga.progress_file, this.output_folder_handle)) {
            this.must_restore_output = true;
        }
    }

    public File getParentFileHandle() {
        return this.parent_file_handle;
    }

    public File getParentFolderHandle() {
        return this.parent_folder_handle;
    }

    public File getOutputFolderHandle() {
        return this.output_folder_handle;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public File getOutputArchiveHandle() {
        return this.output_archive_handle;
    }

    public File getOutputPdfHandle() {
        return this.output_pdf_handle;
    }

    public File getOutputEpubHandle() {
        return this.output_epub_handle;
    }

    public boolean getMustRestoreParent() {
        return this.must_restore_parent;
    }

    public boolean getMustCopyParent() {
        return this.must_copy_parent;
    }

    public boolean getMustProcess() {
        return this.must_process;
    }

    public boolean getMustRestoreOutput() {
        return this.must_restore_output;
    }

    protected boolean isInArrayListByOFHMatch(ArrayList<CMFileObject> cmfo_list) {
        boolean found = false;
        int i = 0;
        while (!found && i < cmfo_list.size()) {
            CMFileObject comp_cmfo = cmfo_list.get(i);
            if (comp_cmfo.getOutputFolderHandle().getAbsolutePath().equals(this.output_folder_handle.getAbsolutePath())) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public String toString() {
        String to_string = "parent_file_handle: " + this.parent_file_handle + "\n";
        to_string = String.valueOf(to_string) + "parent_folder_handle: " + this.parent_folder_handle + "\n";
        to_string = String.valueOf(to_string) + "output_folder_handle: " + this.output_folder_handle + "\n";
        to_string = String.valueOf(to_string) + "suffix: " + this.suffix + "\n";
        to_string = String.valueOf(to_string) + "existing_output_folder_handle: " + this.existing_output_folder_handle + "\n";
        to_string = String.valueOf(to_string) + "existing_output_archive_handle: " + this.existing_output_archive_handle + "\n";
        to_string = String.valueOf(to_string) + "output_archive_handle: " + this.output_archive_handle + "\n";
        to_string = String.valueOf(to_string) + "output_pdf_handle: " + this.output_pdf_handle + "\n";
        to_string = String.valueOf(to_string) + "output_epub_handle: " + this.output_epub_handle + "\n";
        to_string = String.valueOf(to_string) + "must_restore_parent: " + this.must_restore_parent + "\n";
        to_string = String.valueOf(to_string) + "must_copy_parent: " + this.must_copy_parent + "\n";
        to_string = String.valueOf(to_string) + "must_process: " + this.must_process + "\n";
        to_string = String.valueOf(to_string) + "must_restore_output: " + this.must_restore_output + "\n";
        return to_string;
    }
}

