/*
 * Decompiled with CFR 0.152.
 */
package common.utils;

import common.utils.ExternalCommand;
import common.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.filechooser.FileSystemView;

public class SystemRar {
    private boolean is_nux = false;
    private boolean is_mac = false;
    private boolean is_win = false;
    private boolean is_oth = false;
    private String unrar_exe = null;
    private String rar_exe = null;
    private ExternalCommand ec = null;

    public SystemRar() {
        String os_name = System.getProperty("os.name").toLowerCase();
        if (os_name.contains("nux") || os_name.contains("nix")) {
            this.is_nux = true;
        } else if (os_name.contains("mac")) {
            this.is_mac = true;
        } else if (os_name.contains("win")) {
            this.is_win = true;
        } else {
            this.is_oth = true;
        }
        this.findUnrarExe();
        this.findRarExe();
        this.ec = new ExternalCommand();
    }

    private void findUnrarExe() {
        File unrar_file = null;
        boolean found_unrar_exe = false;
        if (this.is_nux || this.is_mac) {
            unrar_file = new File("/usr/bin/rar");
            if (unrar_file.exists()) {
                found_unrar_exe = true;
                this.unrar_exe = unrar_file.getAbsolutePath();
            }
            if (!found_unrar_exe && (unrar_file = new File("/usr/bin/unrar")).exists()) {
                found_unrar_exe = true;
                this.unrar_exe = unrar_file.getAbsolutePath();
            }
            if (!found_unrar_exe && (unrar_file = new File("/usr/bin/unrar-free")).exists()) {
                found_unrar_exe = true;
                this.unrar_exe = unrar_file.getAbsolutePath();
            }
            if (!found_unrar_exe && (unrar_file = new File("/usr/local/bin/rar/rar")).exists()) {
                found_unrar_exe = true;
                this.unrar_exe = unrar_file.getAbsolutePath();
            }
        } else if (this.is_win) {
            List<File> roots = Arrays.asList(File.listRoots());
            int i = 0;
            while (!found_unrar_exe && i < roots.size()) {
                char cur_drive_letter;
                File program_files_folder;
                File cur_root = roots.get(i);
                if (FileSystemView.getFileSystemView().getSystemTypeDescription(cur_root).toLowerCase().contains("local") && (program_files_folder = new File(String.valueOf(cur_drive_letter = cur_root.getAbsolutePath().charAt(0)) + ":\\Program Files\\")).exists()) {
                    ArrayList<File> program_files_folder_subfolders = FileUtils.getFolderList(program_files_folder);
                    Collections.sort(program_files_folder_subfolders);
                    if (program_files_folder_subfolders != null) {
                        int j = 0;
                        while (!found_unrar_exe && j < program_files_folder_subfolders.size()) {
                            File cur_folder = program_files_folder_subfolders.get(j);
                            if (cur_folder.getName().toLowerCase().contains("rar")) {
                                ArrayList<File> cur_folder_fileList = FileUtils.getFileList(cur_folder);
                                int k = 0;
                                while (!found_unrar_exe && k < cur_folder_fileList.size()) {
                                    File cur_file = cur_folder_fileList.get(k);
                                    if (cur_file.getName().equalsIgnoreCase("rar.exe") || cur_file.getName().equalsIgnoreCase("unrar.exe")) {
                                        this.unrar_exe = cur_file.getAbsolutePath();
                                        found_unrar_exe = true;
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        if (found_unrar_exe) {
                            j = 0;
                            while (j < this.unrar_exe.length()) {
                                char cur_char = this.unrar_exe.charAt(j);
                                if (cur_char == '\\') {
                                    this.unrar_exe = String.valueOf(this.unrar_exe.substring(0, j)) + "\\\\" + this.unrar_exe.substring(j + 1);
                                    ++j;
                                }
                                ++j;
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void findRarExe() {
        File rar_file = null;
        boolean found_rar_exe = false;
        if (this.is_nux || this.is_mac) {
            rar_file = new File("/usr/bin/rar");
            if (rar_file.exists()) {
                this.rar_exe = rar_file.getAbsolutePath();
                found_rar_exe = true;
            }
            if (!found_rar_exe && (rar_file = new File("/usr/local/bin/rar/rar")).exists()) {
                found_rar_exe = true;
                this.rar_exe = rar_file.getAbsolutePath();
            }
        } else if (this.is_win) {
            List<File> roots = Arrays.asList(File.listRoots());
            int i = 0;
            while (!found_rar_exe && i < roots.size()) {
                char cur_drive_letter;
                File program_files_folder;
                File cur_root = roots.get(i);
                if (FileSystemView.getFileSystemView().getSystemTypeDescription(cur_root).toLowerCase().contains("local") && (program_files_folder = new File(String.valueOf(cur_drive_letter = cur_root.getAbsolutePath().charAt(0)) + ":\\Program Files\\")).exists()) {
                    ArrayList<File> program_files_folder_subfolders = FileUtils.getFolderList(program_files_folder);
                    Collections.sort(program_files_folder_subfolders);
                    if (program_files_folder_subfolders != null) {
                        int j = 0;
                        while (!found_rar_exe && j < program_files_folder_subfolders.size()) {
                            File cur_folder = program_files_folder_subfolders.get(j);
                            if (cur_folder.getName().toLowerCase().contains("rar")) {
                                ArrayList<File> cur_folder_fileList = FileUtils.getFileList(cur_folder);
                                int k = 0;
                                while (!found_rar_exe && k < cur_folder_fileList.size()) {
                                    File cur_file = cur_folder_fileList.get(k);
                                    if (cur_file.getName().equalsIgnoreCase("rar.exe")) {
                                        this.rar_exe = cur_file.getAbsolutePath();
                                        found_rar_exe = true;
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        if (found_rar_exe) {
                            j = 0;
                            while (j < this.rar_exe.length()) {
                                char cur_char = this.rar_exe.charAt(j);
                                if (cur_char == '\\') {
                                    this.rar_exe = String.valueOf(this.rar_exe.substring(0, j)) + "\\\\" + this.rar_exe.substring(j + 1);
                                    ++j;
                                }
                                ++j;
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    public boolean unrarFile(File rar_file, File output_folder) {
        if (!this.canUnrar()) {
            return false;
        }
        if (!output_folder.exists()) {
            FileUtils.recursiveMakeDirectory(output_folder);
        }
        try {
            ArrayList<String> command_list = new ArrayList<String>();
            command_list.add(this.unrar_exe);
            command_list.add("x");
            command_list.add("-r");
            command_list.add("-ep1");
            command_list.add(rar_file.getAbsolutePath());
            command_list.add(String.valueOf(output_folder.getAbsolutePath()) + File.separatorChar);
            String[] command_array = new String[command_list.size()];
            command_array = command_list.toArray(command_array);
            this.ec.runCommand(command_array);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!output_folder.exists()) {
            return false;
        }
        ArrayList<File> files = FileUtils.getFileList(output_folder);
        ArrayList<File> folders = FileUtils.getFolderList(output_folder);
        if (files.size() == 0 && folders.size() == 0) {
            FileUtils.deleteDirectory(output_folder);
            return false;
        }
        return true;
    }

    public boolean rarFolder(File folder, File rar_file) {
        if (!this.canRar()) {
            return false;
        }
        try {
            ArrayList<String> command_list = new ArrayList<String>();
            command_list.add(this.rar_exe);
            command_list.add("a");
            command_list.add("-r");
            command_list.add("-ep1");
            command_list.add(rar_file.getAbsolutePath());
            command_list.add(String.valueOf(folder.getAbsolutePath()) + File.separatorChar);
            String[] command_array = new String[command_list.size()];
            command_array = command_list.toArray(command_array);
            this.ec.runCommand(command_array);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rar_file.exists();
    }

    public ArrayList<String> listRar(File rar_file) {
        if (!this.canUnrar()) {
            return null;
        }
        ArrayList<String> list_rar = new ArrayList<String>();
        try {
            ArrayList<String> command_list = new ArrayList<String>();
            command_list.add(this.unrar_exe);
            command_list.add("lb");
            command_list.add(rar_file.getAbsolutePath());
            String[] command_array = new String[command_list.size()];
            command_array = command_list.toArray(command_array);
            this.ec.runCommand(command_array);
            String command_input = this.ec.getInput();
            String[] command_input_list = command_input.split("\n");
            int i = 0;
            while (i < command_input_list.length) {
                list_rar.add(command_input_list[i]);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list_rar;
    }

    public boolean canUnrar() {
        return this.unrar_exe != null;
    }

    public boolean canRar() {
        return this.rar_exe != null;
    }
}

