// ==UserScript==
// @name           flag insert
// @namespace      ffnet
// @include        http://www.fanfiction.net/s/*
// ==/UserScript==

// The basis from this script was taken from Alssn, UserScript #33325
// http://userscripts.org/scripts/show/33325

cssData = (<r><![CDATA[

#export_menu { 
	display: inline-block;
	margin-right: 1.25em;
}

#export_menu ul {
	display: none;
	margin: 0em;
	position: absolute;
	padding: 0.5em 1.5em;
	background-color: #ddd !important;
	-moz-border-radius: 0.33em;
	border: solid #aaa 2px;
}


#export_menu:hover ul { 
	display: block; 
}

#export_menu ul li { 
	cursor: pointer; 
	margin: 0;
	margin-top: 0.15em;
}

#export_menu ul li:hover { 
	font-weight: bold 
}

]]></r>).toString();


function find(expr)
{
	var posts = document.evaluate(expr, document, null,XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
	var postsArray = new Array();
	for (var i = 0; i < posts.snapshotLength; ++i) {
	     postsArray.push(posts.snapshotItem(i));
	}
	return postsArray;
}


// Taken from StackOverflow
// http://stackoverflow.com/questions/133925/javascript-post-request-like-a-form-submit
function post_to_url(path, params, method) {
    method = method || "post"; // Set method to post by default, if not specified.

    // The rest of this code assumes you are not using a library.
    // It can be made less wordy if you use one.
    var form = document.createElement("form");
    form.setAttribute("method", method);
    form.setAttribute("action", path);

    for(var key in params) {
        var hiddenField = document.createElement("input");
        hiddenField.setAttribute("type", "hidden");
        hiddenField.setAttribute("name", key);
        hiddenField.setAttribute("value", params[key]);

        form.appendChild(hiddenField);
    }

    document.body.appendChild(form);    // Not entirely sure if this is necessary
    form.submit();
}

function flagExport(output_format) {
	var hr=location.href.split('/');
	storyid=hr[4];
	args = { 'storyid': storyid, 'outputformat': output_format };
	post_to_url('http://flag.erayd.net/getstory.php', args);

}

function addButton(){

	// Adding the CSS rules.
	var cssNode = document.createElement('style');
	cssNode.setAttribute('type', 'text/css');
	cssNode.innerHTML = cssData;

	var headID = document.getElementsByTagName("head")[0];         
	headID.appendChild(cssNode);

	// Finding out where our anchor point is.  We want to be just before the font size menu.
	var anchorPoint=null;
	res = find("//table[@style]");
	for (var i in res){
		var tC=res[i].textContent;
		if (tC.indexOf('B s')>=0){
			anchorPoint=res[i].children[0].children[0];
		}
	}
	
	// Creating the list of available formats.	
	var ul=document.createElement('ul');

	var output_formats = { 
		'ePub': function () { flagExport('epub') },
		//'HTML': function () { flagExport('html') },
		'PDF':  function () { flagExport('pdf') },
		'BBeB/LRF': function () { flagExport('lrf') } 
	};

	for ( var label in output_formats) {
		var li=document.createElement('li');
		li.setAttribute('title','Export to '+label);
		li.innerHTML=label;
		li.onclick = output_formats[label];
		ul.appendChild(li);
	}

	// Creating main container.  That's just a div that will contain a label and the formats list.
	var container=document.createElement('div');
	container.setAttribute('id','export_menu');
	var label = document.createElement('span');
	label.innerHTML = 'Export';
	container.appendChild(label);
	container.appendChild(ul);
	anchorPoint.insertBefore(container, anchorPoint.firstChild);
}

//Adding buttons to page;
addButton();

