/*
 * Decompiled with CFR 0.152.
 */
package common.image;

import common.image.ImageData;
import common.utils.ExtFilter;
import common.utils.ExternalCommand;
import common.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import manga.PropertiesLoader;

public class ImageMagick {
    private static String command_identify = "identify";
    private static String command_convert = "convert";
    private static String command_mogrify = "mogrify";
    private static String options_identify_height = "%h";
    private static String options_identify_width = "%w";
    private static String options_identify_dpi = "%x";
    private int width;
    private int height;
    private int max_dpi;
    private int fuzz;
    private String color_mode;
    private int num_colors;
    private boolean use_auto_trim;
    private boolean use_auto_rotate;
    private String image_format;
    private String image_magick_dir;
    public ExternalCommand ec;
    public ExtFilter image_ext_filter;

    public ImageMagick(File properties_file) {
        PropertiesLoader pl = new PropertiesLoader(properties_file);
        this.ec = new ExternalCommand();
        this.image_ext_filter = new ExtFilter("image");
        this.width = pl.getWidth();
        this.height = pl.getHeight();
        this.max_dpi = pl.getMaxDPI();
        this.fuzz = pl.getTrimFuzz();
        this.color_mode = pl.getColorMode();
        this.num_colors = pl.getNumColors();
        this.use_auto_trim = pl.getAutoTrim();
        this.use_auto_rotate = pl.getAutoRotate();
        this.image_format = pl.getImageFormat();
        this.image_magick_dir = pl.getImageMagickDir();
        if (!this.image_format.equals("original") && !this.image_ext_filter.isValid(this.image_format)) {
            System.out.println("Invalid image format: " + this.image_format + "... Defaulting to original image format.");
            this.image_format = "original";
        }
        if (this.color_mode.equalsIgnoreCase("grayscale") || this.color_mode.equalsIgnoreCase("greyscale") || this.color_mode.equalsIgnoreCase("gray") || this.color_mode.equalsIgnoreCase("grey")) {
            this.color_mode = "grayscale";
        } else if (this.color_mode.equalsIgnoreCase("full")) {
            this.color_mode = "full";
        } else {
            System.out.println("Invalid color mode: " + this.color_mode + "... Default to grayscale color mode.");
            this.color_mode = "grayscale";
        }
        if (this.image_magick_dir.charAt(this.image_magick_dir.length() - 1) != File.separatorChar) {
            this.image_magick_dir = String.valueOf(this.image_magick_dir) + File.separatorChar;
        }
    }

    public void processImage(File image_file) {
        if (this.use_auto_trim) {
            this.trimImage(image_file);
        }
        ImageData image_data = this.getImageData(image_file);
        ArrayList<String> options = this.generateImageConvertOptions(image_data);
        if (this.image_format.equalsIgnoreCase("original")) {
            this.mogrifyImage(image_file, options);
        } else {
            String image_file_extension = ExtFilter.getExtension(image_file);
            if (image_file_extension.equalsIgnoreCase(this.image_format)) {
                this.mogrifyImage(image_file, options);
            } else {
                String new_name = image_file.getName();
                int last_period_index = new_name.lastIndexOf(46);
                if (last_period_index != -1) {
                    new_name = new_name.substring(0, last_period_index);
                }
                new_name = String.valueOf(new_name) + this.image_format;
                File new_image_file = new File(String.valueOf(image_file.getParent()) + File.separatorChar + new_name);
                this.convertImage(image_file, new_image_file, options);
                image_file.delete();
            }
        }
    }

    public void preprocessImages(ArrayList<File> image_files) {
        int i = 0;
        while (i < image_files.size()) {
            this.mogrifyImage(image_files.get(i), new ArrayList<String>());
            ++i;
        }
    }

    public ImageData getImageData(File image_file) {
        ImageData img_data = null;
        try {
            ArrayList<String> command_list = new ArrayList<String>();
            command_list.add(String.valueOf(this.image_magick_dir) + command_identify);
            command_list.add("-format");
            command_list.add(options_identify_width);
            command_list.add(image_file.getAbsolutePath());
            String[] command_array = new String[command_list.size()];
            command_array = command_list.toArray(command_array);
            this.ec.runCommand(command_array);
            double width = Double.parseDouble(this.ec.getInput().trim());
            command_list.clear();
            command_list.add(String.valueOf(this.image_magick_dir) + command_identify);
            command_list.add("-format");
            command_list.add(options_identify_height);
            command_list.add(image_file.getAbsolutePath());
            command_array = new String[command_list.size()];
            command_array = command_list.toArray(command_array);
            this.ec.runCommand(command_array);
            double height = Double.parseDouble(this.ec.getInput().trim());
            command_list.clear();
            command_list.add(String.valueOf(this.image_magick_dir) + command_identify);
            command_list.add("-format");
            command_list.add(options_identify_dpi);
            command_list.add(image_file.getAbsolutePath());
            command_array = new String[command_list.size()];
            command_array = command_list.toArray(command_array);
            this.ec.runCommand(command_array);
            String dpi_string = this.ec.getInput();
            double dpi = Double.parseDouble(dpi_string.substring(0, dpi_string.indexOf(32)));
            img_data = new ImageData(width, height, dpi);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return img_data;
    }

    public ArrayList<ImageData> getImageDataOfFolder(File folder) {
        ArrayList<ImageData> ids = new ArrayList<ImageData>();
        ArrayList<File> image_file_list = FileUtils.getImageFileList(folder);
        int i = 0;
        while (i < image_file_list.size()) {
            File image_file = image_file_list.get(i);
            ids.add(this.getImageData(image_file));
            ++i;
        }
        return ids;
    }

    public ArrayList<ImageData> getImageDataOfImageFiles(ArrayList<File> image_files) {
        ArrayList<ImageData> ids = new ArrayList<ImageData>();
        int i = 0;
        while (i < image_files.size()) {
            File image_file = image_files.get(i);
            ids.add(this.getImageData(image_file));
            ++i;
        }
        return ids;
    }

    public void trimImage(File img_file) {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-fuzz");
        options.add(String.valueOf(this.fuzz) + "%");
        options.add("-bordercolor");
        options.add("white");
        options.add("-trim");
        this.mogrifyImage(img_file, options);
    }

    public void splitImage(File input_image, int width, int height, int x_split_pos, boolean right_page_first) {
        String input_image_filename = ExtFilter.getNameWithoutExtension(input_image);
        String input_image_ext = ExtFilter.getExtension(input_image);
        File new_page_1 = new File(String.valueOf(input_image.getParent()) + File.separatorChar + input_image_filename + "split1" + input_image_ext);
        File new_page_2 = new File(String.valueOf(input_image.getParent()) + File.separatorChar + input_image_filename + "split2" + input_image_ext);
        ArrayList<String> options_page_right = new ArrayList<String>();
        ArrayList<String> options_page_left = new ArrayList<String>();
        options_page_right.add("-crop");
        options_page_right.add(String.valueOf(width - x_split_pos) + "x" + height + "+" + x_split_pos + "+0");
        options_page_left.add("-crop");
        options_page_left.add(String.valueOf(x_split_pos) + "x" + height + "+0+0");
        if (right_page_first) {
            this.convertImage(input_image, new_page_2, options_page_left);
            this.convertImage(input_image, new_page_1, options_page_right);
        } else {
            this.convertImage(input_image, new_page_1, options_page_left);
            this.convertImage(input_image, new_page_2, options_page_right);
        }
    }

    public void addBorderEdge(ImageData img_data, File img_file, int border_size, String border_side, String border_color) {
        ArrayList<String> options = new ArrayList<String>();
        if (border_side.equalsIgnoreCase("top") || border_side.equalsIgnoreCase("bottom")) {
            options.add("-border");
            options.add("0x" + border_size);
        } else if (border_side.equalsIgnoreCase("left") || border_side.equalsIgnoreCase("right")) {
            options.add("-border");
            options.add(String.valueOf(border_size) + "x0");
        }
        options.add("-bordercolor");
        options.add(border_color);
        if (border_side.equalsIgnoreCase("top")) {
            options.add("-crop");
            options.add("0x" + (img_data.height + (double)border_size) + "+0+0");
            options.add("-gravity");
            options.add("North");
        } else if (border_side.equalsIgnoreCase("bottom")) {
            options.add("-crop");
            options.add("0x" + (img_data.height + (double)border_size) + "+0+0");
            options.add("-gravity");
            options.add("South");
        } else if (border_side.equalsIgnoreCase("left")) {
            options.add("-crop");
            options.add(String.valueOf(img_data.width + (double)border_size) + "x0+0+0");
            options.add("-gravity");
            options.add("West");
        } else if (border_side.equalsIgnoreCase("right")) {
            options.add("-crop");
            options.add(String.valueOf(img_data.width + (double)border_size) + "x0+0+0");
            options.add("-gravity");
            options.add("East");
        }
        this.mogrifyImage(img_file, options);
        if (border_side.equalsIgnoreCase("top") || border_side.equalsIgnoreCase("bottom")) {
            img_data.height += (double)border_size;
        } else if (border_side.equalsIgnoreCase("left") || border_side.equalsIgnoreCase("right")) {
            img_data.width += (double)border_size;
        }
    }

    public ArrayList<String> generateImageConvertOptions(ImageData img_data) {
        ArrayList<String> options = new ArrayList<String>();
        double destH = this.height;
        double destW = this.width;
        boolean dont_resize = false;
        if (this.height == -1) {
            destH = img_data.height;
        }
        if (this.width == -1) {
            destW = img_data.width;
        }
        if (this.height == -1 && this.width == -1) {
            dont_resize = true;
        }
        boolean portrait = false;
        if (img_data.width > img_data.height) {
            portrait = true;
        }
        boolean change_dpi = false;
        if (img_data.dpi > (double)this.max_dpi) {
            change_dpi = true;
        }
        if (this.color_mode.equals("grayscale")) {
            options.add("-type");
            options.add("Grayscale");
        }
        if (this.num_colors != -1) {
            options.add("-colors");
            options.add(String.valueOf(this.num_colors));
        }
        if (!dont_resize) {
            if (portrait) {
                options.add("-resize");
                options.add(String.valueOf(destH) + "x" + destW);
            } else {
                options.add("-resize");
                options.add(String.valueOf(destW) + "x" + destH);
            }
        }
        if (change_dpi) {
            options.add("-density");
            options.add(String.valueOf(this.max_dpi));
        } else {
            options.add("-density");
            options.add(String.valueOf(img_data.dpi));
        }
        if (portrait && this.use_auto_rotate) {
            options.add("-rotate");
            options.add("-90");
        }
        return options;
    }

    public void convertImage(File in_img_file, File out_img_file, ArrayList<String> options) {
        try {
            ArrayList<String> command_list = new ArrayList<String>();
            command_list.add(String.valueOf(this.image_magick_dir) + command_convert);
            int i = 0;
            while (i < options.size()) {
                command_list.add(options.get(i));
                ++i;
            }
            command_list.add(in_img_file.getAbsolutePath());
            command_list.add(out_img_file.getAbsolutePath());
            String[] command_array = new String[command_list.size()];
            command_array = command_list.toArray(command_array);
            this.ec.runCommand(command_array);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void pdfImageFolder(File folder, File out_pdf_file) {
        ArrayList<File> image_files = FileUtils.getImageFileList(folder);
        Collections.sort(image_files);
        try {
            ArrayList<String> command_list = new ArrayList<String>();
            command_list.add(String.valueOf(this.image_magick_dir) + command_convert);
            int i = 0;
            while (i < image_files.size()) {
                command_list.add(image_files.get(i).getAbsolutePath());
                ++i;
            }
            command_list.add(out_pdf_file.getAbsolutePath());
            String[] command_array = new String[command_list.size()];
            command_array = command_list.toArray(command_array);
            this.ec.runCommand(command_array);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void convertPdfToImageFolder(File pdf_file, File output_folder) {
        if (!output_folder.exists()) {
            FileUtils.recursiveMakeDirectory(output_folder);
        }
        String image_ext = null;
        image_ext = this.image_format == null || this.image_format.equals("original") ? ".jpg" : this.image_format;
        if (image_ext.charAt(0) != '.') {
            image_ext = "." + image_ext;
        }
        try {
            ArrayList<String> command_list = new ArrayList<String>();
            command_list.add(String.valueOf(this.image_magick_dir) + command_convert);
            command_list.add("-density");
            command_list.add("150");
            command_list.add(pdf_file.getAbsolutePath());
            command_list.add(String.valueOf(output_folder.getAbsolutePath()) + File.separatorChar + "%d" + image_ext);
            String[] command_array = new String[command_list.size()];
            command_array = command_list.toArray(command_array);
            this.ec.runCommand(command_array);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getNumPagesPdf(File pdf_file) {
        int num_pages = -1;
        if (!pdf_file.exists()) {
            return -1;
        }
        ArrayList<String> command_list = new ArrayList<String>();
        command_list.add(String.valueOf(this.image_magick_dir) + command_identify);
        command_list.add("-format");
        command_list.add("%n");
        command_list.add(pdf_file.getAbsolutePath());
        String[] command_array = new String[command_list.size()];
        command_array = command_list.toArray(command_array);
        try {
            this.ec.runCommand(command_array);
            num_pages = Integer.parseInt(this.ec.getInput().trim());
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        return num_pages;
    }

    public void mogrifyImage(File image_file, ArrayList<String> options) {
        try {
            ArrayList<String> command_list = new ArrayList<String>();
            command_list.add(String.valueOf(this.image_magick_dir) + command_mogrify);
            int i = 0;
            while (i < options.size()) {
                command_list.add(options.get(i));
                ++i;
            }
            command_list.add(image_file.getAbsolutePath());
            String[] command_array = new String[command_list.size()];
            command_array = command_list.toArray(command_array);
            this.ec.runCommand(command_array);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

