import os
import re
import sys

#Insert header or footer information into output file 
def insertToFile(to_insert, file_out):
    insert = open(to_insert, 'r')
    file_out.write(insert.read())
    insert.close()

#List HTML files in directory, including subdirectories.
#Include said files in output file.
def insertHtmlFiles(file_out, prefix, postfix, directory, filename_out, reldirpath, indexfile):
    #Do some magic to ensure relative paths
    current_path = os.path.split(os.getcwd())
    changedown = False
    if not current_path[1] == directory:
        changedown = True;
        os.chdir(directory)
    #Iterate over objects 
    dir = os.listdir(os.getcwd())
    for d in dir:
        if d == filename_out:
            #This is the file we're trying to create
            break
        elif d == indexfile:
            #This is the index file, it's already been written
            break
        elif os.path.isdir(d):
            #Directory, recurse through it
            insertHtmlFiles(file_out, prefix, postfix, d, filename_out, os.path.join(reldirpath,d), indexfile)
        elif os.path.isfile(d):
            #File, check for HTML, if it is, enter in TOC
            if (re.match("(?i).*?\.htm", d) or re.match("(?i).*?\.html", d)) is not None:
                file_out.write(prefix + os.path.join(reldirpath,d) + postfix + "\n")
    #This is only necessary if we changed up a level            
    if changedown:            
        os.chdir("..")

#Start of the main stuff
tocfile = sys.argv[1] #Output filename
indexfile = sys.argv[2] #Filename of index file
file = open("prefix", 'r')
prefix = file.read() #prefix to individual entries
file.close()
file = open("postfix", 'r')
postfix = file.read() #postfix to individual entries
file.close
outfile = open(tocfile, 'w')
insertToFile("header", outfile)
startdir = os.path.split(os.getcwd())
#The index file should go in first position:
if os.path.isfile(indexfile):
    outfile.write(prefix + indexfile + postfix + "\n")
reldirpath = ""
insertHtmlFiles(outfile, prefix, postfix, startdir[1], tocfile, reldirpath, indexfile)
insertToFile("footer", outfile)
outfile.close()