/*
 * File Name: main.c
 */

/*
 * This file is part of ctb.
 *
 * ctb is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * ctb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <unistd.h>

#include "ctb_log.h"
#include "fileview.h"
#include "filemodel.h"
#include "i18n.h"
#include "ipc.h"
#include "menu.h"

//----------------------------------------------------------------------------
// Global Constants
//----------------------------------------------------------------------------

static const char  *rc_filename = DATADIR "/" PACKAGE_NAME ".rc";

static const char  *EMULATOR_HOSTNAME = "qemuarm";


void main_set_locale (const char *locale)
{
    LOGPRINTF("entry: locale [%s]", locale);

    const char *old_locale = g_getenv("LANG");
    
    if (!old_locale || (strcmp(old_locale, locale) != 0))
    {
        LOGPRINTF("Locale has changed to %s", locale);

        // set locale in environment 
        g_setenv("LANG", locale, TRUE);
        setlocale(LC_ALL, "");
        
        // update text and refresh
        menu_set_text();
        fileview_update_screen_texts();
    }
}


void main_quit (void)
{
    gtk_main_quit();
}


static gboolean on_startup_complete (gpointer data)
{
    ipc_sys_startup_complete();
    return FALSE; // remove timer source
}


int main (int argc, char *argv[])
{
    textdomain(GETTEXT_PACKAGE);
    
    gtk_init(&argc, &argv);
    gchar** files = gtk_rc_get_default_files();
    while (*files)
    {
        LOGPRINTF("gtk_rc_get_default_files [%s]", *files);
        files++;
    }

    ipc_init(main_quit, main_set_locale, fileview_media_mounted, fileview_media_unmounted);
    menu_init();
    fileview_init();

    LOGPRINTF("gtk_rc_parse [%s]", rc_filename);
    gtk_rc_parse(rc_filename);

    fileview_create();

    // debug: mount "internal SD" when running on emulator
    char hostname[100];
    int rc = gethostname(hostname, sizeof(hostname));
    if (   rc == 0
        && strcmp(hostname, EMULATOR_HOSTNAME) == 0 )
    {
        WARNPRINTF("Emulator mode: mounting fake card");
        storage_media_mounted(DIR_LIBRARY);
    }

    g_idle_add(on_startup_complete, NULL);
    gdk_threads_enter();
    gtk_main();
    gdk_threads_leave();

    fileview_destroy();

    return 0;
}

