#ifndef __FILEVIEW_H__
#define __FILEVIEW_H__

/**
 * File Name  : fileview.h
 *
 * Description: Content browser screens to display files
 *              for both portrait and landscape mode
 */

/*
 * This file is part of ctb.
 *
 * ctb is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * ctb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */


//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

#include <gtk/gtk.h>

#include "filemodel.h"

G_BEGIN_DECLS


//----------------------------------------------------------------------------
// Macro Definitions
//---------------------------------------------------------------------------- 


//----------------------------------------------------------------------------
// Forward Declarations
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------

// the different views of content browser
// note: corresponds to gtk_notebook page as used in fileview.c
typedef enum
        {
            CTB_ICONVIEW = 0,
            CTB_LISTVIEW,
            CTB_CONTENTVIEW,
            CTB_AUTOSELECT,
            N_CTB_VIEWS
        } ctb_viewtypes_t;


/**---------------------------------------------------------------------------
 *
 * Name :  fileview_init
 *
 * @brief  Initialisation
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void fileview_init();

void fileview_destroy();

int fileview_letters_count_get();
const gchar** fileview_letters_get();

/**---------------------------------------------------------------------------
 *
 * Name :  fileview_update_screen_texts
 *
 * @brief  Update screen texts, using current language setting
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void fileview_update_screen_texts();


void fileview_create();


/**---------------------------------------------------------------------------
 *
 * Name :  fileview_set_view_type
 *
 * @brief  Select which view to use for displaying the files
 *
 * @param  [in]  view - requested view type
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void fileview_set_view_type (const ctb_viewtypes_t view, gboolean do_cursor);

void fileview_save_view_type();


/**---------------------------------------------------------------------------
 *
 * Name :  fileview_set_sort_order
 *
 * @brief  Set sorting order for items in view
 *
 * @param  [in]  sort_order - requested sorting order
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void fileview_set_sort_order (const ctb_sort_order_t sort_order);


void fileview_dir_up();

void fileview_dir_down(const gchar *dir, const char* cursorname);

/**---------------------------------------------------------------------------
 *
 * Name :  fileview_show_desktop
 *
 * @brief  Show content of the desktop
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void fileview_show_desktop();


// take control of GUI display update system
void fileview_stop_update_display();

/**---------------------------------------------------------------------------
 *
 * Name :  fileview_media_mounted
 *
 * @brief  Notification that a storage device has been mounted
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void fileview_media_mounted (const gchar *mountpoint);


/**---------------------------------------------------------------------------
 *
 * Name :  fileview_media_unmounted
 *
 * @brief  Notification that the storage device will be (has been) unmounted
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void fileview_media_unmounted ();


/**---------------------------------------------------------------------------
 *
 * Name :  fileview_refresh
 *
 * @brief  Refresh the current screen data, keep cursor at same item if possible
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void fileview_refresh(gboolean force_reload);

void fileview_show_search_dialog();

void fileview_show_prev_page();

void fileview_show_next_page();


void fileview_toggle_delete_mode();


/**---------------------------------------------------------------------------
 *
 * Name :  fileview_create_shortcut
 *
 * @brief  Create desktop shortcut(s) for the currently selected item(s)
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void fileview_create_shortcut();


/**---------------------------------------------------------------------------
 *
 * Name :  fileview_grab_focus
 *
 * @brief  Grab focus for current view
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void fileview_grab_focus( void );

void  show_error_dialog(const gchar *msg);

int fileview_get_xid();

void fileview_set_on_top(gboolean ontop);

// popupmenu menubar += 10 pixels
void fileview_move_up(guint delta);
void fileview_move_undo();

G_END_DECLS

#endif

