#!/bin/sh

THISDIR=/media/mmcblk0p1/Programs/_dr800+

if [ -f $THISDIR/dr800+.installed ]; then
    echo "Restoring original DR800 version"
    cp $THISDIR/orig/uds.dr800        /usr/bin/uds
    cp $THISDIR/orig/ctb.dr800        /usr/bin/ctb
    cp $THISDIR/orig/ctb.rc.dr800     /usr/share/ctb/ctb.rc
    cp $THISDIR/orig/popupmenu.dr800  /usr/bin/popupmenu
    cp $THISDIR/orig/idle.sh.dr800    /usr/bin/idle.sh
    cp $THISDIR/orig/erbrowser.dr800  /usr/bin/erbrowser
    cp $THISDIR/orig/notepad.dr800    /usr/bin/notepad
    rm /usr/share/icons/toolbar_*.png
    rm $THISDIR/dr800+.installed
    /sbin/reboot
    sleep 31
else
    echo "Installing DR800+ version"
    if [ -s $THISDIR/new/uds.dr1000 ]; then # install only if nonzero uds.dr1000 file
        # first backup original programs, only if they don't exist
	if [ ! -f $THISDIR/orig/ctb.dr800 ]; then
	    cp /usr/bin/uds           $THISDIR/orig/uds.dr800
	    cp /usr/bin/ctb           $THISDIR/orig/ctb.dr800
	    cp /usr/share/ctb/ctb.rc  $THISDIR/orig/ctb.rc.dr800
	    cp /usr/bin/popupmenu     $THISDIR/orig/popupmenu.dr800
	    cp /usr/bin/idle.sh       $THISDIR/orig/idle.sh.dr800
	    cp /usr/bin/erbrowser     $THISDIR/orig/erbrowser.dr800
	    cp /usr/bin/notepad       $THISDIR/orig/notepad.dr800
	fi
        # copy new files
	cp $THISDIR/new/uds.dr1000        /usr/bin/uds
	cp $THISDIR/new/ctb.dr800+        /usr/bin/ctb
	cp $THISDIR/new/ctb.rc.dr800+     /usr/share/ctb/ctb.rc
	cp $THISDIR/new/popupmenu.dr800+  /usr/bin/popupmenu
	cp $THISDIR/new/idle.sh.dr800+    /usr/bin/idle.sh
	cp $THISDIR/new/erbrowser.dr800+  /usr/bin/erbrowser
	cp $THISDIR/new/notepad.dr800+    /usr/bin/notepad
	cp $THISDIR/new/usr_share_icons/toolbar_*.png /usr/share/icons
        # store "package is installed"
	touch $THISDIR/dr800+.installed
        /sbin/reboot
        sleep 31
    else
	echo "uds.dr1000 is not a valid file. Can't install DR800+"
    fi
fi
