<?xml version="1.0" ?>
<xsl:stylesheet version="1.0" xmlns:idx="www.mobipocket.com" xmlns:mbp="www.mobipocket.com" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xlink="http://www.w3.org/1999/xlink">
<xsl:output method="xml"/>


 <xsl:template match="dictionary">
<html>
<body>


<mbp:pagebreak/>
<mbp:frameset>
		<xsl:call-template name="bottom_frame"/>
		<xsl:call-template name="top_frame" />
		

<mbp:pagebreak crossable="no"/>
<xsl:for-each select="word">
  <idx:entry name="word" scriptable="yes">
  	<xsl:attribute name="id">
	  <xsl:value-of select="id" />
	</xsl:attribute>
	<h2><idx:orth><xsl:value-of select="orth"/> </idx:orth></h2>
	<br/>
	<ul>
	<idx:gramgrp>
		<xsl:attribute name="value">
		  <xsl:value-of select="gramgrp" />
		</xsl:attribute>
		<li>grammatical group : <xsl:value-of select="gramgrp" /></li><br/>
		<xsl:attribute name="infl">
		  <xsl:value-of select="infl" />
		</xsl:attribute>
		<li>inflexions :  <xsl:value-of select="infl" /></li><br/>
	</idx:gramgrp>
	<li>definition : <xsl:value-of select="definition"/></li><br/>
   	<idx:string name="usage">
		<xsl:attribute name="value">
		  <xsl:value-of select="usage" />
		</xsl:attribute>
	</idx:string>
	<li>usage : <xsl:value-of select="usage"/></li><br/>
	<mbp:pagebreak/>
	<idx:subentry name="etymology">
	<li>etymology : <xsl:value-of select="etymology"/></li><br/>
   	</idx:subentry>
   	</ul>
    <br/>
   </idx:entry>
<mbp:pagebreak crossable="no"/>
</xsl:for-each>
</mbp:frameset>
<xsl:apply-templates select="word"/>
</body> 
</html> 
</xsl:template>


<xsl:template match="thesaurus">
<mbp:frameset>
	<xsl:call-template name="top_frame_thesaurus" />
	<idx:ext-subentry name="thesaurus">
	<xsl:attribute name="extends">
	<xsl:value-of select="../id" />
	</xsl:attribute>
	<xsl:value-of select="."/>
	</idx:ext-subentry>
</mbp:frameset>
</xsl:template>

<xsl:template match="orth|id|infl|usage|gramgrp|etymology|definition"/>



<xsl:template name="bottom_frame">
	<mbp:slave-frame display="bottom" device="all" breadth="auto" leftmargin="0" rightmargin="0" bottommargin="0" topmargin="0">
	<div align="center" bgcolor="yellow"/>	
	<a onclick="f_on_usage()">usage</a><xsl:text> </xsl:text>
	<a onclick="f_on_etymology()">etymology</a><xsl:text> </xsl:text>
	<a onclick="f_on_thesaurus()">thesaurus</a>
	</mbp:slave-frame>
</xsl:template>
<xsl:template name="top_frame">
	<mbp:slave-frame display="top" device="all" breadth="auto" topmargin="0" leftmargin="0" rightmargin="0" bottommargin="0">
	<div align="center" bgcolor="blue">
	<h3><font color="white"> 	Dictionary  </font>
	</h3>	
	</div>
	</mbp:slave-frame>
</xsl:template>
<xsl:template name="top_frame_thesaurus">
	<mbp:slave-frame display="top" device="all" breadth="auto" topmargin="0" leftmargin="0" rightmargin="0" bottommargin="0">
	<div align="center" bgcolor="green">
	<h3><font color="white"> Thesaurus Dictionary  </font>
	</h3>	
	</div>
	</mbp:slave-frame>
</xsl:template>


</xsl:stylesheet>